/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.exportimport.service.impl;

import com.liferay.document.library.kernel.util.DLValidatorUtil;
import com.liferay.exportimport.kernel.controller.ExportController;
import com.liferay.exportimport.kernel.controller.ExportImportControllerRegistryUtil;
import com.liferay.exportimport.kernel.controller.ImportController;
import com.liferay.exportimport.kernel.exception.ExportImportIOException;
import com.liferay.exportimport.kernel.exception.ExportImportRuntimeException;
import com.liferay.exportimport.kernel.exception.LARFileNameException;
import com.liferay.exportimport.kernel.lar.MissingReferences;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskManagerUtil;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portlet.exportimport.service.base.ExportImportLocalServiceBaseImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class ExportImportLocalServiceImpl
extends ExportImportLocalServiceBaseImpl {
    public File exportLayoutsAsFile(ExportImportConfiguration exportImportConfiguration) throws PortalException {
        try {
            ExportController layoutExportController = ExportImportControllerRegistryUtil.getExportController((String)Layout.class.getName());
            return layoutExportController.export(exportImportConfiguration);
        }
        catch (PortalException portalException) {
            throw portalException;
        }
        catch (Exception exception) {
            ExportImportRuntimeException exportImportRuntimeException = new ExportImportRuntimeException(exception.getLocalizedMessage(), (Throwable)exception);
            exportImportRuntimeException.setClassName(ExportImportLocalServiceImpl.class.getName());
            throw exportImportRuntimeException;
        }
    }

    public long exportLayoutsAsFileInBackground(long userId, ExportImportConfiguration exportImportConfiguration) throws PortalException {
        if (!DLValidatorUtil.isValidName((String)exportImportConfiguration.getName())) {
            throw new LARFileNameException(exportImportConfiguration.getName());
        }
        BackgroundTask backgroundTask = BackgroundTaskManagerUtil.addBackgroundTask((long)userId, (long)exportImportConfiguration.getGroupId(), (String)exportImportConfiguration.getName(), (String)"com.liferay.exportimport.internal.background.task.LayoutExportBackgroundTaskExecutor", (Map)HashMapBuilder.put((Object)"exportImportConfigurationId", (Object)exportImportConfiguration.getExportImportConfigurationId()).build(), (ServiceContext)new ServiceContext());
        return backgroundTask.getBackgroundTaskId();
    }

    public long exportLayoutsAsFileInBackground(long userId, long exportImportConfigurationId) throws PortalException {
        return this.exportLayoutsAsFileInBackground(userId, this.exportImportConfigurationLocalService.getExportImportConfiguration(exportImportConfigurationId));
    }

    public File exportPortletInfoAsFile(ExportImportConfiguration exportImportConfiguration) throws PortalException {
        try {
            ExportController portletExportController = ExportImportControllerRegistryUtil.getExportController((String)Portlet.class.getName());
            return portletExportController.export(exportImportConfiguration);
        }
        catch (PortalException portalException) {
            throw portalException;
        }
        catch (Exception exception) {
            ExportImportRuntimeException exportImportRuntimeException = new ExportImportRuntimeException(exception.getLocalizedMessage(), (Throwable)exception);
            exportImportRuntimeException.setClassName(ExportImportLocalServiceImpl.class.getName());
            throw exportImportRuntimeException;
        }
    }

    public long exportPortletInfoAsFileInBackground(long userId, ExportImportConfiguration exportImportConfiguration) throws PortalException {
        String fileName = MapUtil.getString((Map)exportImportConfiguration.getSettingsMap(), (String)"fileName");
        if (!DLValidatorUtil.isValidName((String)fileName)) {
            throw new LARFileNameException(fileName);
        }
        BackgroundTask backgroundTask = BackgroundTaskManagerUtil.addBackgroundTask((long)userId, (long)exportImportConfiguration.getGroupId(), (String)exportImportConfiguration.getName(), (String)"com.liferay.exportimport.internal.background.task.PortletExportBackgroundTaskExecutor", (Map)HashMapBuilder.put((Object)"exportImportConfigurationId", (Object)exportImportConfiguration.getExportImportConfigurationId()).build(), (ServiceContext)new ServiceContext());
        return backgroundTask.getBackgroundTaskId();
    }

    public long exportPortletInfoAsFileInBackground(long userId, long exportImportConfigurationId) throws PortalException {
        return this.exportPortletInfoAsFileInBackground(userId, this.exportImportConfigurationLocalService.getExportImportConfiguration(exportImportConfigurationId));
    }

    public void importLayouts(ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        try {
            ImportController layoutImportController = ExportImportControllerRegistryUtil.getImportController((String)Layout.class.getName());
            layoutImportController.importFile(exportImportConfiguration, file);
        }
        catch (PortalException portalException) {
            Throwable throwable = portalException.getCause();
            if (throwable instanceof LocaleException) {
                throw (PortalException)throwable;
            }
            throw portalException;
        }
        catch (SystemException systemException) {
            throw systemException;
        }
        catch (Exception exception) {
            ExportImportRuntimeException exportImportRuntimeException = new ExportImportRuntimeException(exception.getLocalizedMessage(), (Throwable)exception);
            exportImportRuntimeException.setClassName(ExportImportLocalServiceImpl.class.getName());
            throw exportImportRuntimeException;
        }
    }

    public void importLayouts(ExportImportConfiguration exportImportConfiguration, InputStream inputStream) throws PortalException {
        File file = null;
        try {
            file = FileUtil.createTempFile((String)"lar");
            FileUtil.write((File)file, (InputStream)inputStream);
            this.importLayouts(exportImportConfiguration, file);
        }
        catch (IOException ioException) {
            ExportImportIOException exportImportIOException = new ExportImportIOException(ExportImportLocalServiceImpl.class.getName(), (Throwable)ioException);
            if (file != null) {
                exportImportIOException.setFileName(file.getName());
                exportImportIOException.setType(6);
            } else {
                exportImportIOException.setType(5);
            }
            throw exportImportIOException;
        }
        finally {
            FileUtil.delete((File)file);
        }
    }

    public void importLayoutsDataDeletions(ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        try {
            ImportController layoutImportController = ExportImportControllerRegistryUtil.getImportController((String)Layout.class.getName());
            layoutImportController.importDataDeletions(exportImportConfiguration, file);
        }
        catch (PortalException portalException) {
            Throwable throwable = portalException.getCause();
            if (throwable instanceof LocaleException) {
                throw (PortalException)throwable;
            }
            throw portalException;
        }
        catch (SystemException systemException) {
            throw systemException;
        }
        catch (Exception exception) {
            ExportImportRuntimeException exportImportRuntimeException = new ExportImportRuntimeException(exception.getLocalizedMessage(), (Throwable)exception);
            exportImportRuntimeException.setClassName(ExportImportLocalServiceImpl.class.getName());
            throw exportImportRuntimeException;
        }
    }

    public long importLayoutSetPrototypeInBackground(long userId, ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        BackgroundTask backgroundTask = BackgroundTaskManagerUtil.addBackgroundTask((long)userId, (long)exportImportConfiguration.getGroupId(), (String)exportImportConfiguration.getName(), (String)"com.liferay.exportimport.internal.background.task.LayoutSetPrototypeImportBackgroundTaskExcecutor", (Map)HashMapBuilder.put((Object)"exportImportConfigurationId", (Object)exportImportConfiguration.getExportImportConfigurationId()).build(), (ServiceContext)new ServiceContext());
        backgroundTask.addAttachment(userId, file.getName(), file);
        return backgroundTask.getBackgroundTaskId();
    }

    public long importLayoutsInBackground(long userId, ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        BackgroundTask backgroundTask = BackgroundTaskManagerUtil.addBackgroundTask((long)userId, (long)exportImportConfiguration.getGroupId(), (String)exportImportConfiguration.getName(), (String)"com.liferay.exportimport.internal.background.task.LayoutImportBackgroundTaskExecutor", (Map)HashMapBuilder.put((Object)"exportImportConfigurationId", (Object)exportImportConfiguration.getExportImportConfigurationId()).build(), (ServiceContext)new ServiceContext());
        backgroundTask.addAttachment(userId, file.getName(), file);
        return backgroundTask.getBackgroundTaskId();
    }

    public long importLayoutsInBackground(long userId, ExportImportConfiguration exportImportConfiguration, InputStream inputStream) throws PortalException {
        File file = null;
        try {
            file = FileUtil.createTempFile((String)"lar");
            FileUtil.write((File)file, (InputStream)inputStream);
            long l = this.importLayoutsInBackground(userId, exportImportConfiguration, file);
            return l;
        }
        catch (IOException ioException) {
            ExportImportIOException exportImportIOException = new ExportImportIOException(ExportImportLocalServiceImpl.class.getName(), (Throwable)ioException);
            if (file != null) {
                exportImportIOException.setFileName(file.getName());
                exportImportIOException.setType(6);
            } else {
                exportImportIOException.setType(5);
            }
            throw exportImportIOException;
        }
        finally {
            FileUtil.delete((File)file);
        }
    }

    public long importLayoutsInBackground(long userId, long exportImportConfigurationId, File file) throws PortalException {
        return this.importPortletInfoInBackground(userId, this.exportImportConfigurationLocalService.getExportImportConfiguration(exportImportConfigurationId), file);
    }

    public long importLayoutsInBackground(long userId, long exportImportConfigurationId, InputStream inputStream) throws PortalException {
        return this.importLayoutsInBackground(userId, this.exportImportConfigurationLocalService.getExportImportConfiguration(exportImportConfigurationId), inputStream);
    }

    public void importPortletDataDeletions(ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        try {
            ImportController portletImportController = ExportImportControllerRegistryUtil.getImportController((String)Portlet.class.getName());
            portletImportController.importDataDeletions(exportImportConfiguration, file);
        }
        catch (PortalException portalException) {
            Throwable throwable = portalException.getCause();
            if (throwable instanceof LocaleException) {
                throw (PortalException)throwable;
            }
            throw portalException;
        }
        catch (SystemException systemException) {
            throw systemException;
        }
        catch (Exception exception) {
            ExportImportRuntimeException exportImportRuntimeException = new ExportImportRuntimeException(exception.getLocalizedMessage(), (Throwable)exception);
            exportImportRuntimeException.setClassName(ExportImportLocalServiceImpl.class.getName());
            throw exportImportRuntimeException;
        }
    }

    public void importPortletInfo(ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        try {
            ImportController portletImportController = ExportImportControllerRegistryUtil.getImportController((String)Portlet.class.getName());
            portletImportController.importFile(exportImportConfiguration, file);
        }
        catch (PortalException portalException) {
            for (Throwable throwable = portalException.getCause(); throwable != null; throwable = throwable.getCause()) {
                if (throwable instanceof LocaleException) {
                    throw (PortalException)throwable;
                }
                if (!(throwable instanceof PortletDataException)) break;
            }
            throw portalException;
        }
        catch (SystemException systemException) {
            throw systemException;
        }
        catch (Exception exception) {
            ExportImportRuntimeException exportImportRuntimeException = new ExportImportRuntimeException(exception.getLocalizedMessage(), (Throwable)exception);
            exportImportRuntimeException.setClassName(ExportImportLocalServiceImpl.class.getName());
            throw exportImportRuntimeException;
        }
    }

    public void importPortletInfo(ExportImportConfiguration exportImportConfiguration, InputStream inputStream) throws PortalException {
        File file = null;
        try {
            file = FileUtil.createTempFile((String)"lar");
            FileUtil.write((File)file, (InputStream)inputStream);
            this.importPortletInfo(exportImportConfiguration, file);
        }
        catch (IOException ioException) {
            ExportImportIOException exportImportIOException = new ExportImportIOException(ExportImportLocalServiceImpl.class.getName(), (Throwable)ioException);
            if (file != null) {
                exportImportIOException.setFileName(file.getName());
                exportImportIOException.setType(11);
            } else {
                exportImportIOException.setType(10);
            }
            throw exportImportIOException;
        }
        finally {
            FileUtil.delete((File)file);
        }
    }

    public long importPortletInfoInBackground(long userId, ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        BackgroundTask backgroundTask = BackgroundTaskManagerUtil.addBackgroundTask((long)userId, (long)exportImportConfiguration.getGroupId(), (String)exportImportConfiguration.getName(), (String)"com.liferay.exportimport.internal.background.task.PortletImportBackgroundTaskExecutor", (Map)HashMapBuilder.put((Object)"exportImportConfigurationId", (Object)exportImportConfiguration.getExportImportConfigurationId()).build(), (ServiceContext)new ServiceContext());
        backgroundTask.addAttachment(userId, file.getName(), file);
        return backgroundTask.getBackgroundTaskId();
    }

    public long importPortletInfoInBackground(long userId, ExportImportConfiguration exportImportConfiguration, InputStream inputStream) throws PortalException {
        File file = null;
        try {
            file = FileUtil.createTempFile((String)"lar");
            FileUtil.write((File)file, (InputStream)inputStream);
            long l = this.importPortletInfoInBackground(userId, exportImportConfiguration, file);
            return l;
        }
        catch (IOException ioException) {
            ExportImportIOException exportImportIOException = new ExportImportIOException(ExportImportLocalServiceImpl.class.getName(), (Throwable)ioException);
            if (file != null) {
                exportImportIOException.setFileName(file.getName());
                exportImportIOException.setType(11);
            } else {
                exportImportIOException.setType(10);
            }
            throw exportImportIOException;
        }
        finally {
            FileUtil.delete((File)file);
        }
    }

    public long importPortletInfoInBackground(long userId, long exportImportConfigurationId, File file) throws PortalException {
        return this.importPortletInfoInBackground(userId, this.exportImportConfigurationLocalService.getExportImportConfiguration(exportImportConfigurationId), file);
    }

    public long importPortletInfoInBackground(long userId, long exportImportConfigurationId, InputStream inputStream) throws PortalException {
        return this.importPortletInfoInBackground(userId, this.exportImportConfigurationLocalService.getExportImportConfiguration(exportImportConfigurationId), inputStream);
    }

    public MissingReferences validateImportLayoutsFile(ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        try {
            ImportController layoutImportController = ExportImportControllerRegistryUtil.getImportController((String)Layout.class.getName());
            return layoutImportController.validateFile(exportImportConfiguration, file);
        }
        catch (PortalException portalException) {
            Throwable throwable = portalException.getCause();
            if (throwable instanceof LocaleException) {
                throw (PortalException)throwable;
            }
            throw portalException;
        }
        catch (SystemException systemException) {
            throw systemException;
        }
        catch (Exception exception) {
            ExportImportRuntimeException exportImportRuntimeException = new ExportImportRuntimeException(exception.getLocalizedMessage(), (Throwable)exception);
            exportImportRuntimeException.setClassName(ExportImportLocalServiceImpl.class.getName());
            throw exportImportRuntimeException;
        }
    }

    public MissingReferences validateImportLayoutsFile(ExportImportConfiguration exportImportConfiguration, InputStream inputStream) throws PortalException {
        File file = null;
        try {
            file = FileUtil.createTempFile((String)"lar");
            FileUtil.write((File)file, (InputStream)inputStream);
            MissingReferences missingReferences = this.validateImportLayoutsFile(exportImportConfiguration, file);
            return missingReferences;
        }
        catch (IOException ioException) {
            ExportImportIOException exportImportIOException = new ExportImportIOException(ExportImportLocalServiceImpl.class.getName(), (Throwable)ioException);
            if (file != null) {
                exportImportIOException.setFileName(file.getName());
                exportImportIOException.setType(8);
            } else {
                exportImportIOException.setType(7);
            }
            throw exportImportIOException;
        }
        finally {
            FileUtil.delete((File)file);
        }
    }

    public MissingReferences validateImportPortletInfo(ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        try {
            ImportController portletImportController = ExportImportControllerRegistryUtil.getImportController((String)Portlet.class.getName());
            return portletImportController.validateFile(exportImportConfiguration, file);
        }
        catch (PortalException portalException) {
            Throwable throwable = portalException.getCause();
            if (throwable instanceof LocaleException) {
                throw (PortalException)throwable;
            }
            throw portalException;
        }
        catch (SystemException systemException) {
            throw systemException;
        }
        catch (Exception exception) {
            ExportImportRuntimeException exportImportRuntimeException = new ExportImportRuntimeException(exception.getLocalizedMessage(), (Throwable)exception);
            exportImportRuntimeException.setClassName(ExportImportLocalServiceImpl.class.getName());
            throw exportImportRuntimeException;
        }
    }

    public MissingReferences validateImportPortletInfo(ExportImportConfiguration exportImportConfiguration, InputStream inputStream) throws PortalException {
        File file = null;
        try {
            file = FileUtil.createTempFile((String)"lar");
            FileUtil.write((File)file, (InputStream)inputStream);
            MissingReferences missingReferences = this.validateImportPortletInfo(exportImportConfiguration, file);
            return missingReferences;
        }
        catch (IOException ioException) {
            ExportImportIOException exportImportIOException = new ExportImportIOException(ExportImportLocalServiceImpl.class.getName(), (Throwable)ioException);
            if (file != null) {
                exportImportIOException.setFileName(file.getName());
                exportImportIOException.setType(13);
            } else {
                exportImportIOException.setType(12);
            }
            throw exportImportIOException;
        }
        finally {
            FileUtil.delete((File)file);
        }
    }
}

