/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.exportimport.service.impl;

import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationParameterMapFactoryUtil;
import com.liferay.exportimport.kernel.exception.ExportImportIOException;
import com.liferay.exportimport.kernel.exception.RemoteExportException;
import com.liferay.exportimport.kernel.lar.ExportImportDateUtil;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.MissingReferences;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.staging.StagingURLHelperUtil;
import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.LayoutSetBranch;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.IndexStatusManagerThreadLocal;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.auth.RemoteAuthException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropertiesParamUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.http.GroupServiceHttp;
import com.liferay.portlet.exportimport.service.base.StagingLocalServiceBaseImpl;
import com.liferay.portlet.exportimport.staging.StagingAdvicesThreadLocal;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletRequest;

public class StagingLocalServiceImpl
extends StagingLocalServiceBaseImpl {
    private static final String _ASSEMBLED_LAR_PREFIX = "assembled_";
    private static final String _PORTLET_REPOSITORY_ID = "134";
    private static final Log _log = LogFactoryUtil.getLog(StagingLocalServiceImpl.class);

    public void checkDefaultLayoutSetBranches(long userId, Group liveGroup, boolean branchingPublic, boolean branchingPrivate, boolean remote, ServiceContext serviceContext) throws PortalException {
        long targetGroupId = 0L;
        if (remote) {
            targetGroupId = liveGroup.getGroupId();
        } else {
            Group stagingGroup = liveGroup.getStagingGroup();
            if (stagingGroup == null) {
                return;
            }
            targetGroupId = stagingGroup.getGroupId();
        }
        LayoutSetBranch layoutSetBranch = this.layoutSetBranchLocalService.fetchLayoutSetBranch(targetGroupId, false, "main-variation");
        if (branchingPublic && layoutSetBranch == null) {
            this.addDefaultLayoutSetBranch(userId, targetGroupId, liveGroup.getDescriptiveName(), false, serviceContext);
        } else if (!branchingPublic && layoutSetBranch != null) {
            this.deleteLayoutSetBranches(targetGroupId, false);
        } else if (layoutSetBranch != null) {
            ExportImportDateUtil.clearLastPublishDate((long)targetGroupId, (boolean)false);
        }
        layoutSetBranch = this.layoutSetBranchLocalService.fetchLayoutSetBranch(targetGroupId, true, "main-variation");
        if (branchingPrivate && layoutSetBranch == null) {
            this.addDefaultLayoutSetBranch(userId, targetGroupId, liveGroup.getDescriptiveName(), true, serviceContext);
        } else if (!branchingPrivate && layoutSetBranch != null) {
            this.deleteLayoutSetBranches(targetGroupId, true);
        } else if (layoutSetBranch != null) {
            ExportImportDateUtil.clearLastPublishDate((long)targetGroupId, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUpStagingRequest(long stagingRequestId) throws PortalException {
        boolean indexReadOnly = IndexStatusManagerThreadLocal.isIndexReadOnly();
        IndexStatusManagerThreadLocal.setIndexReadOnly((boolean)true);
        try {
            PortletFileRepositoryUtil.deletePortletFolder((long)stagingRequestId);
        }
        catch (NoSuchFolderException noSuchFolderException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to clean up staging request " + stagingRequestId), (Throwable)noSuchFolderException);
            }
        }
        finally {
            IndexStatusManagerThreadLocal.setIndexReadOnly((boolean)indexReadOnly);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createStagingRequest(long userId, long groupId, String checksum) throws PortalException {
        boolean indexReadOnly = IndexStatusManagerThreadLocal.isIndexReadOnly();
        IndexStatusManagerThreadLocal.setIndexReadOnly((boolean)true);
        try {
            ServiceContext serviceContext = new ServiceContext();
            Repository repository = PortletFileRepositoryUtil.addPortletRepository((long)groupId, (String)_PORTLET_REPOSITORY_ID, (ServiceContext)serviceContext);
            Folder folder = PortletFileRepositoryUtil.addPortletFolder((long)userId, (long)repository.getRepositoryId(), (long)0L, (String)checksum, (ServiceContext)serviceContext);
            long l = folder.getFolderId();
            return l;
        }
        finally {
            IndexStatusManagerThreadLocal.setIndexReadOnly((boolean)indexReadOnly);
        }
    }

    public void disableStaging(Group liveGroup, ServiceContext serviceContext) throws PortalException {
        this.disableStaging(null, liveGroup, serviceContext);
    }

    public void disableStaging(PortletRequest portletRequest, Group liveGroup, ServiceContext serviceContext) throws PortalException {
        if (liveGroup.isLayout()) {
            this.disableStaging(portletRequest, liveGroup.getParentGroup(), serviceContext);
            return;
        }
        UnicodeProperties typeSettingsUnicodeProperties = liveGroup.getTypeSettingsProperties();
        boolean stagedLocally = GetterUtil.getBoolean((String)typeSettingsUnicodeProperties.getProperty("staged"));
        boolean stagedRemotely = GetterUtil.getBoolean((String)typeSettingsUnicodeProperties.getProperty("stagedRemotely"));
        if (!stagedLocally && !stagedRemotely) {
            return;
        }
        if (stagedRemotely) {
            String remoteURL = StagingURLHelperUtil.buildRemoteURL((UnicodeProperties)typeSettingsUnicodeProperties);
            long remoteGroupId = GetterUtil.getLong((String)typeSettingsUnicodeProperties.getProperty("remoteGroupId"));
            boolean forceDisable = GetterUtil.getBoolean((Object)serviceContext.getAttribute("forceDisable"));
            this.disableRemoteStaging(remoteURL, remoteGroupId, forceDisable);
        }
        typeSettingsUnicodeProperties.remove((Object)"branchingPrivate");
        typeSettingsUnicodeProperties.remove((Object)"branchingPublic");
        typeSettingsUnicodeProperties.remove((Object)"remoteAddress");
        typeSettingsUnicodeProperties.remove((Object)"remoteGroupId");
        typeSettingsUnicodeProperties.remove((Object)"remotePathContext");
        typeSettingsUnicodeProperties.remove((Object)"remotePort");
        typeSettingsUnicodeProperties.remove((Object)"remoteSiteURL");
        typeSettingsUnicodeProperties.remove((Object)"secureConnection");
        typeSettingsUnicodeProperties.remove((Object)"overrideRemoteSiteURL");
        typeSettingsUnicodeProperties.remove((Object)"staged");
        typeSettingsUnicodeProperties.remove((Object)"stagedRemotely");
        HashSet<String> keys = new HashSet<String>();
        for (String key : typeSettingsUnicodeProperties.keySet()) {
            if (!key.startsWith("staged-portlet_")) continue;
            keys.add(key);
        }
        for (String key : keys) {
            typeSettingsUnicodeProperties.remove((Object)key);
        }
        StagingUtil.deleteLastImportSettings((Group)liveGroup, (boolean)true);
        StagingUtil.deleteLastImportSettings((Group)liveGroup, (boolean)false);
        this.checkDefaultLayoutSetBranches(serviceContext.getUserId(), liveGroup, false, false, stagedRemotely, serviceContext);
        if (liveGroup.hasStagingGroup()) {
            Group stagingGroup = liveGroup.getStagingGroup();
            this.groupLocalService.deleteGroup(stagingGroup.getGroupId());
            liveGroup.clearStagingGroup();
        }
        this.groupLocalService.updateGroup(liveGroup.getGroupId(), typeSettingsUnicodeProperties.toString());
    }

    public void enableLocalStaging(long userId, Group liveGroup, boolean branchingPublic, boolean branchingPrivate, ServiceContext serviceContext) throws PortalException {
        if (liveGroup.isLayout()) {
            this.enableLocalStaging(userId, liveGroup.getParentGroup(), branchingPublic, branchingPrivate, serviceContext);
            return;
        }
        if (liveGroup.isStagedRemotely()) {
            this.disableStaging(liveGroup, serviceContext);
        }
        UnicodeProperties typeSettingsUnicodeProperties = liveGroup.getTypeSettingsProperties();
        boolean hasStagingGroup = liveGroup.hasStagingGroup();
        if (!hasStagingGroup) {
            serviceContext.setAttribute("staging", (Serializable)((Object)Boolean.TRUE.toString()));
            String languageId = typeSettingsUnicodeProperties.getProperty("languageId");
            if (Validator.isNotNull((String)languageId)) {
                serviceContext.setLanguageId(languageId);
            }
            this.addStagingGroup(userId, liveGroup, serviceContext);
        }
        this.checkDefaultLayoutSetBranches(userId, liveGroup, branchingPublic, branchingPrivate, false, serviceContext);
        typeSettingsUnicodeProperties.setProperty("branchingPrivate", String.valueOf(branchingPrivate));
        typeSettingsUnicodeProperties.setProperty("branchingPublic", String.valueOf(branchingPublic));
        if (!hasStagingGroup) {
            typeSettingsUnicodeProperties.setProperty("staged", Boolean.TRUE.toString());
            typeSettingsUnicodeProperties.setProperty("stagedRemotely", Boolean.FALSE.toString());
            this.setCommonStagingOptions(typeSettingsUnicodeProperties, serviceContext);
        }
        this.groupLocalService.updateGroup(liveGroup.getGroupId(), typeSettingsUnicodeProperties.toString());
        if (hasStagingGroup) {
            return;
        }
        Group stagingGroup = liveGroup.getStagingGroup();
        Map parameterMap = ExportImportConfigurationParameterMapFactoryUtil.buildFullPublishParameterMap();
        if (liveGroup.hasPrivateLayouts()) {
            StagingUtil.publishLayouts((long)userId, (long)liveGroup.getGroupId(), (long)stagingGroup.getGroupId(), (boolean)true, (Map)parameterMap);
            parameterMap = ExportImportConfigurationParameterMapFactoryUtil.buildParameterMap();
        }
        if (liveGroup.hasPublicLayouts() || !liveGroup.hasPrivateLayouts()) {
            StagingUtil.publishLayouts((long)userId, (long)liveGroup.getGroupId(), (long)stagingGroup.getGroupId(), (boolean)false, (Map)parameterMap);
        }
    }

    public void enableRemoteStaging(long userId, Group stagingGroup, boolean branchingPublic, boolean branchingPrivate, String remoteAddress, int remotePort, String remotePathContext, boolean secureConnection, long remoteGroupId, ServiceContext serviceContext) throws PortalException {
        boolean stagedRemotely;
        this.groupLocalService.validateRemote(stagingGroup.getGroupId(), remoteAddress, remotePort, remotePathContext, secureConnection, remoteGroupId);
        if (stagingGroup.hasStagingGroup()) {
            this.disableStaging(stagingGroup, serviceContext);
        }
        boolean oldStagedRemotely = stagedRemotely = stagingGroup.isStagedRemotely();
        UnicodeProperties typeSettingsUnicodeProperties = stagingGroup.getTypeSettingsProperties();
        String remoteURL = StagingURLHelperUtil.buildRemoteURL((String)remoteAddress, (int)remotePort, (String)remotePathContext, (boolean)secureConnection);
        if (stagedRemotely) {
            long oldRemoteGroupId = GetterUtil.getLong((String)typeSettingsUnicodeProperties.getProperty("remoteGroupId"));
            String oldRemoteURL = StagingURLHelperUtil.buildRemoteURL((UnicodeProperties)typeSettingsUnicodeProperties);
            if (!remoteURL.equals(oldRemoteURL) || remoteGroupId != oldRemoteGroupId) {
                this.disableRemoteStaging(oldRemoteURL, oldRemoteGroupId, false);
                stagedRemotely = false;
            }
        }
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        User user = permissionChecker.getUser();
        HttpPrincipal httpPrincipal = new HttpPrincipal(remoteURL, user.getLogin(), user.getPassword(), user.isPasswordEncrypted());
        if (!stagedRemotely) {
            this.enableRemoteStaging(httpPrincipal, remoteGroupId);
        }
        Group remoteGroup = this.fetchRemoteGroup(httpPrincipal, remoteGroupId);
        this.checkDefaultLayoutSetBranches(userId, stagingGroup, branchingPublic, branchingPrivate, true, serviceContext);
        typeSettingsUnicodeProperties.setProperty("branchingPrivate", String.valueOf(branchingPrivate));
        typeSettingsUnicodeProperties.setProperty("branchingPublic", String.valueOf(branchingPublic));
        typeSettingsUnicodeProperties.setProperty("remoteAddress", remoteAddress);
        typeSettingsUnicodeProperties.setProperty("remoteGroupId", String.valueOf(remoteGroupId));
        typeSettingsUnicodeProperties.setProperty("remoteGroupUUID", remoteGroup.getUuid());
        typeSettingsUnicodeProperties.setProperty("remotePathContext", remotePathContext);
        typeSettingsUnicodeProperties.setProperty("remotePort", String.valueOf(remotePort));
        typeSettingsUnicodeProperties.setProperty("secureConnection", String.valueOf(secureConnection));
        if (!oldStagedRemotely) {
            typeSettingsUnicodeProperties.setProperty("staged", Boolean.TRUE.toString());
            typeSettingsUnicodeProperties.setProperty("stagedRemotely", Boolean.TRUE.toString());
            this.setCommonStagingOptions(typeSettingsUnicodeProperties, serviceContext);
        }
        this.groupLocalService.updateGroup(stagingGroup.getGroupId(), typeSettingsUnicodeProperties.toString());
        this.updateStagedPortlets(remoteURL, remoteGroupId, typeSettingsUnicodeProperties);
    }

    public MissingReferences publishStagingRequest(long userId, long stagingRequestId, ExportImportConfiguration exportImportConfiguration) throws PortalException {
        MissingReferences missingReferences;
        File file = null;
        Locale siteDefaultLocale = LocaleThreadLocal.getSiteDefaultLocale();
        try {
            if (exportImportConfiguration.getType() == 9) {
                ExportImportThreadLocal.setPortletImportInProcess((boolean)true);
                ExportImportThreadLocal.setPortletStagingInProcess((boolean)true);
            } else {
                ExportImportThreadLocal.setLayoutImportInProcess((boolean)true);
                ExportImportThreadLocal.setLayoutStagingInProcess((boolean)true);
            }
            Folder folder = PortletFileRepositoryUtil.getPortletFolder((long)stagingRequestId);
            FileEntry stagingRequestFileEntry = this.getStagingRequestFileEntry(userId, stagingRequestId, folder);
            file = FileUtil.createTempFile((String)"lar");
            FileUtil.write((File)file, (InputStream)stagingRequestFileEntry.getContentStream());
            Map settingsMap = exportImportConfiguration.getSettingsMap();
            settingsMap.put("userId", userId);
            long targetGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
            LocaleThreadLocal.setSiteDefaultLocale((Locale)PortalUtil.getSiteDefaultLocale((long)targetGroupId));
            MissingReferences missingReferences2 = null;
            if (exportImportConfiguration.getType() == 9) {
                this.exportImportLocalService.importPortletDataDeletions(exportImportConfiguration, file);
                missingReferences2 = this.exportImportLocalService.validateImportPortletInfo(exportImportConfiguration, file);
                this.exportImportLocalService.importPortletInfo(exportImportConfiguration, file);
            } else {
                this.exportImportLocalService.importLayoutsDataDeletions(exportImportConfiguration, file);
                missingReferences2 = this.exportImportLocalService.validateImportLayoutsFile(exportImportConfiguration, file);
                this.exportImportLocalService.importLayouts(exportImportConfiguration, file);
            }
            missingReferences = missingReferences2;
        }
        catch (IOException ioException) {
            try {
                ExportImportIOException exportImportIOException = new ExportImportIOException(StagingLocalServiceImpl.class.getName(), (Throwable)ioException);
                exportImportIOException.setStagingRequestId(stagingRequestId);
                exportImportIOException.setType(14);
                throw exportImportIOException;
            }
            catch (Throwable throwable) {
                if (exportImportConfiguration.getType() == 9) {
                    ExportImportThreadLocal.setPortletImportInProcess((boolean)false);
                    ExportImportThreadLocal.setPortletStagingInProcess((boolean)false);
                } else {
                    ExportImportThreadLocal.setLayoutImportInProcess((boolean)false);
                    ExportImportThreadLocal.setLayoutStagingInProcess((boolean)false);
                }
                LocaleThreadLocal.setSiteDefaultLocale((Locale)siteDefaultLocale);
                FileUtil.delete(file);
                throw throwable;
            }
        }
        if (exportImportConfiguration.getType() == 9) {
            ExportImportThreadLocal.setPortletImportInProcess((boolean)false);
            ExportImportThreadLocal.setPortletStagingInProcess((boolean)false);
        } else {
            ExportImportThreadLocal.setLayoutImportInProcess((boolean)false);
            ExportImportThreadLocal.setLayoutStagingInProcess((boolean)false);
        }
        LocaleThreadLocal.setSiteDefaultLocale((Locale)siteDefaultLocale);
        FileUtil.delete((File)file);
        return missingReferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStagingRequest(long userId, long stagingRequestId, String fileName, byte[] bytes) throws PortalException {
        Folder folder = PortletFileRepositoryUtil.getPortletFolder((long)stagingRequestId);
        boolean indexReadOnly = IndexStatusManagerThreadLocal.isIndexReadOnly();
        IndexStatusManagerThreadLocal.setIndexReadOnly((boolean)true);
        try {
            PortletFileRepositoryUtil.addPortletFileEntry((long)folder.getGroupId(), (long)userId, (String)Group.class.getName(), (long)folder.getGroupId(), (String)_PORTLET_REPOSITORY_ID, (long)folder.getFolderId(), (InputStream)new UnsyncByteArrayInputStream(bytes), (String)fileName, (String)"application/zip", (boolean)false);
        }
        finally {
            IndexStatusManagerThreadLocal.setIndexReadOnly((boolean)indexReadOnly);
        }
    }

    protected void addDefaultLayoutSetBranch(long userId, long groupId, String groupName, boolean privateLayout, ServiceContext serviceContext) throws PortalException {
        block4: {
            String masterBranchDescription = "main-site-pages-variation-of-x";
            if (privateLayout) {
                masterBranchDescription = "main-site-pages-variation-of-x";
            }
            String description = LanguageUtil.format((Locale)PortalUtil.getSiteDefaultLocale((long)groupId), (String)masterBranchDescription, (Object)groupName, (boolean)false);
            try {
                serviceContext.setWorkflowAction(0);
                LayoutSetBranch layoutSetBranch = this.layoutSetBranchLocalService.addLayoutSetBranch(userId, groupId, privateLayout, "main-variation", description, true, 0L, serviceContext);
                List layoutRevisions = this.layoutRevisionLocalService.getLayoutRevisions(layoutSetBranch.getLayoutSetBranchId(), false);
                for (LayoutRevision layoutRevision : layoutRevisions) {
                    this.layoutRevisionLocalService.updateStatus(userId, layoutRevision.getLayoutRevisionId(), 0, serviceContext);
                }
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)("Unable to create master branch for " + (privateLayout ? "private" : "public") + " layouts"), (Throwable)portalException);
            }
        }
    }

    protected Group addStagingGroup(long userId, Group liveGroup, ServiceContext serviceContext) throws PortalException {
        Group stagingGroup = this.groupLocalService.addGroup(userId, liveGroup.getParentGroupId(), liveGroup.getClassName(), liveGroup.getClassPK(), liveGroup.getGroupId(), liveGroup.getNameMap(), liveGroup.getDescriptionMap(), liveGroup.getType(), liveGroup.isManualMembership(), liveGroup.getMembershipRestriction(), liveGroup.getFriendlyURL(), false, true, serviceContext);
        if (LanguageUtil.isInheritLocales((long)liveGroup.getGroupId())) {
            return stagingGroup;
        }
        UnicodeProperties liveTypeSettingsUnicodeProperties = liveGroup.getTypeSettingsProperties();
        UnicodeProperties stagingTypeSettingsUnicodeProperties = stagingGroup.getTypeSettingsProperties();
        stagingTypeSettingsUnicodeProperties.setProperty("inheritLocales", Boolean.FALSE.toString());
        stagingTypeSettingsUnicodeProperties.setProperty("locales", liveTypeSettingsUnicodeProperties.getProperty("locales"));
        stagingTypeSettingsUnicodeProperties.setProperty("languageId", liveTypeSettingsUnicodeProperties.getProperty("languageId", LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault())));
        return this.groupLocalService.updateGroup(stagingGroup.getGroupId(), stagingTypeSettingsUnicodeProperties.toString());
    }

    protected void deleteLayoutSetBranches(long groupId, boolean privateLayout) throws PortalException {
        String lastPublishDateString;
        HashMap<Long, LayoutRevision> layoutRevisions = new HashMap<Long, LayoutRevision>();
        List layoutSetBranches = this.layoutSetBranchLocalService.getLayoutSetBranches(groupId, privateLayout);
        boolean publishedToLive = false;
        for (LayoutSetBranch layoutSetBranch : layoutSetBranches) {
            lastPublishDateString = layoutSetBranch.getSettingsProperty("last-publish-date");
            if (!Validator.isNotNull((String)lastPublishDateString)) continue;
            publishedToLive = true;
            break;
        }
        for (LayoutSetBranch layoutSetBranch : layoutSetBranches) {
            lastPublishDateString = layoutSetBranch.getSettingsProperty("last-publish-date");
            if (Validator.isNull((String)lastPublishDateString) && publishedToLive) continue;
            Date lastPublishDate = null;
            if (Validator.isNotNull((String)lastPublishDateString)) {
                lastPublishDate = new Date(GetterUtil.getLong((String)lastPublishDateString));
            }
            List headLayoutRevisions = this.layoutRevisionLocalService.getLayoutRevisions(layoutSetBranch.getLayoutSetBranchId(), true);
            for (LayoutRevision headLayoutRevision : headLayoutRevisions) {
                LayoutRevision layoutRevision = (LayoutRevision)layoutRevisions.get(headLayoutRevision.getPlid());
                if (layoutRevision == null) {
                    layoutRevisions.put(headLayoutRevision.getPlid(), headLayoutRevision);
                    continue;
                }
                Date statusDate = headLayoutRevision.getStatusDate();
                if (!statusDate.after(layoutRevision.getStatusDate()) || lastPublishDate != null && !lastPublishDate.after(statusDate)) continue;
                layoutRevisions.put(headLayoutRevision.getPlid(), headLayoutRevision);
            }
        }
        for (LayoutRevision layoutRevision : layoutRevisions.values()) {
            this.updateLayoutWithLayoutRevision(layoutRevision);
        }
        this.layoutSetBranchLocalService.deleteLayoutSetBranches(groupId, privateLayout, true);
    }

    protected void disableRemoteStaging(String remoteURL, long remoteGroupId, boolean forceDisable) throws PortalException {
        block10: {
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            User user = permissionChecker.getUser();
            HttpPrincipal httpPrincipal = new HttpPrincipal(remoteURL, user.getLogin(), user.getPassword(), user.isPasswordEncrypted());
            try {
                GroupServiceHttp.disableStaging(httpPrincipal, remoteGroupId);
            }
            catch (NoSuchGroupException noSuchGroupException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Remote live group was already deleted", (Throwable)noSuchGroupException);
                }
            }
            catch (PrincipalException principalException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)principalException, (Throwable)principalException);
                }
                RemoteExportException remoteExportException = new RemoteExportException(5);
                remoteExportException.setGroupId(remoteGroupId);
                throw remoteExportException;
            }
            catch (RemoteAuthException remoteAuthException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)remoteAuthException, (Throwable)remoteAuthException);
                }
                remoteAuthException.setURL(remoteURL);
                throw remoteAuthException;
            }
            catch (SystemException systemException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)systemException, (Throwable)systemException);
                }
                if (!forceDisable) {
                    RemoteExportException remoteExportException = new RemoteExportException(1);
                    remoteExportException.setURL(remoteURL);
                    throw remoteExportException;
                }
                if (!_log.isWarnEnabled()) break block10;
                _log.warn((Object)"Forcibly disable remote staging");
            }
        }
    }

    protected void enableRemoteStaging(HttpPrincipal httpPrincipal, long remoteGroupId) throws PortalException {
        try {
            GroupServiceHttp.enableStaging(httpPrincipal, remoteGroupId);
        }
        catch (NoSuchGroupException noSuchGroupException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)noSuchGroupException, (Throwable)noSuchGroupException);
            }
            RemoteExportException remoteExportException = new RemoteExportException(3);
            remoteExportException.setGroupId(remoteGroupId);
            throw remoteExportException;
        }
        catch (PrincipalException principalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)principalException, (Throwable)principalException);
            }
            RemoteExportException remoteExportException = new RemoteExportException(5);
            remoteExportException.setGroupId(remoteGroupId);
            throw remoteExportException;
        }
        catch (RemoteAuthException remoteAuthException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)remoteAuthException, (Throwable)remoteAuthException);
            }
            remoteAuthException.setURL(httpPrincipal.getUrl());
            throw remoteAuthException;
        }
        catch (SystemException systemException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)systemException, (Throwable)systemException);
            }
            RemoteExportException remoteExportException = new RemoteExportException(1);
            remoteExportException.setURL(httpPrincipal.getUrl());
            throw remoteExportException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Group fetchRemoteGroup(HttpPrincipal httpPrincipal, long groupId) throws PortalException {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(PortalClassLoaderUtil.getClassLoader());
            Group group = GroupServiceHttp.getGroup(httpPrincipal, groupId);
            return group;
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    protected FileEntry fetchStagingRequestFileEntry(long stagingRequestId, Folder folder) throws PortalException {
        try {
            return PortletFileRepositoryUtil.getPortletFileEntry((long)folder.getGroupId(), (long)folder.getFolderId(), (String)this.getAssembledFileName(stagingRequestId));
        }
        catch (NoSuchFileEntryException noSuchFileEntryException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)noSuchFileEntryException, (Throwable)noSuchFileEntryException);
            }
            return null;
        }
    }

    protected String getAssembledFileName(long stagingRequestId) {
        return _ASSEMBLED_LAR_PREFIX + String.valueOf(stagingRequestId) + ".lar";
    }

    /*
     * Exception decompiling
     */
    protected FileEntry getStagingRequestFileEntry(long userId, long stagingRequestId, Folder folder) throws PortalException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void setCommonStagingOptions(UnicodeProperties typeSettingsUnicodeProperties, ServiceContext serviceContext) {
        typeSettingsUnicodeProperties.putAll((Map)PropertiesParamUtil.getProperties((ServiceContext)serviceContext, (String)"staged--"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Layout updateLayoutWithLayoutRevision(LayoutRevision layoutRevision) throws PortalException {
        Layout layout = null;
        boolean stagingAdvicesThreadLocalEnabled = StagingAdvicesThreadLocal.isEnabled();
        try {
            StagingAdvicesThreadLocal.setEnabled(false);
            layout = this.layoutLocalService.fetchLayout(layoutRevision.getPlid());
        }
        finally {
            StagingAdvicesThreadLocal.setEnabled(stagingAdvicesThreadLocalEnabled);
        }
        this.updatePortletPreferences(layoutRevision, layout);
        layout.setUserId(layoutRevision.getUserId());
        layout.setUserName(layoutRevision.getUserName());
        layout.setCreateDate(layoutRevision.getCreateDate());
        layout.setModifiedDate(layoutRevision.getModifiedDate());
        layout.setPrivateLayout(layoutRevision.isPrivateLayout());
        layout.setName(layoutRevision.getName());
        layout.setTitle(layoutRevision.getTitle());
        layout.setDescription(layoutRevision.getDescription());
        layout.setKeywords(layoutRevision.getKeywords());
        layout.setRobots(layoutRevision.getRobots());
        layout.setTypeSettings(layoutRevision.getTypeSettings());
        layout.setIconImageId(layoutRevision.getIconImageId());
        layout.setThemeId(layoutRevision.getThemeId());
        layout.setColorSchemeId(layoutRevision.getColorSchemeId());
        layout.setCss(layoutRevision.getCss());
        return this.layoutLocalService.updateLayout(layout);
    }

    protected void updatePortletPreferences(LayoutRevision layoutRevision, Layout layout) {
        this.portletPreferencesLocalService.deletePortletPreferencesByPlid(layout.getPlid());
        List portletPreferencesList = this.portletPreferencesLocalService.getPortletPreferencesByPlid(layoutRevision.getLayoutRevisionId());
        for (PortletPreferences portletPreferences : portletPreferencesList) {
            javax.portlet.PortletPreferences jxPortletPreferences = this.portletPreferenceValueLocalService.getPreferences(portletPreferences);
            this.portletPreferencesLocalService.addPortletPreferences(layoutRevision.getCompanyId(), portletPreferences.getOwnerId(), portletPreferences.getOwnerType(), layout.getPlid(), portletPreferences.getPortletId(), null, PortletPreferencesFactoryUtil.toXML((javax.portlet.PortletPreferences)jxPortletPreferences));
        }
    }

    protected void updateStagedPortlets(String remoteURL, long remoteGroupId, UnicodeProperties typeSettingsUnicodeProperties) throws PortalException {
        RemoteExportException remoteExportException;
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        User user = permissionChecker.getUser();
        HttpPrincipal httpPrincipal = new HttpPrincipal(remoteURL, user.getLogin(), user.getPassword(), user.isPasswordEncrypted());
        HashMap<String, String> stagedPortletIds = new HashMap<String, String>();
        for (String key : typeSettingsUnicodeProperties.keySet()) {
            if (!key.startsWith("staged-portlet_")) continue;
            stagedPortletIds.put(key, typeSettingsUnicodeProperties.getProperty(key));
        }
        try {
            GroupServiceHttp.updateStagedPortlets(httpPrincipal, remoteGroupId, stagedPortletIds);
        }
        catch (NoSuchGroupException noSuchGroupException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)noSuchGroupException, (Throwable)noSuchGroupException);
            }
            remoteExportException = new RemoteExportException(3);
            remoteExportException.setGroupId(remoteGroupId);
            throw remoteExportException;
        }
        catch (PrincipalException principalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)principalException, (Throwable)principalException);
            }
            remoteExportException = new RemoteExportException(5);
            remoteExportException.setGroupId(remoteGroupId);
            throw remoteExportException;
        }
        catch (RemoteAuthException remoteAuthException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)remoteAuthException, (Throwable)remoteAuthException);
            }
            remoteAuthException.setURL(remoteURL);
            throw remoteAuthException;
        }
        catch (SystemException systemException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)systemException, (Throwable)systemException);
            }
            remoteExportException = new RemoteExportException(1);
            remoteExportException.setURL(remoteURL);
            throw remoteExportException;
        }
    }
}

