/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.internal;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.model.PublicRenderParameter;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayStateAwareResponse;
import com.liferay.portal.kernel.portlet.PortletQNameUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portlet.PublicRenderParametersPool;
import com.liferay.portlet.internal.EventImpl;
import com.liferay.portlet.internal.MutableRenderParametersImpl;
import com.liferay.portlet.internal.PortletRequestImpl;
import com.liferay.portlet.internal.PortletResponseImpl;
import com.liferay.portlet.internal.RenderParametersImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.portlet.Event;
import javax.portlet.MutableRenderParameters;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;

public abstract class StateAwareResponseImpl
extends PortletResponseImpl
implements LiferayStateAwareResponse {
    private static final Log _log = LogFactoryUtil.getLog(StateAwareResponseImpl.class);
    private boolean _calledSetRenderParameter;
    private final List<Event> _events = new ArrayList<Event>();
    private Layout _layout;
    private MutableRenderParametersImpl _mutableRenderParametersImpl;
    private final Map<String, String[]> _params = new LinkedHashMap<String, String[]>();
    private PortletMode _portletMode = PortletMode.UNDEFINED;
    private Map<String, String[]> _publicRenderParameters;
    private String _redirectLocation;
    private User _user;
    private WindowState _windowState = WindowState.UNDEFINED;

    public String getDefaultNamespace() {
        Portlet portlet = this.getPortlet();
        if (portlet != null) {
            PortletApp portletApp = portlet.getPortletApp();
            return portletApp.getDefaultNamespace();
        }
        return "";
    }

    public List<Event> getEvents() {
        return this._events;
    }

    public Layout getLayout() {
        return this._layout;
    }

    public PortletMode getPortletMode() {
        return this._portletMode;
    }

    public String getRedirectLocation() {
        return this._redirectLocation;
    }

    @Deprecated
    public Map<String, String[]> getRenderParameterMap() {
        LinkedHashMap<String, String[]> renderParameterMap = new LinkedHashMap<String, String[]>();
        Map<String, String[]> mutableRenderParametersMap = this._mutableRenderParametersImpl.getParameterMap();
        for (Map.Entry<String, String[]> entry : mutableRenderParametersMap.entrySet()) {
            String parameterName = entry.getKey();
            if (this._mutableRenderParametersImpl.isPublic(parameterName) && !this._mutableRenderParametersImpl.isMutated(parameterName)) continue;
            renderParameterMap.put(parameterName, entry.getValue());
        }
        return renderParameterMap;
    }

    public MutableRenderParameters getRenderParameters() {
        return this._mutableRenderParametersImpl;
    }

    public User getUser() {
        return this._user;
    }

    public WindowState getWindowState() {
        return this._windowState;
    }

    public void init(PortletRequestImpl portletRequestImpl, HttpServletResponse httpServletResponse, User user, Layout layout, boolean setWindowStateAndPortletMode) throws PortletModeException, WindowStateException {
        super.init(portletRequestImpl, httpServletResponse);
        this._user = user;
        this._layout = layout;
        this._publicRenderParameters = PublicRenderParametersPool.get(this.getHttpServletRequest(), layout.getPlid());
        if (setWindowStateAndPortletMode) {
            this.setWindowState(portletRequestImpl.getWindowState());
            this.setPortletMode(portletRequestImpl.getPortletMode());
        }
        this._calledSetRenderParameter = false;
        Portlet portlet = portletRequestImpl.getPortlet();
        PortletApp portletApp = portlet.getPortletApp();
        if (portletApp.getSpecMajorVersion() < 3) {
            this._mutableRenderParametersImpl = new MutableRenderParametersImpl(this._params, Collections.emptySet());
        } else {
            LinkedHashSet<String> publicRenderParameterNames = new LinkedHashSet<String>();
            RenderParametersImpl renderParametersImpl = (RenderParametersImpl)portletRequestImpl.getRenderParameters();
            Map<String, String[]> liferayRenderParametersMap = renderParametersImpl.getParameterMap();
            for (Map.Entry<String, String[]> entry : liferayRenderParametersMap.entrySet()) {
                String renderParameterName = entry.getKey();
                if (renderParametersImpl.isPublic(renderParameterName)) {
                    publicRenderParameterNames.add(renderParameterName);
                }
                this._params.put(renderParameterName, entry.getValue());
            }
            this._mutableRenderParametersImpl = new MutableRenderParametersImpl(this._params, publicRenderParameterNames);
        }
    }

    public boolean isCalledSetRenderParameter() {
        return this._calledSetRenderParameter || this._mutableRenderParametersImpl.isMutated();
    }

    @Deprecated
    public void removePublicRenderParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        PublicRenderParameter publicRenderParameter = this.getPortlet().getPublicRenderParameter(name);
        if (publicRenderParameter == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Public parameter " + name + "does not exist"));
            }
            return;
        }
        String key = PortletQNameUtil.getPublicRenderParameterName((com.liferay.portal.kernel.xml.QName)publicRenderParameter.getQName());
        this._publicRenderParameters.remove(key);
    }

    public void setEvent(QName name, Serializable value) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this._events.add(new EventImpl(name.getLocalPart(), name, value));
    }

    public void setEvent(String name, Serializable value) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.setEvent(new QName(this.getDefaultNamespace(), name), value);
    }

    public void setPortletMode(PortletMode portletMode) throws PortletModeException {
        if (this._redirectLocation != null) {
            throw new IllegalStateException();
        }
        if (portletMode == null) {
            throw new IllegalArgumentException();
        }
        if (!this.portletRequestImpl.isPortletModeAllowed(portletMode)) {
            throw new PortletModeException(portletMode.toString(), portletMode);
        }
        try {
            this._portletMode = PortalUtil.updatePortletMode((String)this.portletName, (User)this._user, (Layout)this._layout, (PortletMode)portletMode, (HttpServletRequest)this.portletRequestImpl.getHttpServletRequest());
            this.portletRequestImpl.setPortletMode(this._portletMode);
        }
        catch (Exception exception) {
            throw new PortletModeException((Throwable)exception, portletMode);
        }
        this._calledSetRenderParameter = true;
    }

    public void setRedirectLocation(String redirectLocation) {
        this._redirectLocation = redirectLocation;
    }

    @Deprecated
    public void setRenderParameter(String name, String value) {
        if (this._redirectLocation != null) {
            throw new IllegalStateException();
        }
        if (name == null || value == null) {
            throw new IllegalArgumentException();
        }
        this.setRenderParameter(name, new String[]{value});
    }

    @Deprecated
    public void setRenderParameter(String name, String[] values) {
        if (this._redirectLocation != null) {
            throw new IllegalStateException();
        }
        if (name == null || values == null) {
            throw new IllegalArgumentException();
        }
        for (String value : values) {
            if (value != null) continue;
            throw new IllegalArgumentException();
        }
        if (!this.setPublicRenderParameter(name, values)) {
            this._mutableRenderParametersImpl.setValues(name, values);
        }
        this._calledSetRenderParameter = true;
    }

    @Deprecated
    public void setRenderParameters(Map<String, String[]> params) {
        if (this._redirectLocation != null) {
            throw new IllegalStateException();
        }
        if (params == null) {
            throw new IllegalArgumentException();
        }
        this._mutableRenderParametersImpl.clear();
        for (Map.Entry<String, String[]> entry : params.entrySet()) {
            String key = entry.getKey();
            if (key == null) {
                throw new IllegalArgumentException();
            }
            String[] value = entry.getValue();
            if (value == null) {
                throw new IllegalArgumentException();
            }
            if (this.setPublicRenderParameter(key, value)) continue;
            this._mutableRenderParametersImpl.setValues(key, value);
        }
        this._calledSetRenderParameter = true;
    }

    public void setWindowState(WindowState windowState) throws WindowStateException {
        if (this._redirectLocation != null) {
            throw new IllegalStateException();
        }
        if (windowState == null) {
            throw new IllegalArgumentException();
        }
        if (!this.portletRequestImpl.isWindowStateAllowed(windowState)) {
            throw new WindowStateException(windowState.toString(), windowState);
        }
        try {
            this._windowState = PortalUtil.updateWindowState((String)this.portletName, (User)this._user, (Layout)this._layout, (WindowState)windowState, (HttpServletRequest)this.portletRequestImpl.getHttpServletRequest());
            this.portletRequestImpl.setWindowState(this._windowState);
        }
        catch (Exception exception) {
            throw new WindowStateException((Throwable)exception, windowState);
        }
        this._calledSetRenderParameter = true;
    }

    protected void reset() {
        block5: {
            block4: {
                this._events.clear();
                this._mutableRenderParametersImpl.clear();
                try {
                    this.setPortletMode(PortletMode.VIEW);
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block4;
                    _log.warn((Object)"Unable to reset portlet mode to VIEW", (Throwable)exception);
                }
            }
            this._portletMode = PortletMode.UNDEFINED;
            this._redirectLocation = null;
            try {
                this.setWindowState(WindowState.NORMAL);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block5;
                _log.warn((Object)"Unable to reset window state to NORMAL", (Throwable)exception);
            }
        }
        this._windowState = WindowState.UNDEFINED;
        this._calledSetRenderParameter = false;
    }

    protected boolean setPublicRenderParameter(String name, String[] values) {
        Portlet portlet = this.getPortlet();
        PublicRenderParameter publicRenderParameter = portlet.getPublicRenderParameter(name);
        if (publicRenderParameter == null) {
            return false;
        }
        com.liferay.portal.kernel.xml.QName qName = publicRenderParameter.getQName();
        Object[] oldValues = this._publicRenderParameters.get(name);
        if (oldValues != null) {
            values = (String[])ArrayUtil.append((Object[])oldValues, (Object[])values);
        }
        this._publicRenderParameters.put(PortletQNameUtil.getPublicRenderParameterName((com.liferay.portal.kernel.xml.QName)qName), values);
        return true;
    }
}

