/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.sites.search;

import com.liferay.portal.kernel.dao.search.EmptyOnClickRowChecker;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.membershippolicy.SiteMembershipPolicyUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.UserGroupRoleLocalServiceUtil;
import javax.portlet.PortletResponse;
import javax.portlet.RenderResponse;

public class UserGroupRoleRoleChecker
extends EmptyOnClickRowChecker {
    private static final Log _log = LogFactoryUtil.getLog(UserGroupRoleRoleChecker.class);
    private final Group _group;
    private final User _user;

    public UserGroupRoleRoleChecker(RenderResponse renderResponse, User user, Group group) {
        super((PortletResponse)renderResponse);
        this._user = user;
        this._group = group;
    }

    public boolean isChecked(Object object) {
        Role role = (Role)object;
        try {
            return UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)this._user.getUserId(), (long)this._group.getGroupId(), (long)role.getRoleId());
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            return false;
        }
    }

    public boolean isDisabled(Object object) {
        Role role = (Role)object;
        try {
            if (this.isChecked(role) ? SiteMembershipPolicyUtil.isRoleProtected((PermissionChecker)PermissionThreadLocal.getPermissionChecker(), (long)this._user.getUserId(), (long)this._group.getGroupId(), (long)role.getRoleId()) || SiteMembershipPolicyUtil.isRoleRequired((long)this._user.getUserId(), (long)this._group.getGroupId(), (long)role.getRoleId()) : !SiteMembershipPolicyUtil.isRoleAllowed((long)this._user.getUserId(), (long)this._group.getGroupId(), (long)role.getRoleId())) {
                return true;
            }
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
        return super.isDisabled(object);
    }
}

