/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.social.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.social.service.base.SocialActivityInterpreterLocalServiceBaseImpl;
import com.liferay.registry.Filter;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.registry.collections.ServiceRegistrationMap;
import com.liferay.registry.collections.ServiceRegistrationMapImpl;
import com.liferay.social.kernel.model.SocialActivity;
import com.liferay.social.kernel.model.SocialActivityFeedEntry;
import com.liferay.social.kernel.model.SocialActivityInterpreter;
import com.liferay.social.kernel.model.SocialActivitySet;
import com.liferay.social.kernel.model.impl.SocialActivityInterpreterImpl;
import com.liferay.social.kernel.model.impl.SocialRequestInterpreterImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class SocialActivityInterpreterLocalServiceImpl
extends SocialActivityInterpreterLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(SocialActivityInterpreterLocalServiceImpl.class);
    private final Map<String, List<SocialActivityInterpreter>> _activityInterpreters = new HashMap<String, List<SocialActivityInterpreter>>();
    private final ServiceRegistrationMap<SocialActivityInterpreter> _serviceRegistrationMap = new ServiceRegistrationMapImpl();
    private ServiceTracker<SocialActivityInterpreter, SocialActivityInterpreter> _serviceTracker;

    public void addActivityInterpreter(SocialActivityInterpreter activityInterpreter) {
        Registry registry = RegistryUtil.getRegistry();
        HashMap properties = HashMapBuilder.put((Object)"javax.portlet.name", () -> {
            SocialActivityInterpreterImpl socialActivityInterpreterImpl = (SocialActivityInterpreterImpl)activityInterpreter;
            return socialActivityInterpreterImpl.getPortletId();
        }).build();
        ServiceRegistration serviceRegistration = registry.registerService(SocialActivityInterpreter.class, (Object)activityInterpreter, (Map)properties);
        this._serviceRegistrationMap.put((Object)activityInterpreter, (Object)serviceRegistration);
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Registry registry = RegistryUtil.getRegistry();
        Filter filter = registry.getFilter("(&(javax.portlet.name=*)(objectClass=" + SocialActivityInterpreter.class.getName() + "))");
        this._serviceTracker = registry.trackServices(filter, (ServiceTrackerCustomizer)new SocialActivityInterpreterServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    public void deleteActivityInterpreter(SocialActivityInterpreter activityInterpreter) {
        ServiceRegistration serviceRegistration = (ServiceRegistration)this._serviceRegistrationMap.remove((Object)activityInterpreter);
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
    }

    public Map<String, List<SocialActivityInterpreter>> getActivityInterpreters() {
        return this._activityInterpreters;
    }

    public List<SocialActivityInterpreter> getActivityInterpreters(String selector) {
        return this._activityInterpreters.get(selector);
    }

    public SocialActivityFeedEntry interpret(String selector, SocialActivity activity, ServiceContext serviceContext) {
        List<SocialActivityInterpreter> activityInterpreters;
        HttpServletRequest httpServletRequest = serviceContext.getRequest();
        if (httpServletRequest == null) {
            return null;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            if (activity.getUserId() == themeDisplay.getDefaultUserId()) {
                return null;
            }
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
        if (activity.getMirrorActivityId() > 0L) {
            SocialActivity mirrorActivity;
            block10: {
                mirrorActivity = null;
                try {
                    mirrorActivity = this.socialActivityLocalService.getActivity(activity.getMirrorActivityId());
                }
                catch (Exception exception) {
                    if (!_log.isDebugEnabled()) break block10;
                    _log.debug((Object)exception, (Throwable)exception);
                }
            }
            if (mirrorActivity != null) {
                activity = mirrorActivity;
            }
        }
        if ((activityInterpreters = this._activityInterpreters.get(selector)) == null) {
            return null;
        }
        String className = PortalUtil.getClassName((long)activity.getClassNameId());
        for (SocialActivityInterpreter activityInterpreter : activityInterpreters) {
            SocialActivityFeedEntry activityFeedEntry;
            SocialActivityInterpreterImpl socialActivityInterpreterImpl = (SocialActivityInterpreterImpl)activityInterpreter;
            if (!socialActivityInterpreterImpl.hasClassName(className) || (activityFeedEntry = socialActivityInterpreterImpl.interpret(activity, serviceContext)) == null) continue;
            activityFeedEntry.setPortletId(socialActivityInterpreterImpl.getPortletId());
            return activityFeedEntry;
        }
        return null;
    }

    public SocialActivityFeedEntry interpret(String selector, SocialActivitySet activitySet, ServiceContext serviceContext) {
        HttpServletRequest httpServletRequest = serviceContext.getRequest();
        if (httpServletRequest == null) {
            return null;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            if (activitySet.getUserId() == themeDisplay.getDefaultUserId()) {
                return null;
            }
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
        List<SocialActivityInterpreter> activityInterpreters = this._activityInterpreters.get(selector);
        if (activityInterpreters == null) {
            return null;
        }
        String className = PortalUtil.getClassName((long)activitySet.getClassNameId());
        for (SocialActivityInterpreter activityInterpreter : activityInterpreters) {
            SocialActivityFeedEntry activityFeedEntry;
            SocialActivityInterpreterImpl socialActivityInterpreterImpl = (SocialActivityInterpreterImpl)activityInterpreter;
            if (!socialActivityInterpreterImpl.hasClassName(className) || (activityFeedEntry = socialActivityInterpreterImpl.interpret(activitySet, serviceContext)) == null) continue;
            activityFeedEntry.setPortletId(socialActivityInterpreterImpl.getPortletId());
            return activityFeedEntry;
        }
        return null;
    }

    public void updateActivitySet(long activityId) throws PortalException {
        if (!PropsValues.SOCIAL_ACTIVITY_SETS_BUNDLING_ENABLED) {
            this.socialActivitySetLocalService.addActivitySet(activityId);
            return;
        }
        List<SocialActivityInterpreter> activityInterpreters = this._activityInterpreters.get(PropsValues.SOCIAL_ACTIVITY_SETS_SELECTOR);
        if (activityInterpreters != null) {
            SocialActivity activity = this.socialActivityPersistence.findByPrimaryKey(activityId);
            String className = PortalUtil.getClassName((long)activity.getClassNameId());
            for (SocialActivityInterpreter activityInterpreter : activityInterpreters) {
                SocialActivityInterpreterImpl socialActivityInterpreterImpl = (SocialActivityInterpreterImpl)activityInterpreter;
                if (!socialActivityInterpreterImpl.hasClassName(className)) continue;
                socialActivityInterpreterImpl.updateActivitySet(activityId);
                return;
            }
        }
    }

    private class SocialActivityInterpreterServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<SocialActivityInterpreter, SocialActivityInterpreter> {
        private SocialActivityInterpreterServiceTrackerCustomizer() {
        }

        public SocialActivityInterpreter addingService(ServiceReference<SocialActivityInterpreter> serviceReference) {
            ArrayList<SocialActivityInterpreter> activityInterpreters;
            Registry registry = RegistryUtil.getRegistry();
            SocialActivityInterpreter activityInterpreter = (SocialActivityInterpreter)registry.getService(serviceReference);
            if (!(activityInterpreter instanceof SocialRequestInterpreterImpl)) {
                String portletId = (String)serviceReference.getProperty("javax.portlet.name");
                activityInterpreter = new SocialActivityInterpreterImpl(portletId, activityInterpreter);
            }
            if ((activityInterpreters = (ArrayList<SocialActivityInterpreter>)SocialActivityInterpreterLocalServiceImpl.this._activityInterpreters.get(activityInterpreter.getSelector())) == null) {
                activityInterpreters = new ArrayList<SocialActivityInterpreter>();
            }
            activityInterpreters.add(activityInterpreter);
            SocialActivityInterpreterLocalServiceImpl.this._activityInterpreters.put(activityInterpreter.getSelector(), activityInterpreters);
            return activityInterpreter;
        }

        public void modifiedService(ServiceReference<SocialActivityInterpreter> serviceReference, SocialActivityInterpreter activityInterpreter) {
        }

        public void removedService(ServiceReference<SocialActivityInterpreter> serviceReference, SocialActivityInterpreter activityInterpreter) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            List activityInterpreters = (List)SocialActivityInterpreterLocalServiceImpl.this._activityInterpreters.get(activityInterpreter.getSelector());
            if (activityInterpreters == null) {
                return;
            }
            activityInterpreters.remove(activityInterpreter);
        }
    }
}

