/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.usersadmin.atom;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.atom.AtomPager;
import com.liferay.portal.atom.AtomUtil;
import com.liferay.portal.kernel.atom.AtomEntryContent;
import com.liferay.portal.kernel.atom.AtomRequestContext;
import com.liferay.portal.kernel.atom.BaseAtomCollectionAdapter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.UserServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class UserAtomCollectionAdapter
extends BaseAtomCollectionAdapter<User> {
    private static final String _COLLECTION_NAME = "users";
    private static final Log _log = LogFactoryUtil.getLog(UserAtomCollectionAdapter.class);

    public String getCollectionName() {
        return _COLLECTION_NAME;
    }

    public List<String> getEntryAuthors(User user) {
        return ListUtil.fromArray((Object[])new String[]{user.getFullName()});
    }

    public AtomEntryContent getEntryContent(User user, AtomRequestContext atomRequestContext) {
        StringBundler sb;
        block3: {
            sb = new StringBundler();
            sb.append(user.getScreenName());
            sb.append("\n");
            sb.append(user.getEmailAddress());
            sb.append("\n");
            sb.append(user.getFullName());
            sb.append("\n");
            sb.append(user.getJobTitle());
            sb.append("\n");
            try {
                List userAddresses = user.getAddresses();
                for (Address address : userAddresses) {
                    sb.append(address.getStreet1());
                    sb.append("\n");
                    sb.append(address.getStreet2());
                    sb.append("\n");
                    sb.append(address.getStreet3());
                    sb.append("\n");
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)exception, (Throwable)exception);
            }
        }
        return new AtomEntryContent(sb.toString());
    }

    public String getEntryId(User user) {
        return String.valueOf(user.getUserId());
    }

    public String getEntrySummary(User user) {
        return user.getFullName();
    }

    public String getEntryTitle(User user) {
        return user.getScreenName();
    }

    public Date getEntryUpdated(User user) {
        return user.getModifiedDate();
    }

    public String getFeedTitle(AtomRequestContext atomRequestContext) {
        String portletId = PortletProviderUtil.getPortletId((String)User.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
        return AtomUtil.createFeedTitleFromPortletName(atomRequestContext, portletId);
    }

    protected User doGetEntry(String resourceName, AtomRequestContext atomRequestContext) throws Exception {
        long userId = GetterUtil.getLong((String)resourceName);
        return UserServiceUtil.getUserById((long)userId);
    }

    protected Iterable<User> doGetFeedEntries(AtomRequestContext atomRequestContext) throws Exception {
        long groupId = atomRequestContext.getLongParameter("groupId");
        if (groupId > 0L) {
            return UserServiceUtil.getGroupUsers((long)groupId);
        }
        long organizationId = atomRequestContext.getLongParameter("organizationId");
        if (organizationId > 0L) {
            return UserServiceUtil.getOrganizationUsers((long)organizationId);
        }
        long userGroupId = atomRequestContext.getLongParameter("userGroupId");
        if (userGroupId > 0L) {
            return UserServiceUtil.getUserGroupUsers((long)userGroupId);
        }
        long companyId = CompanyThreadLocal.getCompanyId();
        if (companyId > 0L) {
            int usersCount = UserServiceUtil.getCompanyUsersCount((long)companyId);
            AtomPager atomPager = new AtomPager(atomRequestContext, usersCount);
            AtomUtil.saveAtomPagerInRequest(atomRequestContext, atomPager);
            return UserServiceUtil.getCompanyUsers((long)companyId, (int)atomPager.getStart(), (int)(atomPager.getEnd() + 1));
        }
        return Collections.emptyList();
    }
}

