/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.asm;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ASMWrapperUtil {
    private static final Method _defineClassMethod;
    private static final Method _equalsMethod;
    private static final Method _hashCodeMethod;
    private static final Method _toStringMethod;

    public static <T> T createASMWrapper(ClassLoader classLoader, Class<T> interfaceClass, Object delegateObject, T defaultObject) {
        if (!interfaceClass.isInterface()) {
            throw new IllegalArgumentException(interfaceClass + " is not an interface");
        }
        Class<?> clazz = delegateObject.getClass();
        Package pkg = clazz.getPackage();
        StringBundler sb = new StringBundler(4);
        sb.append(pkg.getName());
        sb.append(".");
        sb.append(interfaceClass.getSimpleName());
        sb.append("ASMWrapper");
        String asmWrapperClassName = sb.toString();
        Class asmWrapperClass = null;
        ClassLoader classLoader2 = classLoader;
        synchronized (classLoader2) {
            try {
                try {
                    asmWrapperClass = classLoader.loadClass(asmWrapperClassName);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    byte[] classData = ASMWrapperUtil._generateASMWrapperClassData(StringUtil.replace((String)asmWrapperClassName, (char)'.', (char)'/'), interfaceClass, delegateObject, defaultObject);
                    asmWrapperClass = (Class)_defineClassMethod.invoke((Object)classLoader, asmWrapperClassName, classData, 0, classData.length);
                }
                Constructor<?> constructor = asmWrapperClass.getDeclaredConstructor(delegateObject.getClass(), defaultObject.getClass());
                constructor.setAccessible(true);
                return (T)constructor.newInstance(delegateObject, defaultObject);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
    }

    private static <T> byte[] _generateASMWrapperClassData(String asmWrapperClassBinaryName, Class<T> interfaceClass, Object delegateObject, T defaultObject) {
        String interfaceClassBinaryName = ASMWrapperUtil._getClassBinaryName(interfaceClass);
        Class<?> delegateObjectClass = delegateObject.getClass();
        String delegateObjectClassDescriptor = Type.getDescriptor(delegateObjectClass);
        String defaultObjectClassDescriptor = Type.getDescriptor(defaultObject.getClass());
        ClassWriter classWriter = new ClassWriter(1);
        classWriter.visit(51, 33, asmWrapperClassBinaryName, null, ASMWrapperUtil._getClassBinaryName(Object.class), new String[]{interfaceClassBinaryName});
        FieldVisitor fieldVisitor = classWriter.visitField(18, "_delegate", delegateObjectClassDescriptor, null, null);
        fieldVisitor.visitEnd();
        fieldVisitor = classWriter.visitField(18, "_default", defaultObjectClassDescriptor, null, null);
        fieldVisitor.visitEnd();
        MethodVisitor methodVisitor = classWriter.visitMethod(2, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(delegateObjectClass), Type.getType((String)defaultObjectClassDescriptor)}), null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitFieldInsn(181, asmWrapperClassBinaryName, "_delegate", delegateObjectClassDescriptor);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitFieldInsn(181, asmWrapperClassBinaryName, "_default", defaultObjectClassDescriptor);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        for (Method method : interfaceClass.getMethods()) {
            try {
                Method delegateMethod = delegateObjectClass.getMethod(method.getName(), method.getParameterTypes());
                ASMWrapperUtil._generateMethod(classWriter, delegateMethod, asmWrapperClassBinaryName, "_delegate", delegateObjectClassDescriptor, ASMWrapperUtil._getClassBinaryName(delegateObjectClass));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ASMWrapperUtil._generateMethod(classWriter, method, asmWrapperClassBinaryName, "_default", defaultObjectClassDescriptor, ASMWrapperUtil._getClassBinaryName(defaultObject.getClass()));
            }
        }
        ASMWrapperUtil._generateMethod(classWriter, _equalsMethod, asmWrapperClassBinaryName, "_delegate", delegateObjectClassDescriptor, ASMWrapperUtil._getClassBinaryName(delegateObjectClass));
        ASMWrapperUtil._generateMethod(classWriter, _hashCodeMethod, asmWrapperClassBinaryName, "_delegate", delegateObjectClassDescriptor, ASMWrapperUtil._getClassBinaryName(delegateObjectClass));
        ASMWrapperUtil._generateMethod(classWriter, _toStringMethod, asmWrapperClassBinaryName, "_delegate", delegateObjectClassDescriptor, ASMWrapperUtil._getClassBinaryName(delegateObjectClass));
        classWriter.visitEnd();
        return classWriter.toByteArray();
    }

    private static void _generateMethod(ClassWriter classWriter, Method method, String asmWrapperClassBinaryName, String fieldName, String targetClassDescriptor, String targetClassBinaryName) {
        Class<?>[] exceptions = method.getExceptionTypes();
        String[] exceptionsBinaryClassNames = new String[exceptions.length];
        for (int i = 0; i < exceptions.length; ++i) {
            exceptionsBinaryClassNames[i] = ASMWrapperUtil._getClassBinaryName(exceptions[i]);
        }
        MethodVisitor methodVisitor = classWriter.visitMethod(1, method.getName(), Type.getMethodDescriptor((Method)method), null, exceptionsBinaryClassNames);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, asmWrapperClassBinaryName, fieldName, targetClassDescriptor);
        int i = 1;
        for (Class<?> parameterClass : method.getParameterTypes()) {
            Type type = Type.getType(parameterClass);
            methodVisitor.visitVarInsn(type.getOpcode(21), i);
            i += type.getSize();
        }
        methodVisitor.visitMethodInsn(182, targetClassBinaryName, method.getName(), Type.getMethodDescriptor((Method)method), false);
        Type type = Type.getType(method.getReturnType());
        methodVisitor.visitInsn(type.getOpcode(172));
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private static String _getClassBinaryName(Class<?> clazz) {
        String className = clazz.getName();
        return StringUtil.replace((String)className, (char)'.', (char)'/');
    }

    private ASMWrapperUtil() {
    }

    static {
        try {
            _defineClassMethod = ReflectionUtil.getDeclaredMethod(ClassLoader.class, (String)"defineClass", (Class[])new Class[]{String.class, byte[].class, Integer.TYPE, Integer.TYPE});
            _equalsMethod = ReflectionUtil.getDeclaredMethod(Object.class, (String)"equals", (Class[])new Class[]{Object.class});
            _hashCodeMethod = ReflectionUtil.getDeclaredMethod(Object.class, (String)"hashCode", (Class[])new Class[0]);
            _toStringMethod = ReflectionUtil.getDeclaredMethod(Object.class, (String)"toString", (Class[])new Class[0]);
        }
        catch (Throwable throwable) {
            throw new ExceptionInInitializerError(throwable);
        }
    }
}

