/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.jdbc.aop;

import com.liferay.portal.kernel.aop.AopMethodInvocation;
import com.liferay.portal.kernel.aop.ChainableMethodAdvice;
import com.liferay.portal.kernel.dao.jdbc.aop.DynamicDataSourceTargetSource;
import com.liferay.portal.kernel.dao.jdbc.aop.MasterDataSource;
import com.liferay.portal.kernel.dao.jdbc.aop.Operation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.spring.transaction.TransactionAttributeBuilder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.transaction.interceptor.TransactionAttribute;

public class DynamicDataSourceAdvice
extends ChainableMethodAdvice {
    private final DynamicDataSourceTargetSource _dynamicDataSourceTargetSource;

    public DynamicDataSourceAdvice(DynamicDataSourceTargetSource dynamicDataSourceTargetSource) {
        this._dynamicDataSourceTargetSource = dynamicDataSourceTargetSource;
    }

    public Object createMethodContext(Class<?> targetClass, Method method, Map<Class<? extends Annotation>, Annotation> annotations) {
        Transactional transactional = (Transactional)annotations.get(Transactional.class);
        TransactionAttribute transactionAttribute = TransactionAttributeBuilder.build(transactional);
        if (transactionAttribute == null) {
            return null;
        }
        Operation operation = Operation.WRITE;
        MasterDataSource masterDataSource = (MasterDataSource)annotations.get(MasterDataSource.class);
        if (masterDataSource == null && transactional.readOnly()) {
            operation = Operation.READ;
        }
        return operation;
    }

    protected Object before(AopMethodInvocation aopMethodInvocation, Object[] arguments) {
        Operation operation = (Operation)aopMethodInvocation.getAdviceMethodContext();
        this._dynamicDataSourceTargetSource.pushOperation(operation);
        return null;
    }

    protected void duringFinally(AopMethodInvocation aopMethodInvocation, Object[] arguments) {
        this._dynamicDataSourceTargetSource.popOperation();
    }
}

