/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate;

import com.liferay.portal.dao.orm.hibernate.DialectImpl;
import com.liferay.portal.dao.orm.hibernate.SessionImpl;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.ORMException;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionCustomizer;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PreloadClassLoader;
import com.liferay.portal.util.PropsValues;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerList;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.engine.SessionFactoryImplementor;

public class SessionFactoryImpl
implements SessionFactory {
    private static final String[] _PRELOAD_CLASS_NAMES = PropsValues.SPRING_HIBERNATE_SESSION_FACTORY_PRELOAD_CLASSLOADER_CLASSES;
    private static final Log _log = LogFactoryUtil.getLog(SessionFactoryImpl.class);
    private final ServiceTrackerList<SessionCustomizer> _sessionCustomizers = ServiceTrackerCollections.openList(SessionCustomizer.class);
    private ClassLoader _sessionFactoryClassLoader;
    private SessionFactoryImplementor _sessionFactoryImplementor;

    public void closeSession(Session session) throws ORMException {
        if (session != null && !PropsValues.SPRING_HIBERNATE_SESSION_DELEGATED) {
            session.flush();
            session.close();
        }
    }

    public void destroy() {
        this._sessionCustomizers.close();
    }

    public Session getCurrentSession() throws ORMException {
        return this.wrapSession((org.hibernate.Session)this._sessionFactoryImplementor.getCurrentSession());
    }

    public Dialect getDialect() throws ORMException {
        return new DialectImpl(this._sessionFactoryImplementor.getDialect());
    }

    public SessionFactoryImplementor getSessionFactoryImplementor() {
        return this._sessionFactoryImplementor;
    }

    public Session openNewSession(Connection connection) throws ORMException {
        return this.wrapSession((org.hibernate.Session)this._sessionFactoryImplementor.openSession(connection));
    }

    public Session openSession() throws ORMException {
        org.hibernate.classic.Session session = null;
        session = PropsValues.SPRING_HIBERNATE_SESSION_DELEGATED ? this._sessionFactoryImplementor.getCurrentSession() : this._sessionFactoryImplementor.openSession();
        if (_log.isDebugEnabled()) {
            org.hibernate.impl.SessionImpl sessionImpl = (org.hibernate.impl.SessionImpl)session;
            _log.debug((Object)("Session is using connection release mode " + sessionImpl.getConnectionReleaseMode()));
        }
        return this.wrapSession((org.hibernate.Session)session);
    }

    public void setSessionFactoryClassLoader(ClassLoader sessionFactoryClassLoader) {
        if (sessionFactoryClassLoader != PortalClassLoaderUtil.getClassLoader()) {
            this._sessionFactoryClassLoader = new PreloadClassLoader(sessionFactoryClassLoader, this.getPreloadClassLoaderClasses());
        }
    }

    public void setSessionFactoryImplementor(SessionFactoryImplementor sessionFactoryImplementor) {
        this._sessionFactoryImplementor = sessionFactoryImplementor;
    }

    protected Map<String, Class<?>> getPreloadClassLoaderClasses() {
        try {
            HashMap classes = new HashMap();
            for (String className : _PRELOAD_CLASS_NAMES) {
                ClassLoader portalClassLoader = PortalClassLoaderUtil.getClassLoader();
                Class<?> clazz = portalClassLoader.loadClass(className);
                classes.put(className, clazz);
            }
            return classes;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    protected Session wrapSession(org.hibernate.Session session) {
        SessionImpl liferaySession = new SessionImpl(session, this._sessionFactoryClassLoader);
        for (SessionCustomizer sessionCustomizer : this._sessionCustomizers) {
            liferaySession = sessionCustomizer.customize((Session)liferaySession);
        }
        return liferaySession;
    }
}

