/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalServiceUtil;
import com.liferay.portal.events.StartupHelperUtil;
import com.liferay.portal.fabric.server.FabricServerUtil;
import com.liferay.portal.jericho.CachedLoggerProvider;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.events.SimpleAction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.service.ClassNameLocalServiceUtil;
import com.liferay.portal.kernel.util.BasePortalLifecycle;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.PortalLifecycle;
import com.liferay.portal.kernel.util.PortalLifecycleUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.tools.DBUpgrader;
import com.liferay.portal.util.PropsValues;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceRegistration;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class StartupAction
extends SimpleAction {
    private static final Log _log = LogFactoryUtil.getLog(StartupAction.class);

    public void run(String[] ids) throws ActionException {
        try {
            this.doRun(ids);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new ActionException((Throwable)exception);
        }
    }

    protected void doRun(String[] ids) throws Exception {
        DB db;
        Class<?> clazz = ((Object)((Object)this)).getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        try (InputStream inputStream = classLoader.getResourceAsStream("com/liferay/portal/events/dependencies/startup.txt");){
            System.out.println(IOUtils.toString((InputStream)inputStream));
        }
        System.out.println("Starting " + ReleaseInfo.getReleaseInfo() + "\n");
        StartupHelperUtil.printPatchLevel();
        if (PropsValues.PORTAL_FABRIC_ENABLED) {
            FabricServerUtil.start();
        }
        if ((db = DBManagerUtil.getDB()).getDBType() == DBType.MYSQL && GetterUtil.getFloat((String)db.getVersionString()) < 5.6f) {
            _log.error((Object)"Please upgrade to at least MySQL 5.6.4. The portal no longer supports older versions of MySQL.");
            System.exit(1);
        }
        StartupHelperUtil.verifyRequiredSchemaVersion();
        DBUpgrader.checkReleaseState();
        Registry registry = RegistryUtil.getRegistry();
        final ServiceRegistration moduleServiceLifecycleServiceRegistration = registry.registerService(ModuleServiceLifecycle.class, (Object)new ModuleServiceLifecycle(){}, (Map)HashMapBuilder.put((Object)"module.service.lifecycle", (Object)"database.initialized").put((Object)"service.vendor", (Object)ReleaseInfo.getVendor()).put((Object)"service.version", (Object)ReleaseInfo.getVersion()).build());
        PortalLifecycleUtil.register((PortalLifecycle)new BasePortalLifecycle(){

            protected void doPortalDestroy() {
                moduleServiceLifecycleServiceRegistration.unregister();
            }

            protected void doPortalInit() {
            }
        }, (int)1);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Check class names");
        }
        ClassNameLocalServiceUtil.checkClassNames();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Check resource actions");
        }
        StartupHelperUtil.initResourceActions();
        if (StartupHelperUtil.isDBNew()) {
            DBUpgrader.verify();
            DLFileEntryTypeLocalServiceUtil.getBasicDocumentDLFileEntryType();
        }
        if (PropsValues.DATABASE_INDEXES_UPDATE_ON_STARTUP) {
            StartupHelperUtil.updateIndexes(true);
        }
        CachedLoggerProvider.install();
    }
}

