/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.image;

import com.liferay.document.library.kernel.exception.NoSuchFileException;
import com.liferay.document.library.kernel.store.DLStoreUtil;
import com.liferay.document.library.kernel.util.DLValidatorUtil;
import com.liferay.portal.image.BaseHook;
import com.liferay.portal.kernel.exception.NoSuchImageException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.util.FileUtil;
import java.io.IOException;
import java.io.InputStream;

public class DLHook
extends BaseHook {
    private static final long _REPOSITORY_ID = 0L;

    public void deleteImage(Image image) throws PortalException {
        String fileName = this.getFileName(image.getImageId(), image.getType());
        try {
            DLStoreUtil.deleteFile((long)image.getCompanyId(), (long)0L, (String)fileName);
        }
        catch (NoSuchFileException noSuchFileException) {
            throw new NoSuchImageException((Throwable)noSuchFileException);
        }
    }

    public byte[] getImageAsBytes(Image image) throws PortalException {
        InputStream inputStream = DLStoreUtil.getFileAsStream((long)image.getCompanyId(), (long)0L, (String)this.getFileName(image.getImageId(), image.getType()));
        byte[] bytes = null;
        try {
            bytes = FileUtil.getBytes((InputStream)inputStream);
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
        return bytes;
    }

    public InputStream getImageAsStream(Image image) throws PortalException {
        return DLStoreUtil.getFileAsStream((long)image.getCompanyId(), (long)0L, (String)this.getFileName(image.getImageId(), image.getType()));
    }

    public void updateImage(Image image, String type, byte[] bytes) throws PortalException {
        String fileName = this.getFileName(image.getImageId(), image.getType());
        DLValidatorUtil.validateFileSize((String)fileName, (byte[])bytes);
        if (DLStoreUtil.hasFile((long)image.getCompanyId(), (long)0L, (String)fileName)) {
            DLStoreUtil.deleteFile((long)image.getCompanyId(), (long)0L, (String)fileName);
        }
        DLStoreUtil.addFile((long)image.getCompanyId(), (long)0L, (String)fileName, (boolean)true, (byte[])bytes);
    }

    protected String getFileName(long imageId, String type) {
        return imageId + "." + type;
    }
}

