/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.layoutconfiguration.util;

import com.liferay.petra.io.unsync.UnsyncStringWriter;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.layoutconfiguration.util.RuntimePage;
import com.liferay.portal.kernel.layoutconfiguration.util.xml.RuntimeLogic;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.LayoutTemplate;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.service.LayoutTemplateLocalServiceUtil;
import com.liferay.portal.kernel.servlet.PipingServletResponse;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManager;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.layoutconfiguration.util.PortletRenderer;
import com.liferay.portal.layoutconfiguration.util.velocity.TemplateProcessor;
import com.liferay.portal.layoutconfiguration.util.xml.ActionURLLogic;
import com.liferay.portal.layoutconfiguration.util.xml.PortletLogic;
import com.liferay.portal.layoutconfiguration.util.xml.RenderURLLogic;
import com.liferay.portlet.internal.PortletBagUtil;
import com.liferay.portlet.internal.PortletTypeUtil;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletResponse;
import javax.portlet.RenderResponse;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.time.StopWatch;

public class RuntimePageImpl
implements RuntimePage {
    private static final Log _log = LogFactoryUtil.getLog(RuntimePageImpl.class);

    public LayoutTemplate getLayoutTemplate(String velocityTemplateId) {
        String separator = "_CUSTOM_";
        boolean standard = false;
        if (velocityTemplateId.contains("_STANDARD_")) {
            separator = "_STANDARD_";
            standard = true;
        }
        String layoutTemplateId = null;
        String themeId = null;
        int pos = velocityTemplateId.indexOf(separator);
        if (pos != -1) {
            layoutTemplateId = velocityTemplateId.substring(pos + separator.length());
            themeId = velocityTemplateId.substring(0, pos);
        }
        if ((pos = layoutTemplateId.indexOf("_INSTANCE_")) != -1) {
            layoutTemplateId = layoutTemplateId.substring(pos + "_INSTANCE_".length() + 1);
            pos = layoutTemplateId.indexOf("_");
            layoutTemplateId = layoutTemplateId.substring(pos + 1);
        }
        return LayoutTemplateLocalServiceUtil.getLayoutTemplate((String)layoutTemplateId, (boolean)standard, themeId);
    }

    public StringBundler getProcessedTemplate(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String portletId, TemplateResource templateResource) throws Exception {
        return this.doDispatch(httpServletRequest, httpServletResponse, portletId, templateResource, "vm");
    }

    public void processTemplate(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String portletId, TemplateResource templateResource) throws Exception {
        StringBundler sb = this.doDispatch(httpServletRequest, httpServletResponse, portletId, templateResource, "vm");
        sb.writeTo((Writer)httpServletResponse.getWriter());
    }

    public void processTemplate(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String portletId, TemplateResource templateResource, String langType) throws Exception {
        StringBundler sb = this.doDispatch(httpServletRequest, httpServletResponse, portletId, templateResource, langType);
        sb.writeTo((Writer)httpServletResponse.getWriter());
    }

    public void processTemplate(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, TemplateResource templateResource) throws Exception {
        this.processTemplate(httpServletRequest, httpServletResponse, null, templateResource);
    }

    public void processTemplate(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, TemplateResource templateResource, String langType) throws Exception {
        this.processTemplate(httpServletRequest, httpServletResponse, null, templateResource, langType);
    }

    public String processXML(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String content) throws Exception {
        PortletResponse portletResponse = (PortletResponse)httpServletRequest.getAttribute("javax.portlet.response");
        if (portletResponse != null && !(portletResponse instanceof RenderResponse)) {
            throw new IllegalArgumentException("processXML can only be invoked in the render phase");
        }
        PortletLogic portletLogic = new PortletLogic(httpServletRequest, httpServletResponse);
        content = this.processXML(httpServletRequest, content, portletLogic);
        if (portletResponse == null) {
            return content;
        }
        RenderResponse renderResponse = (RenderResponse)portletResponse;
        ActionURLLogic actionURLLogic = new ActionURLLogic(renderResponse);
        RenderURLLogic renderURLLogic = new RenderURLLogic(renderResponse);
        content = this.processXML(httpServletRequest, content, actionURLLogic);
        content = this.processXML(httpServletRequest, content, renderURLLogic);
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processXML(HttpServletRequest httpServletRequest, String content, RuntimeLogic runtimeLogic) throws Exception {
        if (Validator.isNull((String)content)) {
            return "";
        }
        int index = content.indexOf(runtimeLogic.getOpenTag());
        if (index == -1) {
            return content;
        }
        Portlet renderPortlet = (Portlet)httpServletRequest.getAttribute("RENDER_PORTLET");
        Boolean renderPortletResource = (Boolean)httpServletRequest.getAttribute("RENDER_PORTLET_RESOURCE");
        String outerPortletId = (String)httpServletRequest.getAttribute("OUTER_PORTLET_ID");
        if (outerPortletId == null) {
            httpServletRequest.setAttribute("OUTER_PORTLET_ID", (Object)renderPortlet.getPortletId());
        }
        try {
            httpServletRequest.setAttribute("RENDER_PORTLET_RESOURCE", (Object)Boolean.TRUE);
            StringBundler sb = new StringBundler();
            int x = 0;
            int y = index;
            while (y != -1) {
                sb.append(content.substring(x, y));
                String close1Tag = runtimeLogic.getClose1Tag();
                String close2Tag = runtimeLogic.getClose2Tag();
                int close1 = content.indexOf(close1Tag, y);
                int close2 = content.indexOf(close2Tag, y);
                x = close2 == -1 || close1 != -1 && close1 < close2 ? close1 + close1Tag.length() : close2 + close2Tag.length();
                String runtimePortletTag = content.substring(y, x);
                if (renderPortlet != null && runtimePortletTag.contains(renderPortlet.getPortletId())) {
                    String string = "";
                    return string;
                }
                sb.append(runtimeLogic.processXML(runtimePortletTag));
                y = content.indexOf(runtimeLogic.getOpenTag(), x);
            }
            if (y == -1) {
                sb.append(content.substring(x));
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (outerPortletId == null) {
                httpServletRequest.removeAttribute("OUTER_PORTLET_ID");
            }
            httpServletRequest.setAttribute("RENDER_PORTLET", (Object)renderPortlet);
            if (renderPortletResource == null) {
                httpServletRequest.removeAttribute("RENDER_PORTLET_RESOURCE");
            } else {
                httpServletRequest.setAttribute("RENDER_PORTLET_RESOURCE", (Object)renderPortletResource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StringBundler doDispatch(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String portletId, TemplateResource templateResource, String langType) throws Exception {
        String pluginServletContextName;
        ServletContext pluginServletContext;
        ClassLoader pluginClassLoader = null;
        LayoutTemplate layoutTemplate = this.getLayoutTemplate(templateResource.getTemplateId());
        if (layoutTemplate != null && (pluginServletContext = ServletContextPool.get((String)(pluginServletContextName = GetterUtil.getString((String)layoutTemplate.getServletContextName())))) != null) {
            pluginClassLoader = (ClassLoader)pluginServletContext.getAttribute("PLUGIN_CLASS_LOADER");
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            if (pluginClassLoader != null && pluginClassLoader != contextClassLoader) {
                currentThread.setContextClassLoader(pluginClassLoader);
            }
            StringBundler stringBundler = this.doProcessTemplate(httpServletRequest, httpServletResponse, portletId, templateResource, langType, false);
            return stringBundler;
        }
        finally {
            if (pluginClassLoader != null && pluginClassLoader != contextClassLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    protected StringBundler doProcessTemplate(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String portletId, TemplateResource templateResource, String langType, boolean restricted) throws Exception {
        javax.portlet.Portlet portlet;
        TemplateProcessor processor = new TemplateProcessor(httpServletRequest, httpServletResponse, portletId);
        TemplateManager templateManager = TemplateManagerUtil.getTemplateManager((String)langType);
        Template template = templateManager.getTemplate(templateResource, restricted);
        template.put((Object)"processor", (Object)processor);
        template.prepare(httpServletRequest);
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        template.prepareTaglib(httpServletRequest, (HttpServletResponse)new PipingServletResponse(httpServletResponse, (Writer)unsyncStringWriter));
        try {
            template.processTemplate((Writer)unsyncStringWriter);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw exception;
        }
        Map<Integer, List<PortletRenderer>> portletRenderersMap = processor.getPortletRenderers();
        HashMap<String, Map<String, Object>> portletHeaderRequestMap = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<Integer, List<PortletRenderer>> entry : portletRenderersMap.entrySet()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Processing portlets with render weight " + entry.getKey()));
            }
            List<PortletRenderer> portletRenderers = entry.getValue();
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Start serial header phase");
            }
            for (PortletRenderer portletRenderer : portletRenderers) {
                Portlet portletModel = portletRenderer.getPortlet();
                if (!portletModel.isReady() || !PortletTypeUtil.isHeaderPortlet(portlet = PortletBagUtil.getPortletInstance(httpServletRequest.getServletContext(), portletModel, portletModel.getRootPortletId()))) continue;
                Map<String, Object> headerRequestMap = portletRenderer.renderHeaders(httpServletRequest, httpServletResponse, portletModel.getHeaderRequestAttributePrefixes());
                String rendererPortletId = portletModel.getPortletId();
                portletHeaderRequestMap.put(rendererPortletId, headerRequestMap);
                if (!_log.isDebugEnabled()) continue;
                StringBundler sb = new StringBundler(5);
                sb.append("Serially rendered headers for portlet ");
                sb.append(rendererPortletId);
                sb.append(" in ");
                sb.append(stopWatch.getTime());
                sb.append(" ms");
                _log.debug((Object)sb.toString());
            }
            if (!_log.isDebugEnabled()) continue;
            _log.debug((Object)("Finished serial header phase in " + stopWatch.getTime() + " ms"));
        }
        HashMap<String, StringBundler> contentsMap = new HashMap<String, StringBundler>();
        for (Map.Entry<Integer, List<PortletRenderer>> entry : portletRenderersMap.entrySet()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Processing portlets with render weight " + entry.getKey()));
            }
            List<PortletRenderer> portletRenderers = entry.getValue();
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Start serial rendering");
            }
            for (PortletRenderer portletRenderer : portletRenderers) {
                portlet = portletRenderer.getPortlet();
                String rendererPortletId = portlet.getPortletId();
                contentsMap.put(rendererPortletId, portletRenderer.render(httpServletRequest, httpServletResponse, (Map)portletHeaderRequestMap.get(rendererPortletId)));
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Serially rendered portlet ", rendererPortletId, " in ", stopWatch.getTime(), " ms"}));
            }
            if (!_log.isDebugEnabled()) continue;
            _log.debug((Object)("Finished serial rendering in " + stopWatch.getTime() + " ms"));
        }
        return StringUtil.replaceWithStringBundler((String)unsyncStringWriter.toString(), (String)"[$TEMPLATE_PORTLET_", (String)"$]", contentsMap);
    }
}

