/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.minifier;

import com.liferay.petra.io.unsync.UnsyncStringReader;
import com.liferay.petra.io.unsync.UnsyncStringWriter;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.internal.minifier.MinifierThreadLocal;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.minifier.CSSCompressor;
import com.liferay.portal.minifier.JavaScriptMinifier;
import com.liferay.portal.util.PropsValues;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceTracker;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.lang.time.StopWatch;

@Deprecated
public class MinifierUtil {
    private static final Log _log = LogFactoryUtil.getLog(MinifierUtil.class);
    private static final ServiceTracker<JavaScriptMinifier, JavaScriptMinifier> _javaScriptMinifierServiceTracker;

    public static String minifyCss(String content) {
        if (PropsValues.MINIFIER_ENABLED && MinifierThreadLocal.isEnabled()) {
            return MinifierUtil._minifyCss(content);
        }
        return content;
    }

    public static String minifyJavaScript(String resourceName, String content) {
        if (PropsValues.MINIFIER_ENABLED && MinifierThreadLocal.isEnabled()) {
            return MinifierUtil._minifyJavaScript(resourceName, content);
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String _minifyCss(String content) {
        String string;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        try {
            CSSCompressor cssCompressor = new CSSCompressor((Reader)new UnsyncStringReader(content));
            cssCompressor.compress((Writer)unsyncStringWriter, PropsValues.YUI_COMPRESSOR_CSS_LINE_BREAK);
            string = unsyncStringWriter.toString();
        }
        catch (Exception exception) {
            String string2;
            try {
                _log.error((Object)("Unable to minify CSS:\n" + content), (Throwable)exception);
                unsyncStringWriter.append((CharSequence)content);
                string2 = unsyncStringWriter.toString();
            }
            catch (Throwable throwable) {
                if (_log.isDebugEnabled()) {
                    int length = 0;
                    if (content != null) {
                        byte[] bytes = content.getBytes();
                        length = bytes.length;
                    }
                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Minification for ", length, " bytes of CSS took ", stopWatch.getTime(), " ms"}));
                }
                throw throwable;
            }
            if (_log.isDebugEnabled()) {
                int length = 0;
                if (content != null) {
                    byte[] bytes = content.getBytes();
                    length = bytes.length;
                }
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Minification for ", length, " bytes of CSS took ", stopWatch.getTime(), " ms"}));
            }
            return string2;
        }
        if (_log.isDebugEnabled()) {
            int length = 0;
            if (content != null) {
                byte[] bytes = content.getBytes();
                length = bytes.length;
            }
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Minification for ", length, " bytes of CSS took ", stopWatch.getTime(), " ms"}));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String _minifyJavaScript(String resourceName, String content) {
        String string;
        JavaScriptMinifier javaScriptMinifier = (JavaScriptMinifier)_javaScriptMinifierServiceTracker.getService();
        if (javaScriptMinifier == null) {
            return content;
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            string = javaScriptMinifier.compress(resourceName, content);
        }
        catch (Throwable throwable) {
            if (_log.isDebugEnabled()) {
                int length = 0;
                if (content != null) {
                    byte[] bytes = content.getBytes();
                    length = bytes.length;
                }
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Minification for ", length, " bytes of JavaScript in resource ", resourceName, " took ", stopWatch.getTime(), " ms"}));
            }
            throw throwable;
        }
        if (_log.isDebugEnabled()) {
            int length = 0;
            if (content != null) {
                byte[] bytes = content.getBytes();
                length = bytes.length;
            }
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Minification for ", length, " bytes of JavaScript in resource ", resourceName, " took ", stopWatch.getTime(), " ms"}));
        }
        return string;
    }

    private MinifierUtil() {
    }

    static {
        Registry registry = RegistryUtil.getRegistry();
        _javaScriptMinifierServiceTracker = registry.trackServices(JavaScriptMinifier.class);
        _javaScriptMinifierServiceTracker.open();
    }
}

