/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth.http;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.AuthException;
import com.liferay.portal.kernel.security.auth.http.HttpAuthManager;
import com.liferay.portal.kernel.security.auth.http.HttpAuthManagerUtil;
import com.liferay.portal.kernel.security.auth.http.HttpAuthorizationHeader;
import com.liferay.portal.kernel.security.auth.session.AuthenticatedSessionManagerUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.filters.secure.NonceUtil;
import com.liferay.portal.util.PortalInstances;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpAuthManagerImpl
implements HttpAuthManager {
    private static final Log _log = LogFactoryUtil.getLog(HttpAuthManagerImpl.class);

    public void generateChallenge(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, HttpAuthorizationHeader httpAuthorizationHeader) {
        String scheme;
        if (httpServletRequest == null) {
            throw new IllegalArgumentException("HTTP servlet request is null");
        }
        if (httpServletResponse == null) {
            throw new IllegalArgumentException("HTTP servlet response is null");
        }
        if (httpAuthorizationHeader == null || Validator.isBlank((String)httpAuthorizationHeader.getScheme())) {
            throw new IllegalArgumentException("HTTP authorization header scheme is null");
        }
        String realm = httpAuthorizationHeader.getAuthParameter("realm");
        if (Validator.isBlank((String)realm)) {
            httpAuthorizationHeader.setAuthParameter("realm", "PortalRealm");
        }
        if (StringUtil.equalsIgnoreCase((String)(scheme = httpAuthorizationHeader.getScheme()), (String)"Basic")) {
            this.generateBasicChallenge(httpServletRequest, httpServletResponse, httpAuthorizationHeader);
        } else if (StringUtil.equalsIgnoreCase((String)scheme, (String)"Digest")) {
            this.generateDigestChallenge(httpServletRequest, httpServletResponse, httpAuthorizationHeader);
        } else {
            throw new UnsupportedOperationException("Scheme " + scheme);
        }
    }

    public long getBasicUserId(HttpServletRequest httpServletRequest) throws PortalException {
        HttpAuthorizationHeader httpAuthorizationHeader = HttpAuthManagerUtil.parse((HttpServletRequest)httpServletRequest);
        if (httpAuthorizationHeader == null || !StringUtil.equalsIgnoreCase((String)httpAuthorizationHeader.getScheme(), (String)"Basic")) {
            return 0L;
        }
        return this.getUserId(httpServletRequest, httpAuthorizationHeader);
    }

    public long getDigestUserId(HttpServletRequest httpServletRequest) throws PortalException {
        HttpAuthorizationHeader httpAuthorizationHeader = HttpAuthManagerUtil.parse((HttpServletRequest)httpServletRequest);
        if (httpAuthorizationHeader == null || !StringUtil.equalsIgnoreCase((String)httpAuthorizationHeader.getScheme(), (String)"Digest")) {
            return 0L;
        }
        return this.getUserId(httpServletRequest, httpAuthorizationHeader);
    }

    public long getUserId(HttpServletRequest httpServletRequest, HttpAuthorizationHeader httpAuthorizationHeader) throws PortalException {
        if (httpServletRequest == null) {
            throw new IllegalArgumentException("HTTP servlet request is null");
        }
        if (httpAuthorizationHeader == null || Validator.isBlank((String)httpAuthorizationHeader.getScheme())) {
            throw new IllegalArgumentException("HTTP authorization header scheme is null");
        }
        String scheme = httpAuthorizationHeader.getScheme();
        if (StringUtil.equalsIgnoreCase((String)scheme, (String)"Basic")) {
            return this.getBasicUserId(httpServletRequest, httpAuthorizationHeader);
        }
        if (StringUtil.equalsIgnoreCase((String)scheme, (String)"Digest")) {
            return this.getDigestUserId(httpServletRequest, httpAuthorizationHeader);
        }
        throw new UnsupportedOperationException("Scheme " + scheme);
    }

    public HttpAuthorizationHeader parse(HttpServletRequest httpServletRequest) {
        if (httpServletRequest == null) {
            throw new IllegalArgumentException("HTTP servlet request is null");
        }
        String authorization = httpServletRequest.getHeader("Authorization");
        if (Validator.isBlank((String)authorization)) {
            return null;
        }
        String[] authorizationParts = authorization.split("\\s");
        String scheme = authorizationParts[0];
        if (StringUtil.equalsIgnoreCase((String)scheme, (String)"Basic")) {
            return this.parseBasic(httpServletRequest, authorization, authorizationParts);
        }
        if (StringUtil.equalsIgnoreCase((String)scheme, (String)"Bearer")) {
            return new HttpAuthorizationHeader("Bearer");
        }
        if (StringUtil.equalsIgnoreCase((String)scheme, (String)"Digest")) {
            return this.parseDigest(httpServletRequest, authorization, authorizationParts);
        }
        throw new UnsupportedOperationException("Scheme " + scheme);
    }

    protected void generateBasicChallenge(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, HttpAuthorizationHeader httpAuthorizationHeader) {
        httpServletResponse.setHeader("WWW-Authenticate", httpAuthorizationHeader.toString());
        httpServletResponse.setStatus(401);
    }

    protected void generateDigestChallenge(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, HttpAuthorizationHeader httpAuthorizationHeader) {
        long companyId = PortalInstances.getCompanyId(httpServletRequest);
        String remoteAddress = httpServletRequest.getRemoteAddr();
        String nonce = NonceUtil.generate(companyId, remoteAddress);
        httpAuthorizationHeader.setAuthParameter("nonce", nonce);
        httpServletResponse.setHeader("WWW-Authenticate", httpAuthorizationHeader.toString());
        httpServletResponse.setStatus(401);
    }

    protected long getBasicUserId(HttpServletRequest httpServletRequest, HttpAuthorizationHeader httpAuthorizationHeader) throws PortalException {
        int pos;
        String login = httpAuthorizationHeader.getAuthParameter("username");
        if (login.endsWith("@uid")) {
            pos = login.indexOf("@uid");
            login = login.substring(0, pos);
        } else if (login.endsWith("@sn")) {
            pos = login.indexOf("@sn");
            login = login.substring(0, pos);
        }
        try {
            String password = httpAuthorizationHeader.getAuthParameter("password");
            return AuthenticatedSessionManagerUtil.getAuthenticatedUserId((HttpServletRequest)httpServletRequest, (String)login, (String)password, null);
        }
        catch (AuthException authException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)authException, (Throwable)authException);
            }
            return 0L;
        }
    }

    protected long getDigestUserId(HttpServletRequest httpServletRequest, HttpAuthorizationHeader httpAuthorizationHeader) throws PortalException {
        long userId = 0L;
        String username = httpAuthorizationHeader.getAuthParameter("username");
        String realm = httpAuthorizationHeader.getAuthParameter("realm");
        String nonce = httpAuthorizationHeader.getAuthParameter("nonce");
        String uri = httpAuthorizationHeader.getAuthParameter("uri");
        String response = httpAuthorizationHeader.getAuthParameter("response");
        if (Validator.isNull((String)username) || Validator.isNull((String)realm) || Validator.isNull((String)nonce) || Validator.isNull((String)uri) || Validator.isNull((String)response)) {
            return userId;
        }
        String requestURI = httpServletRequest.getRequestURI();
        String queryString = httpServletRequest.getQueryString();
        if (Validator.isNotNull((String)queryString)) {
            requestURI = StringBundler.concat((String[])new String[]{requestURI, "?", queryString});
        }
        if (!(realm.equals("PortalRealm") && uri.equals(requestURI) && NonceUtil.verify(nonce))) {
            return userId;
        }
        return UserLocalServiceUtil.authenticateForDigest((long)PortalInstances.getCompanyId(httpServletRequest), (String)username, (String)realm, (String)nonce, (String)httpServletRequest.getMethod(), (String)uri, (String)response);
    }

    protected HttpAuthorizationHeader parseBasic(HttpServletRequest httpServletRequest, String authorization, String[] authorizationParts) {
        String credentials = new String(Base64.decode((String)authorizationParts[1]));
        String login = null;
        String password = null;
        int index = credentials.indexOf(58);
        if (index > -1) {
            login = credentials.substring(0, index);
            login = HttpUtil.decodeURL((String)login.trim());
            password = credentials.substring(index + 1);
            password = password.trim();
        } else {
            login = credentials.trim();
        }
        HttpAuthorizationHeader httpAuthorizationHeader = new HttpAuthorizationHeader("Basic");
        httpAuthorizationHeader.setAuthParameter("username", login);
        httpAuthorizationHeader.setAuthParameter("password", password);
        return httpAuthorizationHeader;
    }

    protected HttpAuthorizationHeader parseDigest(HttpServletRequest httpServletRequest, String authorization, String[] authorizationHeaderParts) {
        HttpAuthorizationHeader httpAuthorizationHeader = new HttpAuthorizationHeader("Digest");
        authorization = authorization.substring("Digest".length() + 1);
        authorization = StringUtil.replace((String)authorization, (char)',', (char)'\n');
        UnicodeProperties authorizationUnicodeProperties = new UnicodeProperties();
        authorizationUnicodeProperties.fastLoad(authorization);
        for (Map.Entry authorizationProperty : authorizationUnicodeProperties.entrySet()) {
            String key = (String)authorizationProperty.getKey();
            String value = StringUtil.unquote((String)authorizationUnicodeProperties.getProperty(key));
            httpAuthorizationHeader.setAuthParameter(key, value);
        }
        return httpAuthorizationHeader;
    }
}

