/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission;

import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.security.permission.contributor.RoleContributor;
import com.liferay.portal.kernel.security.permission.wrapper.PermissionCheckerWrapperFactory;
import com.liferay.portal.security.permission.StagingPermissionChecker;
import com.liferay.portal.util.PropsValues;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerList;

public class PermissionCheckerFactoryImpl
implements PermissionCheckerFactory {
    private final PermissionChecker _permissionChecker;
    private ServiceTrackerList<PermissionCheckerWrapperFactory> _permissionCheckerWrapperFactories;
    private ServiceTrackerList<RoleContributor> _roleContributors;

    public PermissionCheckerFactoryImpl() throws Exception {
        Class<?> clazz = Class.forName(PropsValues.PERMISSIONS_CHECKER);
        this._permissionChecker = (PermissionChecker)clazz.newInstance();
    }

    public void afterPropertiesSet() {
        this._permissionCheckerWrapperFactories = ServiceTrackerCollections.openList(PermissionCheckerWrapperFactory.class);
        this._roleContributors = ServiceTrackerCollections.openList(RoleContributor.class);
    }

    public PermissionChecker create(User user) {
        PermissionChecker permissionChecker = this._permissionChecker.clone();
        permissionChecker.init(user, (RoleContributor[])this._roleContributors.toArray((Object[])new RoleContributor[0]));
        permissionChecker = new StagingPermissionChecker(permissionChecker);
        for (PermissionCheckerWrapperFactory permissionCheckerWrapperFactory : this._permissionCheckerWrapperFactories) {
            permissionChecker = permissionCheckerWrapperFactory.wrapPermissionChecker(permissionChecker);
        }
        return permissionChecker;
    }

    public void destroy() {
        this._permissionCheckerWrapperFactories.close();
        this._roleContributors.close();
    }
}

