/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pwd;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.UserPasswordException;
import com.liferay.portal.kernel.model.PasswordPolicy;
import com.liferay.portal.kernel.security.ldap.LDAPSettingsUtil;
import com.liferay.portal.kernel.security.pwd.Toolkit;
import com.liferay.portal.security.pwd.PwdToolkitUtilThreadLocal;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceTracker;

public class PwdToolkitUtil {
    private static final PwdToolkitUtil _pwdToolkitUtil = new PwdToolkitUtil();
    private final ServiceTracker<Toolkit, Toolkit> _serviceTracker;

    public static String generate(PasswordPolicy passwordPolicy) {
        Toolkit toolkit = PwdToolkitUtil.getToolkit();
        return toolkit.generate(passwordPolicy);
    }

    public static Toolkit getToolkit() {
        return (Toolkit)PwdToolkitUtil._pwdToolkitUtil._serviceTracker.getService();
    }

    public static void validate(long companyId, long userId, String password1, String password2, PasswordPolicy passwordPolicy) throws PortalException {
        if (!password1.equals(password2)) {
            throw new UserPasswordException.MustMatch(userId);
        }
        if (!LDAPSettingsUtil.isPasswordPolicyEnabled((long)companyId) && PwdToolkitUtilThreadLocal.isValidate()) {
            Toolkit toolkit = PwdToolkitUtil.getToolkit();
            toolkit.validate(userId, password1, password2, passwordPolicy);
        }
    }

    private PwdToolkitUtil() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(Toolkit.class);
        this._serviceTracker.open();
    }
}

