/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.PasswordPolicy;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.PasswordPolicyPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.service.base.PasswordPolicyServiceBaseImpl;
import java.util.List;

public class PasswordPolicyServiceImpl
extends PasswordPolicyServiceBaseImpl {
    public PasswordPolicy addPasswordPolicy(String name, String description, boolean changeable, boolean changeRequired, long minAge, boolean checkSyntax, boolean allowDictionaryWords, int minAlphanumeric, int minLength, int minLowerCase, int minNumbers, int minSymbols, int minUpperCase, String regex, boolean history, int historyCount, boolean expireable, long maxAge, long warningTime, int graceLimit, boolean lockout, int maxFailure, long lockoutDuration, long resetFailureCount, long resetTicketMaxAge, ServiceContext serviceContext) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"ADD_PASSWORD_POLICY");
        return this.passwordPolicyLocalService.addPasswordPolicy(this.getUserId(), false, name, description, changeable, changeRequired, minAge, checkSyntax, allowDictionaryWords, minAlphanumeric, minLength, minLowerCase, minNumbers, minSymbols, minUpperCase, regex, history, historyCount, expireable, maxAge, warningTime, graceLimit, lockout, maxFailure, lockoutDuration, resetFailureCount, resetTicketMaxAge, serviceContext);
    }

    public void deletePasswordPolicy(long passwordPolicyId) throws PortalException {
        PasswordPolicyPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)passwordPolicyId, (String)"DELETE");
        this.passwordPolicyLocalService.deletePasswordPolicy(passwordPolicyId);
    }

    public PasswordPolicy fetchPasswordPolicy(long passwordPolicyId) throws PortalException {
        PasswordPolicy passwordPolicy = this.passwordPolicyLocalService.fetchPasswordPolicy(passwordPolicyId);
        if (passwordPolicy != null) {
            PasswordPolicyPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)passwordPolicyId, (String)"VIEW");
        }
        return passwordPolicy;
    }

    public List<PasswordPolicy> search(long companyId, String name, int start, int end, OrderByComparator<PasswordPolicy> orderByComparator) {
        return this.passwordPolicyFinder.filterFindByC_N(companyId, name, start, end, orderByComparator);
    }

    public int searchCount(long companyId, String name) {
        return this.passwordPolicyFinder.filterCountByC_N(companyId, name);
    }

    public PasswordPolicy updatePasswordPolicy(long passwordPolicyId, String name, String description, boolean changeable, boolean changeRequired, long minAge, boolean checkSyntax, boolean allowDictionaryWords, int minAlphanumeric, int minLength, int minLowerCase, int minNumbers, int minSymbols, int minUpperCase, String regex, boolean history, int historyCount, boolean expireable, long maxAge, long warningTime, int graceLimit, boolean lockout, int maxFailure, long lockoutDuration, long resetFailureCount, long resetTicketMaxAge, ServiceContext serviceContext) throws PortalException {
        PasswordPolicyPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)passwordPolicyId, (String)"UPDATE");
        return this.passwordPolicyLocalService.updatePasswordPolicy(passwordPolicyId, name, description, changeable, changeRequired, minAge, checkSyntax, allowDictionaryWords, minAlphanumeric, minLength, minLowerCase, minNumbers, minSymbols, minUpperCase, regex, history, historyCount, expireable, maxAge, warningTime, graceLimit, lockout, maxFailure, lockoutDuration, resetFailureCount, resetTicketMaxAge, serviceContext);
    }
}

