/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.RegionCodeException;
import com.liferay.portal.kernel.exception.RegionNameException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.base.RegionLocalServiceBaseImpl;
import java.util.List;

public class RegionLocalServiceImpl
extends RegionLocalServiceBaseImpl {
    public Region addRegion(long countryId, boolean active, String name, double position, String regionCode, ServiceContext serviceContext) throws PortalException {
        this.countryPersistence.findByPrimaryKey(countryId);
        this.validate(name, regionCode);
        long regionId = this.counterLocalService.increment();
        Region region = this.regionPersistence.create(regionId);
        region.setCompanyId(serviceContext.getCompanyId());
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        region.setUserId(user.getUserId());
        region.setUserName(user.getFullName());
        region.setCountryId(countryId);
        region.setActive(active);
        region.setName(name);
        region.setPosition(position);
        region.setRegionCode(regionCode);
        return (Region)this.regionPersistence.update((BaseModel)region);
    }

    public void deleteCountryRegions(long countryId) {
        this.regionPersistence.removeByCountryId(countryId);
    }

    @Override
    public Region deleteRegion(long regionId) throws PortalException {
        Region region = this.regionPersistence.findByPrimaryKey(regionId);
        return this.deleteRegion(region);
    }

    @Override
    public Region deleteRegion(Region region) throws PortalException {
        this.regionPersistence.remove((BaseModel)region);
        this.addressLocalService.deleteRegionAddresses(region.getRegionId());
        this._updateOrganizations(region.getRegionId());
        return region;
    }

    public Region fetchRegion(long countryId, String regionCode) {
        return this.regionPersistence.fetchByC_R(countryId, regionCode);
    }

    public Region getRegion(long countryId, String regionCode) throws PortalException {
        return this.regionPersistence.findByC_R(countryId, regionCode);
    }

    public List<Region> getRegions(long countryId, boolean active) throws PortalException {
        return this.regionPersistence.findByC_A(countryId, active);
    }

    public List<Region> getRegions(long countryId, boolean active, int start, int end, OrderByComparator<Region> orderByComparator) {
        return this.regionPersistence.findByC_A(countryId, active, start, end, orderByComparator);
    }

    public List<Region> getRegions(long countryId, int start, int end, OrderByComparator<Region> orderByComparator) {
        return this.regionPersistence.findByCountryId(countryId, start, end, orderByComparator);
    }

    public List<Region> getRegions(long companyId, String a2, boolean active) throws PortalException {
        Country country = this.countryPersistence.findByC_A2(companyId, a2);
        return this.regionPersistence.findByC_A(country.getCountryId(), active);
    }

    public int getRegionsCount(long countryId) {
        return this.regionPersistence.countByCountryId(countryId);
    }

    public int getRegionsCount(long countryId, boolean active) {
        return this.regionPersistence.countByC_A(countryId, active);
    }

    public Region updateActive(long regionId, boolean active) throws PortalException {
        Region region = this.regionPersistence.findByPrimaryKey(regionId);
        region.setActive(active);
        return (Region)this.regionPersistence.update((BaseModel)region);
    }

    public Region updateRegion(long regionId, boolean active, String name, double position, String regionCode) throws PortalException {
        Region region = this.regionPersistence.findByPrimaryKey(regionId);
        this.validate(name, regionCode);
        region.setActive(active);
        region.setName(name);
        region.setPosition(position);
        region.setRegionCode(regionCode);
        return (Region)this.regionPersistence.update((BaseModel)region);
    }

    protected void validate(String name, String regionCode) throws PortalException {
        if (Validator.isNull((String)regionCode)) {
            throw new RegionCodeException();
        }
        if (Validator.isNull((String)name)) {
            throw new RegionNameException();
        }
    }

    private void _updateOrganizations(long regionId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this.organizationLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property regionIdProperty = PropertyFactoryUtil.forName((String)"regionId");
            dynamicQuery.add(regionIdProperty.eq((Object)regionId));
        });
        actionableDynamicQuery.setPerformActionMethod(organization -> {
            organization.setRegionId(0L);
            this.organizationLocalService.updateOrganization(organization);
        });
        actionableDynamicQuery.performActions();
    }
}

