/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.ArgumentsResolver;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.NoSuchAccountException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Account;
import com.liferay.portal.kernel.model.AccountTable;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.AccountPersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.model.impl.AccountImpl;
import com.liferay.portal.model.impl.AccountModelImpl;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceRegistration;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class AccountPersistenceImpl
extends BasePersistenceImpl<Account>
implements AccountPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = AccountImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private static final String _SQL_SELECT_ACCOUNT = "SELECT account FROM Account account";
    private static final String _SQL_COUNT_ACCOUNT = "SELECT COUNT(account) FROM Account account";
    private static final String _ORDER_BY_ENTITY_ALIAS = "account.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Account exists with the primary key ";
    private static final Log _log = LogFactoryUtil.getLog(AccountPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"type", "size"});
    private ServiceRegistration<ArgumentsResolver> _argumentsResolverServiceRegistration;

    public AccountPersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("type", "type_");
        dbColumnNames.put("size", "size_");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(Account.class);
        this.setModelImplClass(AccountImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)AccountTable.INSTANCE);
    }

    public void cacheResult(Account account) {
        EntityCacheUtil.putResult(AccountImpl.class, (Serializable)Long.valueOf(account.getPrimaryKey()), (Serializable)account);
    }

    public void cacheResult(List<Account> accounts) {
        for (Account account : accounts) {
            if (EntityCacheUtil.getResult(AccountImpl.class, (Serializable)Long.valueOf(account.getPrimaryKey())) != null) continue;
            this.cacheResult(account);
        }
    }

    public void clearCache() {
        EntityCacheUtil.clearCache(AccountImpl.class);
        FinderCacheUtil.clearCache(AccountImpl.class);
    }

    public void clearCache(Account account) {
        EntityCacheUtil.removeResult(AccountImpl.class, (BaseModel)account);
    }

    public void clearCache(List<Account> accounts) {
        for (Account account : accounts) {
            EntityCacheUtil.removeResult(AccountImpl.class, (BaseModel)account);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        FinderCacheUtil.clearCache(AccountImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            EntityCacheUtil.removeResult(AccountImpl.class, (Serializable)primaryKey);
        }
    }

    public Account create(long accountId) {
        AccountImpl account = new AccountImpl();
        account.setNew(true);
        account.setPrimaryKey(accountId);
        account.setCompanyId(CompanyThreadLocal.getCompanyId());
        return account;
    }

    public Account remove(long accountId) throws NoSuchAccountException {
        return this.remove(Long.valueOf(accountId));
    }

    public Account remove(Serializable primaryKey) throws NoSuchAccountException {
        Session session = null;
        try {
            session = this.openSession();
            Account account = (Account)session.get(AccountImpl.class, primaryKey);
            if (account == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchAccountException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            Account account2 = (Account)this.remove((BaseModel)account);
            return account2;
        }
        catch (NoSuchAccountException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Account removeImpl(Account account) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)account)) {
                account = (Account)session.get(AccountImpl.class, account.getPrimaryKeyObj());
            }
            if (account != null) {
                session.delete((Object)account);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (account != null) {
            this.clearCache(account);
        }
        return account;
    }

    public Account updateImpl(Account account) {
        boolean isNew = account.isNew();
        if (!(account instanceof AccountModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(account.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)account);
                throw new IllegalArgumentException("Implement ModelWrapper in account proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom Account implementation " + account.getClass());
        }
        AccountModelImpl accountModelImpl = (AccountModelImpl)account;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && account.getCreateDate() == null) {
            if (serviceContext == null) {
                account.setCreateDate(date);
            } else {
                account.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!accountModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                account.setModifiedDate(date);
            } else {
                account.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)account);
            } else {
                account = (Account)session.merge((Object)account);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        EntityCacheUtil.putResult(AccountImpl.class, (BaseModel)account, (boolean)false, (boolean)true);
        if (isNew) {
            account.setNew(false);
        }
        account.resetOriginalValues();
        return account;
    }

    public Account findByPrimaryKey(Serializable primaryKey) throws NoSuchAccountException {
        Account account = (Account)this.fetchByPrimaryKey(primaryKey);
        if (account == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchAccountException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return account;
    }

    public Account findByPrimaryKey(long accountId) throws NoSuchAccountException {
        return this.findByPrimaryKey(Long.valueOf(accountId));
    }

    public Account fetchByPrimaryKey(long accountId) {
        return (Account)this.fetchByPrimaryKey(Long.valueOf(accountId));
    }

    public List<Account> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<Account> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<Account> findAll(int start, int end, OrderByComparator<Account> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<Account> findAll(int start, int end, OrderByComparator<Account> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)FinderCacheUtil.getResult((FinderPath)finderPath, finderArgs);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_ACCOUNT);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_ACCOUNT;
                sql = sql.concat(" ORDER BY account.accountId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (Account account : this.findAll()) {
            this.remove((BaseModel)account);
        }
    }

    public int countAll() {
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)this._finderPathCountAll, (Object[])FINDER_ARGS_EMPTY);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_ACCOUNT);
                count = (Long)query.uniqueResult();
                FinderCacheUtil.putResult((FinderPath)this._finderPathCountAll, (Object[])FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return EntityCacheUtil.getEntityCache();
    }

    protected String getPKDBName() {
        return "accountId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_ACCOUNT;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return AccountModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        Registry registry = RegistryUtil.getRegistry();
        this._argumentsResolverServiceRegistration = registry.registerService(ArgumentsResolver.class, (Object)new AccountModelArgumentsResolver());
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
    }

    public void destroy() {
        EntityCacheUtil.removeCache((String)AccountImpl.class.getName());
        this._argumentsResolverServiceRegistration.unregister();
    }

    protected FinderCache getFinderCache() {
        return FinderCacheUtil.getFinderCache();
    }

    private static class AccountModelArgumentsResolver
    implements ArgumentsResolver {
        private static final Map<FinderPath, Long> _finderPathColumnBitmasksCache = new ConcurrentHashMap<FinderPath, Long>();

        private AccountModelArgumentsResolver() {
        }

        public Object[] getArguments(FinderPath finderPath, BaseModel<?> baseModel, boolean checkColumn, boolean original) {
            String[] columnNames = finderPath.getColumnNames();
            if (columnNames == null || columnNames.length == 0) {
                if (baseModel.isNew()) {
                    return FINDER_ARGS_EMPTY;
                }
                return null;
            }
            AccountModelImpl accountModelImpl = (AccountModelImpl)baseModel;
            long columnBitmask = accountModelImpl.getColumnBitmask();
            if (!checkColumn || columnBitmask == 0L) {
                return AccountModelArgumentsResolver._getValue(accountModelImpl, columnNames, original);
            }
            Long finderPathColumnBitmask = _finderPathColumnBitmasksCache.get(finderPath);
            if (finderPathColumnBitmask == null) {
                finderPathColumnBitmask = 0L;
                for (String columnName : columnNames) {
                    finderPathColumnBitmask = finderPathColumnBitmask | AccountModelImpl.getColumnBitmask(columnName);
                }
                _finderPathColumnBitmasksCache.put(finderPath, finderPathColumnBitmask);
            }
            if ((columnBitmask & finderPathColumnBitmask) != 0L) {
                return AccountModelArgumentsResolver._getValue(accountModelImpl, columnNames, original);
            }
            return null;
        }

        public String getClassName() {
            return AccountImpl.class.getName();
        }

        public String getTableName() {
            return AccountTable.INSTANCE.getTableName();
        }

        private static Object[] _getValue(AccountModelImpl accountModelImpl, String[] columnNames, boolean original) {
            Object[] arguments = new Object[columnNames.length];
            for (int i = 0; i < arguments.length; ++i) {
                String columnName = columnNames[i];
                arguments[i] = original ? accountModelImpl.getColumnOriginalValue(columnName) : accountModelImpl.getColumnValue(columnName);
            }
            return arguments;
        }
    }
}

