/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.cache;

import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheHelperUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.util.servlet.filters.CacheResponseData;
import java.io.Serializable;

public class CacheUtil {
    public static final String CACHE_NAME = CacheUtil.class.getName();
    private static final PortalCache<String, CacheResponseData> _portalCache = PortalCacheHelperUtil.getPortalCache((String)"MULTI_VM_PORTAL_CACHE_MANAGER", (String)CACHE_NAME);

    public static void clearCache() {
        if (ExportImportThreadLocal.isImportInProcess()) {
            return;
        }
        _portalCache.removeAll();
    }

    public static void clearCache(long companyId) {
        CacheUtil.clearCache();
    }

    public static CacheResponseData getCacheResponseData(long companyId, String key) {
        if (Validator.isNull((String)key)) {
            return null;
        }
        key = CacheUtil._encodeKey(companyId, key);
        return (CacheResponseData)_portalCache.get((Serializable)((Object)key));
    }

    public static void putCacheResponseData(long companyId, String key, CacheResponseData data) {
        if (data != null) {
            key = CacheUtil._encodeKey(companyId, key);
            _portalCache.put((Serializable)((Object)key), (Object)data);
        }
    }

    private static String _encodeKey(long companyId, String key) {
        StringBundler sb = new StringBundler(5);
        sb.append(CACHE_NAME);
        sb.append("#");
        sb.append(StringUtil.toHexString((long)companyId));
        sb.append("#");
        sb.append(key);
        return sb.toString();
    }
}

