/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.sessionid;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.Validator;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class SessionIdServletRequest
extends HttpServletRequestWrapper {
    private static final String _JESSIONID = "JSESSIONID";
    private static final String _JESSIONID_ALREADY_SET = "JESSIONID_ALREADY_SET";
    private static final Log _log = LogFactoryUtil.getLog(SessionIdServletRequest.class);
    private final HttpServletResponse _httpServletResponse;

    public SessionIdServletRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        super(httpServletRequest);
        this._httpServletResponse = httpServletResponse;
    }

    public HttpSession getSession() {
        HttpSession session = super.getSession();
        this.process(session);
        return session;
    }

    public HttpSession getSession(boolean create) {
        HttpSession session = super.getSession(create);
        this.process(session);
        return session;
    }

    protected void process(HttpSession session) {
        if (session == null || !session.isNew() || !this.isSecure() || this.isRequestedSessionIdFromCookie()) {
            return;
        }
        Object jsessionIdAlreadySet = this.getAttribute(_JESSIONID_ALREADY_SET);
        if (jsessionIdAlreadySet != null) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Processing " + session.getId()));
        }
        Cookie cookie = new Cookie(_JESSIONID, session.getId());
        cookie.setMaxAge(-1);
        String contextPath = this.getContextPath();
        if (Validator.isNotNull((String)contextPath)) {
            cookie.setPath(contextPath);
        } else {
            cookie.setPath("/");
        }
        CookieKeys.addCookie((HttpServletRequest)((HttpServletRequest)super.getRequest()), (HttpServletResponse)this._httpServletResponse, (Cookie)cookie);
        this.setAttribute(_JESSIONID_ALREADY_SET, Boolean.TRUE);
    }
}

