/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.unsyncprintwriterpool;

import com.liferay.portal.kernel.servlet.TryFinallyFilter;
import com.liferay.portal.kernel.util.UnsyncPrintWriterPool;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UnsyncPrintWriterPoolFilter
extends BasePortalFilter
implements TryFinallyFilter {
    public void doFilterFinally(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object) {
        if (httpServletRequest.isAsyncSupported() && httpServletRequest.isAsyncStarted()) {
            AsyncContext asyncContext = httpServletRequest.getAsyncContext();
            asyncContext.addListener((AsyncListener)new UnsyncPrintWriterPoolFilterAsyncListener(asyncContext));
        } else {
            UnsyncPrintWriterPool.cleanUp();
        }
    }

    public Object doFilterTry(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        UnsyncPrintWriterPool.setEnabled((boolean)true);
        return null;
    }

    private static class UnsyncPrintWriterPoolFilterAsyncListener
    implements AsyncListener {
        private final AsyncContext _asyncContext;

        public void onComplete(AsyncEvent asyncEvent) {
            UnsyncPrintWriterPool.cleanUp();
        }

        public void onError(AsyncEvent asyncEvent) {
        }

        public void onStartAsync(AsyncEvent asyncEvent) {
            this._asyncContext.addListener((AsyncListener)this);
        }

        public void onTimeout(AsyncEvent asyncEvent) {
        }

        private UnsyncPrintWriterPoolFilterAsyncListener(AsyncContext asyncContext) {
            this._asyncContext = asyncContext;
        }
    }
}

