/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.hibernate;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.transaction.NewTransactionLifecycleListener;
import com.liferay.portal.kernel.transaction.TransactionAttribute;
import com.liferay.portal.kernel.transaction.TransactionLifecycleListener;
import com.liferay.portal.kernel.transaction.TransactionStatus;
import org.hibernate.Session;

public class LastSessionRecorderUtil {
    public static final TransactionLifecycleListener TRANSACTION_LIFECYCLE_LISTENER = new NewTransactionLifecycleListener(){

        protected void doCreated(TransactionAttribute transactionAttribute, TransactionStatus transactionStatus) {
            LastSessionRecorderUtil.syncLastSessionState();
        }
    };
    private static final ThreadLocal<Session> _lastSessionThreadLocal = new CentralizedThreadLocal(LastSessionRecorderUtil.class.getName() + "._lastSessionThreadLocal");

    public static void syncLastSessionState() {
        Session session = _lastSessionThreadLocal.get();
        if (session != null && session.isOpen()) {
            try {
                session.flush();
                session.clear();
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
        }
    }

    protected static void setLastSession(Session session) {
        _lastSessionThreadLocal.set(session);
    }
}

