/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalServiceUtil;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.events.StartupHelperUtil;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.cache.PortalCacheHelperUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.dependency.manager.DependencyManagerSyncUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.proxy.ProxyModeThreadLocal;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.service.ClassNameLocalServiceUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.version.Version;
import com.liferay.portal.module.framework.ModuleFrameworkUtil;
import com.liferay.portal.transaction.TransactionsUtil;
import com.liferay.portal.upgrade.PortalUpgradeProcess;
import com.liferay.portal.util.InitUtil;
import com.liferay.portal.util.PortalClassPathUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.verify.VerifyException;
import com.liferay.portal.verify.VerifyGroup;
import com.liferay.portal.verify.VerifyProperties;
import com.liferay.portal.verify.VerifyResourcePermissions;
import com.liferay.registry.Filter;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.dependency.ServiceDependencyListener;
import com.liferay.registry.dependency.ServiceDependencyManager;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import org.apache.commons.lang.time.StopWatch;
import org.apache.logging.log4j.core.Appender;
import org.springframework.context.ApplicationContext;

public class DBUpgrader {
    private static final Version _VERSION_7010 = new Version(0, 0, 6);
    private static final Log _log = LogFactoryUtil.getLog(DBUpgrader.class);
    private static volatile Appender _appender;
    private static volatile ServiceReference<Appender> _appenderServiceReference;

    public static void checkReleaseState() throws Exception {
        if (DBUpgrader._getReleaseColumnValue("state_") == 0) {
            return;
        }
        StringBundler sb = new StringBundler(6);
        sb.append("The database contains changes from a previous upgrade ");
        sb.append("attempt that failed. Please restore the old database and ");
        sb.append("file system and retry the upgrade. A patch may be ");
        sb.append("required if the upgrade failed due to a bug or an ");
        sb.append("unforeseen data permutation that resulted from a corrupt ");
        sb.append("database.");
        throw new IllegalStateException(sb.toString());
    }

    public static void checkRequiredBuildNumber(int requiredBuildNumber) throws Exception {
        int buildNumber = DBUpgrader._getReleaseColumnValue("buildNumber");
        if (buildNumber > ReleaseInfo.getParentBuildNumber()) {
            StringBundler sb = new StringBundler(6);
            sb.append("Attempting to deploy an older Liferay Portal version. ");
            sb.append("Current build number is ");
            sb.append(buildNumber);
            sb.append(" and attempting to deploy number ");
            sb.append(ReleaseInfo.getParentBuildNumber());
            sb.append(".");
            throw new IllegalStateException(sb.toString());
        }
        if (buildNumber < requiredBuildNumber) {
            String msg = "You must first upgrade to Liferay Portal " + requiredBuildNumber;
            System.out.println(msg);
            throw new RuntimeException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            PortalClassPathUtil.initializeClassPaths(null);
            InitUtil.initWithSpring(true, false);
            StartupHelperUtil.printPatchLevel();
            try (SafeCloseable safeCloseable = ProxyModeThreadLocal.setWithSafeCloseable((boolean)false);){
                if (PropsValues.UPGRADE_REPORT_ENABLED) {
                    DBUpgrader._startUpgradeReportLogAppender();
                }
                DBUpgrader.upgrade();
            }
            DBUpgrader._registerModuleServiceLifecycle("portlets.initialized");
            System.out.println("\nCompleted Liferay core upgrade process in " + stopWatch.getTime() / 1000L + " seconds");
            System.out.println("Running modules upgrades. Connect to Gogo shell to check the status.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        finally {
            if (PropsValues.UPGRADE_REPORT_ENABLED) {
                DBUpgrader._stopUpgradeReportLogAppender();
            }
        }
    }

    public static void upgrade() throws Exception {
        DBUpgrader.upgrade(null);
    }

    public static void upgrade(ApplicationContext applicationContext) throws Exception {
        StartupHelperUtil.setUpgrading(true);
        DBUpgrader._upgradePortal();
        DLFileEntryTypeLocalServiceUtil.getBasicDocumentDLFileEntryType();
        DBUpgrader._upgradeModules(applicationContext);
        DependencyManagerSyncUtil.sync();
    }

    public static void verify() throws VerifyException {
        VerifyProperties verifyProperties = new VerifyProperties();
        verifyProperties.verify();
        VerifyGroup verifyGroup = new VerifyGroup();
        verifyGroup.verify();
        VerifyResourcePermissions verifyResourcePermissions = new VerifyResourcePermissions();
        verifyResourcePermissions.verify();
    }

    private static void _checkClassNamesAndResourceActions() {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Check class names");
        }
        ClassNameLocalServiceUtil.checkClassNames();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Check resource actions");
        }
        StartupHelperUtil.initResourceActions();
    }

    private static int _getBuildNumberForMissedUpgradeProcesses(int buildNumber) throws Exception {
        if (buildNumber == 7010) {
            try (Connection connection = DataAccess.getConnection();){
                Version schemaVersion = PortalUpgradeProcess.getCurrentSchemaVersion(connection);
                if (!schemaVersion.equals((Object)_VERSION_7010)) {
                    int n = 7001;
                    return n;
                }
            }
        }
        return buildNumber;
    }

    /*
     * Loose catch block
     */
    private static int _getReleaseColumnValue(String columnName) throws Exception {
        Throwable throwable = null;
        try (Connection connection = DataAccess.getConnection();){
            Throwable throwable2;
            ResultSet resultSet;
            Throwable throwable3;
            PreparedStatement preparedStatement;
            block41: {
                int n;
                block44: {
                    block45: {
                        block42: {
                            block43: {
                                preparedStatement = connection.prepareStatement("select " + columnName + " from Release_ where releaseId = ?");
                                throwable3 = null;
                                preparedStatement.setLong(1, 1L);
                                resultSet = preparedStatement.executeQuery();
                                throwable2 = null;
                                if (!resultSet.next()) break block41;
                                n = resultSet.getInt(columnName);
                                if (resultSet == null) break block42;
                                if (throwable2 == null) break block43;
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                break block42;
                            }
                            resultSet.close();
                        }
                        if (preparedStatement == null) break block44;
                        if (throwable3 == null) break block45;
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable5) {
                            throwable3.addSuppressed(throwable5);
                        }
                        break block44;
                    }
                    preparedStatement.close();
                }
                return n;
            }
            try {
                try {
                    try {
                        block46: {
                            if (resultSet != null) {
                                if (throwable2 != null) {
                                    try {
                                        resultSet.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable2.addSuppressed(throwable6);
                                    }
                                } else {
                                    resultSet.close();
                                }
                            }
                            break block46;
                            {
                                catch (Throwable throwable7) {
                                    try {
                                        throwable2 = throwable7;
                                        throw throwable7;
                                    }
                                    catch (Throwable throwable8) {
                                        if (resultSet != null) {
                                            if (throwable2 != null) {
                                                try {
                                                    resultSet.close();
                                                }
                                                catch (Throwable throwable9) {
                                                    throwable2.addSuppressed(throwable9);
                                                }
                                            } else {
                                                resultSet.close();
                                            }
                                        }
                                        throw throwable8;
                                    }
                                }
                            }
                        }
                        throw new IllegalArgumentException("No Release exists with the primary key 1");
                    }
                    catch (Throwable throwable10) {
                        throwable3 = throwable10;
                        throw throwable10;
                    }
                }
                catch (Throwable throwable11) {
                    if (preparedStatement != null) {
                        if (throwable3 != null) {
                            try {
                                preparedStatement.close();
                            }
                            catch (Throwable throwable12) {
                                throwable3.addSuppressed(throwable12);
                            }
                        } else {
                            preparedStatement.close();
                        }
                    }
                    throw throwable11;
                }
            }
            catch (Throwable throwable13) {
                throwable = throwable13;
                throw throwable13;
            }
        }
    }

    private static void _registerModuleServiceLifecycle(String moduleServiceLifecycle) {
        Registry registry = RegistryUtil.getRegistry();
        registry.registerService(ModuleServiceLifecycle.class, (Object)new ModuleServiceLifecycle(){}, (Map)HashMapBuilder.put((Object)"module.service.lifecycle", (Object)moduleServiceLifecycle).put((Object)"service.vendor", (Object)ReleaseInfo.getVendor()).put((Object)"service.version", (Object)ReleaseInfo.getVersion()).build());
    }

    private static void _startUpgradeReportLogAppender() {
        final Registry registry = RegistryUtil.getRegistry();
        ServiceDependencyManager serviceDependencyManager = new ServiceDependencyManager();
        serviceDependencyManager.addServiceDependencyListener(new ServiceDependencyListener(){

            public void dependenciesFulfilled() {
                _appenderServiceReference = registry.getServiceReference(Appender.class);
                ServiceReference appenderServiceReference = _appenderServiceReference;
                _appender = (Appender)registry.getService(appenderServiceReference);
                _appender.start();
            }

            public void destroy() {
            }
        });
        serviceDependencyManager.registerDependencies(new Filter[]{registry.getFilter(StringBundler.concat((String[])new String[]{"(&(appender.name=UpgradeReportLogAppender)(objectClass=", Appender.class.getName(), "))"}))});
    }

    private static void _stopUpgradeReportLogAppender() {
        if (_appender != null) {
            _appender.stop();
        }
        if (_appenderServiceReference != null) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(_appenderServiceReference);
        }
    }

    private static void _updateCompanyKey() throws Exception {
        DB db = DBManagerUtil.getDB();
        db.runSQL("update CompanyInfo set key_ = null");
    }

    private static void _updateReleaseBuildInfo() throws Exception {
        try (Connection connection = DataAccess.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("update Release_ set buildNumber = ?, buildDate = ? where releaseId = ?");){
            preparedStatement.setInt(1, ReleaseInfo.getParentBuildNumber());
            java.util.Date buildDate = ReleaseInfo.getBuildDate();
            preparedStatement.setDate(2, new Date(buildDate.getTime()));
            preparedStatement.setLong(3, 1L);
            preparedStatement.executeUpdate();
        }
    }

    private static void _updateReleaseState(int state) throws Exception {
        try (Connection connection = DataAccess.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("update Release_ set modifiedDate = ?, state_ = ? where releaseId = ?");){
            preparedStatement.setDate(1, new Date(System.currentTimeMillis()));
            preparedStatement.setInt(2, state);
            preparedStatement.setLong(3, 1L);
            preparedStatement.executeUpdate();
        }
    }

    private static void _upgradeModules(ApplicationContext applicationContext) {
        DBUpgrader._registerModuleServiceLifecycle("database.initialized");
        if (applicationContext == null) {
            InitUtil.registerContext();
        } else {
            ModuleFrameworkUtil.registerContext(applicationContext);
        }
        DBUpgrader._registerModuleServiceLifecycle("portal.initialized");
        PortalCacheHelperUtil.clearPortalCaches((String)"MULTI_VM_PORTAL_CACHE_MANAGER");
    }

    private static void _upgradePortal() throws Exception {
        DBUpgrader.checkRequiredBuildNumber(6200);
        DBUpgrader.checkReleaseState();
        int buildNumber = DBUpgrader._getReleaseColumnValue("buildNumber");
        try (Connection connection = DataAccess.getConnection();){
            if (PortalUpgradeProcess.isInLatestSchemaVersion(connection) && buildNumber == ReleaseInfo.getParentBuildNumber()) {
                DBUpgrader._checkClassNamesAndResourceActions();
                return;
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Disable cache registry");
        }
        CacheRegistryUtil.setActive((boolean)false);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Update build " + buildNumber));
        }
        if (PropsValues.UPGRADE_DATABASE_TRANSACTIONS_DISABLED) {
            TransactionsUtil.disableTransactions();
        }
        try {
            buildNumber = DBUpgrader._getBuildNumberForMissedUpgradeProcesses(buildNumber);
            StartupHelperUtil.upgradeProcess(buildNumber);
        }
        catch (Exception exception) {
            DBUpgrader._updateReleaseState(1);
            throw exception;
        }
        finally {
            if (PropsValues.UPGRADE_DATABASE_TRANSACTIONS_DISABLED) {
                TransactionsUtil.enableTransactions();
            }
        }
        StartupHelperUtil.updateIndexes(true);
        DBUpgrader._updateReleaseBuildInfo();
        CustomSQLUtil.reloadCustomSQL();
        SQLTransformer.reloadSQLTransformer();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Update company key");
        }
        DBUpgrader._updateCompanyKey();
        PortalCacheHelperUtil.clearPortalCaches((String)"MULTI_VM_PORTAL_CACHE_MANAGER");
        CacheRegistryUtil.setActive((boolean)true);
        DBUpgrader._checkClassNamesAndResourceActions();
        DBUpgrader.verify();
    }
}

