/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.db.DBManagerImpl;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.portal.tools.ToolDependencies;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.List;
import java.util.Map;

public class HypersonicLoader {
    public static void loadHypersonic(Connection connection, String fileName) throws Exception {
        DBManagerImpl dbManager = new DBManagerImpl();
        DB db = dbManager.getDB(DBType.HYPERSONIC, null);
        List<String> lines = Files.readAllLines(Paths.get(fileName, new String[0]), StandardCharsets.UTF_8);
        StringBundler sb = new StringBundler(lines.size() * 2);
        for (String line : lines) {
            if (line.isEmpty() || line.startsWith("//")) continue;
            sb.append(line);
            sb.append("\n");
        }
        db.runSQLTemplateString(connection, sb.toString(), true);
    }

    public static void main(String[] args) throws Exception {
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        String databaseName = arguments.get("db.database.name");
        String sqlDir = arguments.get("db.sql.dir");
        String fileNames = arguments.get("db.file.names");
        String username = arguments.get("db.database.username");
        String password = arguments.get("db.database.password");
        try {
            new HypersonicLoader(databaseName, sqlDir, fileNames, username, password);
        }
        catch (Exception exception) {
            ArgumentsUtil.processMainException(arguments, exception);
        }
    }

    @Deprecated
    public HypersonicLoader(String databaseName, String sqlDir, String fileNames) {
        throw new UnsupportedOperationException();
    }

    public HypersonicLoader(String databaseName, String sqlDir, String fileNames, String userName, String password) throws Exception {
        ToolDependencies.wireBasic();
        DBManagerUtil.setDB((DBType)DBType.HYPERSONIC, null);
        try (Connection connection = DriverManager.getConnection(StringBundler.concat((String[])new String[]{"jdbc:hsqldb:", sqlDir, "/", databaseName, ";hsqldb.write_delay=false;shutdown=true"}), userName, password);){
            if (Validator.isNull((String)fileNames)) {
                HypersonicLoader.loadHypersonic(connection, sqlDir + "/portal/portal-hypersonic.sql");
                HypersonicLoader.loadHypersonic(connection, sqlDir + "/indexes.sql");
            } else {
                for (String fileName : StringUtil.split((String)fileNames)) {
                    HypersonicLoader.loadHypersonic(connection, sqlDir + "/" + fileName);
                }
            }
            try (Statement statement = connection.createStatement();){
                statement.execute("SHUTDOWN COMPACT");
            }
        }
    }
}

