/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_6;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeResourceAction
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(UpgradeResourceAction.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void deleteDuplicateBitwiseValuesOnResource() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement1 = this.connection.prepareStatement("select name, bitwiseValue, min(resourceActionId) as minResourceActionId from ResourceAction group by name, bitwiseValue having count(resourceActionId) > 1");
             PreparedStatement preparedStatement2 = this.connection.prepareStatement("select resourceActionId, actionId from ResourceAction where name = ? and bitwiseValue = ? and resourceActionId != ?");
             ResultSet resultSet1 = preparedStatement1.executeQuery();){
            while (resultSet1.next()) {
                ResultSet resultSet2;
                block70: {
                    String name = resultSet1.getString("name");
                    long bitwiseValue = resultSet1.getLong("bitwiseValue");
                    long minResourceActionId = resultSet1.getLong("minResourceActionId");
                    preparedStatement2.setString(1, name);
                    preparedStatement2.setLong(2, bitwiseValue);
                    preparedStatement2.setLong(3, minResourceActionId);
                    resultSet2 = preparedStatement2.executeQuery();
                    Throwable throwable = null;
                    try {
                        while (resultSet2.next()) {
                            PreparedStatement preparedStatement3;
                            block69: {
                                if (_log.isInfoEnabled()) {
                                    StringBundler sb = new StringBundler(7);
                                    sb.append("Deleting resource action ");
                                    sb.append(resultSet2.getString("actionId"));
                                    sb.append(" from resource ");
                                    sb.append(name);
                                    sb.append(" because its bitwise value is the ");
                                    sb.append("same as another resource action on ");
                                    sb.append("the same resource");
                                    _log.info((Object)sb.toString());
                                }
                                preparedStatement3 = this.connection.prepareStatement(StringBundler.concat((Object[])new Object[]{"delete from ResourceAction where ", "resourceActionId = ", resultSet2.getLong("resourceActionId")}));
                                Throwable throwable2 = null;
                                try {
                                    preparedStatement3.execute();
                                    if (preparedStatement3 == null) continue;
                                    if (throwable2 == null) break block69;
                                }
                                catch (Throwable throwable3) {
                                    try {
                                        throwable2 = throwable3;
                                        throw throwable3;
                                    }
                                    catch (Throwable throwable4) {
                                        if (preparedStatement3 == null) throw throwable4;
                                        if (throwable2 == null) {
                                            preparedStatement3.close();
                                            throw throwable4;
                                        }
                                        try {
                                            preparedStatement3.close();
                                            throw throwable4;
                                        }
                                        catch (Throwable throwable5) {
                                            throwable2.addSuppressed(throwable5);
                                            throw throwable4;
                                        }
                                    }
                                }
                                try {
                                    preparedStatement3.close();
                                    continue;
                                }
                                catch (Throwable throwable6) {
                                    throwable2.addSuppressed(throwable6);
                                    continue;
                                }
                            }
                            preparedStatement3.close();
                        }
                        if (resultSet2 == null) continue;
                        if (throwable == null) break block70;
                    }
                    catch (Throwable throwable7) {
                        try {
                            throwable = throwable7;
                            throw throwable7;
                        }
                        catch (Throwable throwable8) {
                            if (resultSet2 == null) throw throwable8;
                            if (throwable != null) {
                                try {
                                    resultSet2.close();
                                    throw throwable8;
                                }
                                catch (Throwable throwable9) {
                                    throwable.addSuppressed(throwable9);
                                    throw throwable8;
                                }
                            }
                            resultSet2.close();
                            throw throwable8;
                        }
                    }
                    try {
                        resultSet2.close();
                        continue;
                    }
                    catch (Throwable throwable10) {
                        throwable.addSuppressed(throwable10);
                        continue;
                    }
                }
                resultSet2.close();
            }
            return;
        }
    }

    protected void doUpgrade() throws Exception {
        this.deleteDuplicateBitwiseValuesOnResource();
    }
}

