/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_4_x;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.upgrade.BaseCompanyIdUpgradeProcess;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class UpgradeCompanyId
extends BaseCompanyIdUpgradeProcess {
    protected void doUpgrade() throws Exception {
        for (BaseCompanyIdUpgradeProcess.TableUpdater tableUpdater : this.getTableUpdaters()) {
            if (!this.hasColumn(tableUpdater.getTableName(), "companyId")) {
                tableUpdater.setCreateCompanyIdColumn(true);
            }
            tableUpdater.call();
        }
    }

    protected BaseCompanyIdUpgradeProcess.TableUpdater[] getTableUpdaters() {
        return new BaseCompanyIdUpgradeProcess.TableUpdater[]{new PortalPreferencesTableUpdater("PortalPreferences"), new BaseCompanyIdUpgradeProcess.TableUpdater((BaseCompanyIdUpgradeProcess)this, "PortalPreferenceValue", "PortalPreferences", "portalPreferencesId")};
    }

    private class PortalPreferencesTableUpdater
    extends BaseCompanyIdUpgradeProcess.TableUpdater {
        public PortalPreferencesTableUpdater(String tableName) {
            super((BaseCompanyIdUpgradeProcess)UpgradeCompanyId.this, tableName, "", "");
        }

        public void update(Connection connection) throws IOException, SQLException {
            List companyIds = this.getCompanyIds(connection);
            if (companyIds.size() == 1) {
                String selectSQL = String.valueOf(companyIds.get(0));
                UpgradeCompanyId.this.runSQL(connection, this.getUpdateSQL(selectSQL));
                return;
            }
            String updateSQL = this._getUpdateSQL("Company", "companyId", "ownerId", 1);
            UpgradeCompanyId.this.runSQL(connection, updateSQL);
            updateSQL = this._getUpdateSQL("Group_", "groupId", "ownerId", 2);
            UpgradeCompanyId.this.runSQL(connection, updateSQL);
            updateSQL = this._getUpdateSQL("Layout", "plid", "ownerId", 3);
            UpgradeCompanyId.this.runSQL(connection, updateSQL);
            updateSQL = this._getUpdateSQL("LayoutRevision", "layoutRevisionId", "ownerId", 3);
            UpgradeCompanyId.this.runSQL(connection, updateSQL);
            updateSQL = this._getUpdateSQL("Organization_", "organizationId", "ownerId", 6);
            UpgradeCompanyId.this.runSQL(connection, updateSQL);
            updateSQL = this._getUpdateSQL("PortletItem", "portletItemId", "ownerId", 5);
            UpgradeCompanyId.this.runSQL(connection, updateSQL);
            updateSQL = this._getUpdateSQL("User_", "userId", "ownerId", 4);
            UpgradeCompanyId.this.runSQL(connection, updateSQL);
            UpgradeCompanyId.this.runSQL(connection, "update PortalPreferences set companyId = 0 where ownerId = 0");
        }

        private String _getSelectSQL(String foreignTableName, String foreignColumnName, String columnName) throws SQLException {
            ArrayList<Long> companyIds = new ArrayList<Long>();
            try (PreparedStatement preparedStatement = UpgradeCompanyId.this.connection.prepareStatement("select distinct companyId from " + foreignTableName);
                 ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    long companyId = resultSet.getLong(1);
                    companyIds.add(companyId);
                }
            }
            if (companyIds.size() == 1) {
                return String.valueOf(companyIds.get(0));
            }
            StringBundler sb = new StringBundler(10);
            sb.append("select companyId from ");
            sb.append(foreignTableName);
            sb.append(" where ");
            sb.append(foreignTableName);
            sb.append(".");
            sb.append(foreignColumnName);
            sb.append(" = ");
            sb.append(this.getTableName());
            sb.append(".");
            sb.append(columnName);
            return sb.toString();
        }

        private String _getUpdateSQL(String foreignTableName, String foreignColumnName, String columnName, int ownerType) throws IOException, SQLException {
            String selectSQL = this._getSelectSQL(foreignTableName, foreignColumnName, columnName);
            StringBundler sb = new StringBundler(4);
            sb.append(this.getUpdateSQL(selectSQL));
            sb.append(" where ownerType = ");
            sb.append(ownerType);
            sb.append(" and (companyId is null or companyId = 0)");
            return sb.toString();
        }
    }
}

