/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_4_x;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.model.PortalPreferenceValue;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.upgrade.v7_4_x.util.PortalPreferencesTable;
import com.liferay.portlet.PortletPreferencesFactoryImpl;
import com.liferay.portlet.Preference;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;

public class UpgradePortalPreferences
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.runSQL(StringBundler.concat((String[])new String[]{"create table PortalPreferenceValue (mvccVersion LONG default ", "0 not null, portalPreferenceValueId LONG not null primary ", "key, portalPreferencesId LONG, index_ INTEGER, key_ ", "VARCHAR(255) null, largeValue TEXT null, namespace ", "VARCHAR(255) null, smallValue VARCHAR(255) null)"}));
        try (PreparedStatement selectPreparedStatement = this.connection.prepareStatement(SQLTransformer.transform(StringBundler.concat((String[])new String[]{"select portalPreferencesId, preferences from ", "PortalPreferences where ", "CAST_CLOB_TEXT(preferences) != '", "<portlet-preferences />", "' and preferences is not null"})));
             PreparedStatement insertPreparedStatement = AutoBatchPreparedStatementUtil.autoBatch((PreparedStatement)this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"insert into PortalPreferenceValue (mvccVersion, ", "portalPreferenceValueId, portalPreferencesId, ", "index_, key_, largeValue, namespace, smallValue) ", "values (0, ?, ?, ?, ?, ?, ?, ?)"})));
             ResultSet resultSet = selectPreparedStatement.executeQuery();){
            while (resultSet.next()) {
                Map<String, Preference> preferenceMap;
                String preferences = resultSet.getString("preferences");
                if (preferences.isEmpty() || (preferenceMap = PortletPreferencesFactoryImpl.createPreferencesMap(preferences)).isEmpty()) continue;
                long portalPreferencesId = resultSet.getLong("portalPreferencesId");
                for (Preference preference : preferenceMap.values()) {
                    String namespace = null;
                    String key = preference.getName();
                    int index = key.indexOf(35);
                    if (index > 0) {
                        namespace = key.substring(0, index);
                        key = key.substring(index + 1);
                    }
                    String[] values = preference.getValues();
                    for (int i = 0; i < values.length; ++i) {
                        String value = values[i];
                        String largeValue = null;
                        String smallValue = null;
                        if (value.length() > 255) {
                            largeValue = value;
                        } else {
                            smallValue = value;
                        }
                        insertPreparedStatement.setLong(1, this.increment(PortalPreferenceValue.class.getName()));
                        insertPreparedStatement.setLong(2, portalPreferencesId);
                        insertPreparedStatement.setInt(3, i);
                        insertPreparedStatement.setString(4, key);
                        insertPreparedStatement.setString(5, largeValue);
                        insertPreparedStatement.setString(6, namespace);
                        insertPreparedStatement.setString(7, smallValue);
                        insertPreparedStatement.addBatch();
                    }
                }
            }
            insertPreparedStatement.executeBatch();
        }
        this.alter(PortalPreferencesTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableDropColumn((UpgradeProcess)this, "preferences")});
    }
}

