/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourceLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.upgrade.BaseUpgradeCallable;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.verify.model.VerifiableResourcedModel;
import com.liferay.portal.verify.VerifyProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@Deprecated
public class VerifyResourcePermissions
extends VerifyProcess {
    private static final Log _log = LogFactoryUtil.getLog(VerifyResourcePermissions.class);

    public void verify(VerifiableResourcedModel ... verifiableResourcedModels) throws Exception {
        CompanyLocalServiceUtil.forEachCompanyId(companyId -> {
            Role role = RoleLocalServiceUtil.getRole((long)companyId, (String)"Owner");
            ArrayList<VerifyResourcedModelUpgradeCallable> verifyResourcedModelUpgradeCallables = new ArrayList<VerifyResourcedModelUpgradeCallable>(verifiableResourcedModels.length);
            for (VerifiableResourcedModel verifiableResourcedModel : verifiableResourcedModels) {
                VerifyResourcedModelUpgradeCallable verifyResourcedModelUpgradeCallable = new VerifyResourcedModelUpgradeCallable(role, verifiableResourcedModel);
                verifyResourcedModelUpgradeCallables.add(verifyResourcedModelUpgradeCallable);
            }
            this.doVerify(verifyResourcedModelUpgradeCallables);
        });
    }

    @Override
    protected void doVerify() throws Exception {
        Map verifiableResourcedModelsMap = PortalBeanLocatorUtil.locate(VerifiableResourcedModel.class);
        Collection verifiableResourcedModels = verifiableResourcedModelsMap.values();
        this.verify(verifiableResourcedModels.toArray(new VerifiableResourcedModel[0]));
    }

    private String _getVerifyResourcedModelSQL(boolean count, VerifiableResourcedModel verifiableResourcedModel, Role role) {
        StringBundler sb = new StringBundler(28);
        sb.append("select ");
        if (count) {
            sb.append("count(*)");
        } else {
            sb.append(verifiableResourcedModel.getTableName());
            sb.append(".");
            sb.append(verifiableResourcedModel.getPrimaryKeyColumnName());
            sb.append(", ");
            sb.append(verifiableResourcedModel.getTableName());
            sb.append(".");
            sb.append(verifiableResourcedModel.getUserIdColumnName());
        }
        sb.append(" from ");
        sb.append(verifiableResourcedModel.getTableName());
        sb.append(" left join ResourcePermission on (ResourcePermission.");
        sb.append("companyId = ");
        sb.append(role.getCompanyId());
        sb.append(" and ResourcePermission.name = '");
        sb.append(verifiableResourcedModel.getModelName());
        sb.append("' and ResourcePermission.scope = ");
        sb.append(4);
        sb.append(" and ResourcePermission.primKeyId = ");
        sb.append(verifiableResourcedModel.getTableName());
        sb.append(".");
        sb.append(verifiableResourcedModel.getPrimaryKeyColumnName());
        sb.append(" and ResourcePermission.roleId = ");
        sb.append(role.getRoleId());
        sb.append(") where ");
        sb.append(verifiableResourcedModel.getTableName());
        sb.append(".companyId = ");
        sb.append(role.getCompanyId());
        sb.append(" and ResourcePermission.primKeyId is NULL");
        return SQLTransformer.transform(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _verifyResourcedModel(Role role, VerifiableResourcedModel verifiableResourcedModel) throws Exception {
        Throwable throwable;
        Throwable throwable2;
        Throwable throwable3;
        Connection connection;
        int total = 0;
        try (LoggingTimer loggingTimer = new LoggingTimer(verifiableResourcedModel.getTableName());){
            connection = DataAccess.getConnection();
            throwable3 = null;
            try {
                throwable2 = null;
                try (PreparedStatement preparedStatement2 = connection.prepareStatement(this._getVerifyResourcedModelSQL(true, verifiableResourcedModel, role));){
                    throwable = null;
                    try (ResultSet resultSet2 = preparedStatement2.executeQuery();){
                        if (resultSet2.next()) {
                            total = resultSet2.getInt(1);
                        }
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                }
                catch (Throwable resultSet2) {
                    throwable2 = resultSet2;
                    throw resultSet2;
                }
            }
            catch (Throwable preparedStatement2) {
                throwable3 = preparedStatement2;
                throw preparedStatement2;
            }
            finally {
                if (connection != null) {
                    if (throwable3 != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable preparedStatement2) {
                            throwable3.addSuppressed(preparedStatement2);
                        }
                    } else {
                        connection.close();
                    }
                }
            }
        }
        if (total == 0) {
            return;
        }
        loggingTimer = new LoggingTimer(verifiableResourcedModel.getTableName());
        var5_5 = null;
        try {
            connection = DataAccess.getConnection();
            throwable3 = null;
            try {
                throwable2 = null;
                try (PreparedStatement preparedStatement = connection.prepareStatement(this._getVerifyResourcedModelSQL(false, verifiableResourcedModel, role));){
                    throwable = null;
                    try (ResultSet resultSet = preparedStatement.executeQuery();){
                        ArrayList futures = new ArrayList(total);
                        ExecutorService executorService = Executors.newWorkStealingPool();
                        try {
                            int i = 1;
                            while (resultSet.next()) {
                                long l = resultSet.getLong(verifiableResourcedModel.getPrimaryKeyColumnName());
                                long userId = resultSet.getLong(verifiableResourcedModel.getUserIdColumnName());
                                futures.add(executorService.submit(new AddResourcesUpgradeCallable(role.getCompanyId(), verifiableResourcedModel.getModelName(), l, role.getRoleId(), userId, i, total)));
                                ++i;
                            }
                            for (Future future : futures) {
                                future.get();
                            }
                        }
                        finally {
                            executorService.shutdown();
                        }
                    }
                    catch (Throwable throwable6) {
                        throwable = throwable6;
                        throw throwable6;
                    }
                }
                catch (Throwable throwable8) {
                    throwable2 = throwable8;
                    throw throwable8;
                }
            }
            catch (Throwable throwable10) {
                throwable3 = throwable10;
                throw throwable10;
            }
            finally {
                if (connection != null) {
                    if (throwable3 != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable11) {
                            throwable3.addSuppressed(throwable11);
                        }
                    } else {
                        connection.close();
                    }
                }
            }
        }
        catch (Throwable throwable12) {
            var5_5 = throwable12;
            throw throwable12;
        }
        finally {
            if (loggingTimer != null) {
                if (var5_5 != null) {
                    try {
                        loggingTimer.close();
                    }
                    catch (Throwable throwable13) {
                        var5_5.addSuppressed(throwable13);
                    }
                } else {
                    loggingTimer.close();
                }
            }
        }
    }

    private class VerifyResourcedModelUpgradeCallable
    extends BaseUpgradeCallable<Void> {
        private final Role _role;
        private final VerifiableResourcedModel _verifiableResourcedModel;

        protected Void doCall() throws Exception {
            VerifyResourcePermissions.this._verifyResourcedModel(this._role, this._verifiableResourcedModel);
            return null;
        }

        private VerifyResourcedModelUpgradeCallable(Role role, VerifiableResourcedModel verifiableResourcedModel) {
            this._role = role;
            this._verifiableResourcedModel = verifiableResourcedModel;
        }
    }

    private class AddResourcesUpgradeCallable
    extends BaseUpgradeCallable<Void> {
        private final long _companyId;
        private final long _cur;
        private final String _modelName;
        private final long _ownerId;
        private final long _primKey;
        private final long _roleId;
        private final long _total;

        protected Void doCall() throws Exception {
            if (_log.isInfoEnabled() && this._cur % 100L == 0L) {
                _log.info((Object)StringBundler.concat((Object[])new Object[]{"Processed ", this._cur, " of ", this._total, " resource permissions for company ", this._companyId, " and model ", this._modelName}));
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"No resource found for {", this._companyId, ", ", this._modelName, ", ", 4, ", ", this._primKey, ", ", this._roleId, "}"}));
            }
            try {
                ResourceLocalServiceUtil.addResources((long)this._companyId, (long)0L, (long)this._ownerId, (String)this._modelName, (String)String.valueOf(this._primKey), (boolean)false, (boolean)false, (boolean)false);
            }
            catch (Exception exception) {
                _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to add resource for {", this._companyId, ", ", this._modelName, ", ", 4, ", ", this._primKey, ", ", this._roleId, "}"}), (Throwable)exception);
            }
            return null;
        }

        private AddResourcesUpgradeCallable(long companyId, String modelName, long primKey, long roleId, long ownerId, int cur, int total) {
            this._companyId = companyId;
            this._modelName = modelName;
            this._primKey = primKey;
            this._roleId = roleId;
            this._ownerId = ownerId;
            this._cur = cur;
            this._total = total;
        }
    }
}

