/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.action;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryServiceUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.struts.JSONAction;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GetCategoriesAction
extends JSONAction {
    @Override
    public String getJSON(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        List<AssetCategory> categories = this.getCategories(httpServletRequest);
        for (AssetCategory category : categories) {
            List childCategories = AssetCategoryServiceUtil.getChildCategories((long)category.getCategoryId());
            jsonArray.put(JSONUtil.put((String)"categoryId", (Object)category.getCategoryId()).put("childrenCount", childCategories.size()).put("hasChildren", !childCategories.isEmpty()).put("name", category.getName()).put("parentCategoryId", category.getParentCategoryId()).put("titleCurrentValue", category.getTitleCurrentValue()));
        }
        return jsonArray.toString();
    }

    protected List<AssetCategory> getCategories(HttpServletRequest httpServletRequest) throws Exception {
        long scopeGroupId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"scopeGroupId");
        long categoryId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"categoryId");
        long vocabularyId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"vocabularyId");
        int start = ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)"start", (int)-1);
        int end = ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)"end", (int)-1);
        List categories = Collections.emptyList();
        if (categoryId > 0L) {
            categories = scopeGroupId > 0L ? AssetCategoryServiceUtil.getVocabularyCategories((long)scopeGroupId, (long)categoryId, (long)vocabularyId, (int)start, (int)end, null) : AssetCategoryServiceUtil.getChildCategories((long)categoryId, (int)start, (int)end, null);
        } else if (vocabularyId > 0L) {
            long parentCategoryId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"parentCategoryId", (long)0L);
            categories = scopeGroupId > 0L ? AssetCategoryServiceUtil.getVocabularyCategories((long)scopeGroupId, (long)parentCategoryId, (long)vocabularyId, (int)start, (int)end, null) : AssetCategoryServiceUtil.getVocabularyCategories((long)parentCategoryId, (long)vocabularyId, (int)start, (int)end, null);
        }
        return categories;
    }
}

