/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.asset.kernel.exception.NoSuchLinkException;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetLink;
import com.liferay.asset.kernel.model.AssetLinkConstants;
import com.liferay.asset.kernel.model.adapter.StagedAssetLink;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.adapter.ModelAdapterUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portlet.asset.service.base.AssetLinkLocalServiceBaseImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class AssetLinkLocalServiceImpl
extends AssetLinkLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(AssetLinkLocalServiceImpl.class);

    public AssetLink addLink(long userId, long entryId1, long entryId2, int type, int weight) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        Date date = new Date();
        long linkId1 = this.counterLocalService.increment();
        AssetLink link1 = this.assetLinkPersistence.create(linkId1);
        link1.setCompanyId(user.getCompanyId());
        link1.setUserId(user.getUserId());
        link1.setUserName(user.getFullName());
        link1.setCreateDate(date);
        link1.setEntryId1(entryId1);
        link1.setEntryId2(entryId2);
        link1.setType(type);
        link1.setWeight(weight);
        link1 = (AssetLink)this.assetLinkPersistence.update((BaseModel)link1);
        if (AssetLinkConstants.isTypeBi((int)type)) {
            long linkId2 = this.counterLocalService.increment();
            AssetLink link2 = this.assetLinkPersistence.create(linkId2);
            link2.setCompanyId(user.getCompanyId());
            link2.setUserId(user.getUserId());
            link2.setUserName(user.getFullName());
            link2.setCreateDate(date);
            link2.setEntryId1(entryId2);
            link2.setEntryId2(entryId1);
            link2.setType(type);
            link2.setWeight(weight);
            this.assetLinkPersistence.update((BaseModel)link2);
        }
        return link1;
    }

    @Override
    public AssetLink deleteAssetLink(AssetLink assetLink) {
        AssetLink deletedAssetLink = super.deleteAssetLink(assetLink);
        this.addDeletionSystemEvent(assetLink);
        return deletedAssetLink;
    }

    @Override
    public AssetLink deleteAssetLink(long linkId) throws PortalException {
        AssetLink assetLink = super.deleteAssetLink(linkId);
        this.addDeletionSystemEvent(assetLink);
        return assetLink;
    }

    public void deleteGroupLinks(long groupId) {
        List assetLinks = this.assetLinkFinder.findByAssetEntryGroupId(groupId, -1, -1);
        for (AssetLink assetLink : assetLinks) {
            this.deleteAssetLink(assetLink);
        }
    }

    public void deleteLink(AssetLink link) {
        block3: {
            if (AssetLinkConstants.isTypeBi((int)link.getType())) {
                try {
                    AssetLink assetLink = this.assetLinkPersistence.findByE_E_T(link.getEntryId2(), link.getEntryId1(), link.getType());
                    this.deleteAssetLink(assetLink);
                }
                catch (NoSuchLinkException noSuchLinkException) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn((Object)"Unable to delete asset link", (Throwable)noSuchLinkException);
                }
            }
        }
        this.assetLinkPersistence.remove((BaseModel)link);
        this.addDeletionSystemEvent(link);
    }

    public void deleteLink(long linkId) throws PortalException {
        AssetLink link = this.assetLinkPersistence.findByPrimaryKey(linkId);
        this.deleteLink(link);
    }

    public void deleteLinks(long entryId) {
        for (AssetLink link : this.assetLinkPersistence.findByE1(entryId)) {
            this.deleteLink(link);
        }
        for (AssetLink link : this.assetLinkPersistence.findByE2(entryId)) {
            this.deleteLink(link);
        }
    }

    public void deleteLinks(long entryId1, long entryId2) {
        List links = this.assetLinkPersistence.findByE_E(entryId1, entryId2);
        for (AssetLink link : links) {
            this.deleteLink(link);
        }
    }

    public List<AssetLink> getDirectLinks(long entryId) {
        return this.getDirectLinks(entryId, true);
    }

    public List<AssetLink> getDirectLinks(long entryId, boolean excludeInvisibleLinks) {
        List assetLinks = this.assetLinkPersistence.findByE1(entryId);
        return this.filterAssetLinks(assetLinks, excludeInvisibleLinks);
    }

    public List<AssetLink> getDirectLinks(long entryId, int typeId) {
        return this.getDirectLinks(entryId, typeId, true);
    }

    public List<AssetLink> getDirectLinks(long entryId, int typeId, boolean excludeInvisibleLinks) {
        List assetLinks = this.assetLinkPersistence.findByE1_T(entryId, typeId);
        return this.filterAssetLinks(assetLinks, excludeInvisibleLinks);
    }

    public List<AssetLink> getLinks(long entryId) {
        List e1Links = this.assetLinkPersistence.findByE1(entryId);
        List e2Links = this.assetLinkPersistence.findByE2(entryId);
        ArrayList<AssetLink> links = new ArrayList<AssetLink>(e1Links.size() + e2Links.size());
        links.addAll(e1Links);
        links.addAll(e2Links);
        return links;
    }

    public List<AssetLink> getLinks(long groupId, Date startDate, Date endDate, int start, int end) {
        return this.assetLinkFinder.findByG_C(groupId, startDate, endDate, start, end);
    }

    public List<AssetLink> getLinks(long entryId, int typeId) {
        List e1Links = this.assetLinkPersistence.findByE1_T(entryId, typeId);
        List e2Links = this.assetLinkPersistence.findByE2_T(entryId, typeId);
        ArrayList<AssetLink> links = new ArrayList<AssetLink>(e1Links.size() + e2Links.size());
        links.addAll(e1Links);
        links.addAll(e2Links);
        return links;
    }

    public List<AssetLink> getLinks(long classNameId, long classPK) {
        return this.assetLinkFinder.findByC_C(classNameId, classPK);
    }

    public List<AssetLink> getReverseLinks(long entryId, int typeId) {
        return this.assetLinkPersistence.findByE2_T(entryId, typeId);
    }

    public AssetLink updateLink(long userId, long entryId1, long entryId2, int typeId, int weight) throws PortalException {
        AssetLink assetLink = this.assetLinkPersistence.fetchByE_E_T(entryId1, entryId2, typeId);
        if (assetLink == null) {
            return this.addLink(userId, entryId1, entryId2, typeId, weight);
        }
        assetLink.setWeight(weight);
        return (AssetLink)this.assetLinkPersistence.update((BaseModel)assetLink);
    }

    public void updateLinks(long userId, long entryId, long[] linkEntryIds, int typeId) throws PortalException {
        if (linkEntryIds == null) {
            return;
        }
        List<AssetLink> links = this.getLinks(entryId, typeId);
        for (AssetLink link : links) {
            if ((link.getEntryId1() != entryId || ArrayUtil.contains((long[])linkEntryIds, (long)link.getEntryId2())) && (link.getEntryId2() != entryId || ArrayUtil.contains((long[])linkEntryIds, (long)link.getEntryId1()))) continue;
            this.deleteLink(link);
        }
        for (Object assetLinkEntryId : (Object)linkEntryIds) {
            AssetLink link;
            if (assetLinkEntryId == entryId || (link = this.assetLinkPersistence.fetchByE_E_T(entryId, (long)assetLinkEntryId, typeId)) != null) continue;
            this.addLink(userId, entryId, (long)assetLinkEntryId, typeId, 0);
        }
    }

    protected void addDeletionSystemEvent(AssetLink assetLink) {
        AssetEntry assetEntry = this.assetEntryLocalService.fetchEntry(assetLink.getEntryId1());
        if (assetEntry == null) {
            return;
        }
        StagedAssetLink stagedAssetLink = (StagedAssetLink)ModelAdapterUtil.adapt((Object)assetLink, AssetLink.class, StagedAssetLink.class);
        StagedModelType stagedModelType = stagedAssetLink.getStagedModelType();
        try {
            this.systemEventLocalService.addSystemEvent(0L, assetEntry.getGroupId(), stagedModelType.getClassName(), stagedAssetLink.getPrimaryKey(), stagedAssetLink.getUuid(), null, 1, "");
        }
        catch (PortalException portalException) {
            throw new RuntimeException(portalException);
        }
    }

    protected List<AssetLink> filterAssetLinks(List<AssetLink> assetLinks, boolean excludeInvisibleLinks) {
        if (assetLinks.isEmpty() || !excludeInvisibleLinks) {
            return assetLinks;
        }
        ArrayList<AssetLink> filteredAssetLinks = new ArrayList<AssetLink>(assetLinks.size());
        for (AssetLink assetLink : assetLinks) {
            AssetEntry assetEntry = this.assetEntryPersistence.fetchByPrimaryKey(assetLink.getEntryId2());
            if (assetEntry == null || !assetEntry.isVisible()) continue;
            filteredAssetLinks.add(assetLink);
        }
        return Collections.unmodifiableList(filteredAssetLinks);
    }
}

