/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.asset.kernel.exception.AssetTagException;
import com.liferay.asset.kernel.exception.AssetTagNameException;
import com.liferay.asset.kernel.exception.DuplicateTagException;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCachable;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.increment.BufferedIncrement;
import com.liferay.portal.kernel.increment.NumberIncrement;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.asset.service.base.AssetTagLocalServiceBaseImpl;
import com.liferay.portlet.asset.util.comparator.AssetTagNameComparator;
import com.liferay.social.kernel.util.SocialCounterPeriodUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class AssetTagLocalServiceImpl
extends AssetTagLocalServiceBaseImpl {
    private static final char[] _INVALID_CHARACTERS = new char[]{'&', '\'', '@', '\\', ']', '}', ':', ',', '=', '>', '/', '<', '\n', '[', '{', '%', '|', '+', '#', '`', '?', '\"', '\r', ';', '/', '*', '~'};
    private static final Log _log = LogFactoryUtil.getLog(AssetTagLocalServiceImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public AssetTag addTag(long userId, long groupId, String name, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        long tagId = this.counterLocalService.increment();
        AssetTag tag = this.assetTagPersistence.create(tagId);
        tag.setUuid(serviceContext.getUuid());
        tag.setGroupId(groupId);
        tag.setCompanyId(user.getCompanyId());
        tag.setUserId(user.getUserId());
        tag.setUserName(user.getFullName());
        name = StringUtil.toLowerCase((String)StringUtil.trim((String)name));
        this.validate(name);
        if (this.hasTag(groupId, name)) {
            throw new DuplicateTagException("A tag with the name " + name + " already exists");
        }
        tag.setName(name);
        return (AssetTag)this.assetTagPersistence.update((BaseModel)tag);
    }

    public List<AssetTag> checkTags(long userId, Group group, String[] names) throws PortalException {
        ArrayList<AssetTag> tags = new ArrayList<AssetTag>();
        for (String name : names) {
            name = StringUtil.toLowerCase((String)StringUtil.trim((String)name));
            AssetTag tag = this.fetchTag(group.getGroupId(), name);
            if (tag == null) {
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setAddGroupPermissions(true);
                serviceContext.setAddGuestPermissions(true);
                serviceContext.setScopeGroupId(group.getGroupId());
                tag = this.addTag(userId, group.getGroupId(), name, serviceContext);
            }
            if (tag == null) continue;
            tags.add(tag);
        }
        return tags;
    }

    public List<AssetTag> checkTags(long userId, long groupId, String[] names) throws PortalException {
        return this.checkTags(userId, this.groupLocalService.getGroup(groupId), names);
    }

    @Indexable(type=IndexableType.REINDEX)
    public AssetTag decrementAssetCount(long tagId, long classNameId) throws PortalException {
        AssetTag tag = this.assetTagPersistence.findByPrimaryKey(tagId);
        tag.setAssetCount(Math.max(0, tag.getAssetCount() - 1));
        return (AssetTag)this.assetTagPersistence.update((BaseModel)tag);
    }

    public void deleteGroupTags(long groupId) throws PortalException {
        List<AssetTag> tags = this.getGroupTags(groupId);
        for (AssetTag tag : tags) {
            this.assetTagLocalService.deleteTag(tag);
        }
    }

    @SystemEvent(type=1)
    public void deleteTag(AssetTag tag) throws PortalException {
        List entries = this.assetTagPersistence.getAssetEntries(tag.getTagId());
        this.assetTagPersistence.remove((BaseModel)tag);
        this.assetEntryLocalService.reindex(entries);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(AssetTag.class);
        indexer.delete((Object)tag);
    }

    public void deleteTag(long tagId) throws PortalException {
        AssetTag tag = this.assetTagPersistence.findByPrimaryKey(tagId);
        this.assetTagLocalService.deleteTag(tag);
    }

    public AssetTag fetchTag(long groupId, String name) {
        return this.assetTagPersistence.fetchByG_N(groupId, name);
    }

    public List<AssetTag> getEntryTags(long entryId) {
        return this.assetEntryPersistence.getAssetTags(entryId);
    }

    public List<AssetTag> getGroupsTags(long[] groupIds) {
        ArrayList<AssetTag> groupsTags = new ArrayList<AssetTag>();
        for (long groupId : groupIds) {
            groupsTags.addAll(this.getGroupTags(groupId));
        }
        return groupsTags;
    }

    public List<AssetTag> getGroupTags(long groupId) {
        return this.assetTagPersistence.findByGroupId(groupId);
    }

    public List<AssetTag> getGroupTags(long groupId, int start, int end) {
        return this.assetTagPersistence.findByGroupId(groupId, start, end);
    }

    public int getGroupTagsCount(long groupId) {
        return this.assetTagPersistence.countByGroupId(groupId);
    }

    public List<AssetTag> getSocialActivityCounterOffsetTags(long groupId, String socialActivityCounterName, int startOffset, int endOffset) {
        return this.getSocialActivityCounterPeriodTags(groupId, socialActivityCounterName, SocialCounterPeriodUtil.getStartPeriod((int)startOffset), SocialCounterPeriodUtil.getEndPeriod((int)endOffset));
    }

    public List<AssetTag> getSocialActivityCounterPeriodTags(long groupId, String socialActivityCounterName, int startPeriod, int endPeriod) {
        int periodLength = SocialCounterPeriodUtil.getPeriodLength((int)SocialCounterPeriodUtil.getOffset((int)endPeriod));
        return this.assetTagFinder.findByG_N_S_E(groupId, socialActivityCounterName, startPeriod, endPeriod, periodLength);
    }

    public AssetTag getTag(long tagId) throws PortalException {
        return this.assetTagPersistence.findByPrimaryKey(tagId);
    }

    public AssetTag getTag(long groupId, String name) throws PortalException {
        return this.assetTagPersistence.findByG_N(groupId, name);
    }

    public long[] getTagIds(long groupId, String[] names) {
        ArrayList<Long> tagIds = new ArrayList<Long>(names.length);
        for (String name : names) {
            AssetTag tag = this.fetchTag(groupId, name);
            if (tag == null) continue;
            tagIds.add(tag.getTagId());
        }
        return ArrayUtil.toArray((Long[])tagIds.toArray(new Long[0]));
    }

    public long[] getTagIds(long[] groupIds, String name) {
        ArrayList<Long> tagIds = new ArrayList<Long>(groupIds.length);
        for (long groupId : groupIds) {
            AssetTag tag = this.fetchTag(groupId, name);
            if (tag == null) continue;
            tagIds.add(tag.getTagId());
        }
        return ArrayUtil.toArray((Long[])tagIds.toArray(new Long[0]));
    }

    public long[] getTagIds(long[] groupIds, String[] names) {
        long[] tagsIds = new long[]{};
        for (long groupId : groupIds) {
            tagsIds = ArrayUtil.append((long[][])new long[][]{tagsIds, this.getTagIds(groupId, names)});
        }
        return tagsIds;
    }

    public long[] getTagIds(String name) {
        List tags = this.assetTagPersistence.findByName(name);
        ArrayList<Long> tagIds = new ArrayList<Long>(tags.size());
        for (AssetTag tag : tags) {
            tagIds.add(tag.getTagId());
        }
        return ArrayUtil.toArray((Long[])tagIds.toArray(new Long[0]));
    }

    public String[] getTagNames() {
        return this.getTagNames(this.getTags());
    }

    public String[] getTagNames(long classNameId, long classPK) {
        return this.getTagNames(this.getTags(classNameId, classPK));
    }

    public String[] getTagNames(String className, long classPK) {
        return this.getTagNames(this.getTags(className, classPK));
    }

    public List<AssetTag> getTags() {
        return this.assetTagPersistence.findAll();
    }

    public List<AssetTag> getTags(long classNameId, long classPK) {
        AssetEntry entry = this.assetEntryPersistence.fetchByC_C(classNameId, classPK);
        if (entry == null) {
            return Collections.emptyList();
        }
        return this.assetEntryPersistence.getAssetTags(entry.getEntryId());
    }

    public List<AssetTag> getTags(long groupId, long classNameId, String name) {
        return this.assetTagFinder.findByG_C_N(groupId, classNameId, name, -1, -1, null);
    }

    public List<AssetTag> getTags(long groupId, long classNameId, String name, int start, int end) {
        return this.assetTagFinder.findByG_C_N(groupId, classNameId, name, start, end, null);
    }

    @ThreadLocalCachable
    public List<AssetTag> getTags(String className, long classPK) {
        return this.getTags(this.classNameLocalService.getClassNameId(className), classPK);
    }

    public int getTagsSize(long groupId, long classNameId, String name) {
        return this.assetTagFinder.countByG_C_N(groupId, classNameId, name);
    }

    public int getTagsSize(long groupId, String name) {
        return this.assetTagFinder.countByG_N(groupId, name);
    }

    public boolean hasTag(long groupId, String name) {
        AssetTag tag = this.fetchTag(groupId, name);
        return tag != null;
    }

    @BufferedIncrement(incrementClass=NumberIncrement.class)
    @Indexable(type=IndexableType.REINDEX)
    public AssetTag incrementAssetCount(long tagId, long classNameId) throws PortalException {
        AssetTag tag = this.assetTagPersistence.findByPrimaryKey(tagId);
        tag.setAssetCount(tag.getAssetCount() + 1);
        return (AssetTag)this.assetTagPersistence.update((BaseModel)tag);
    }

    public void mergeTags(long fromTagId, long toTagId) throws PortalException {
        List entries = this.assetTagPersistence.getAssetEntries(fromTagId);
        this.assetTagPersistence.addAssetEntries(toTagId, entries);
        this.deleteTag(fromTagId);
        for (AssetEntry entry : entries) {
            this.incrementAssetCount(toTagId, entry.getClassNameId());
        }
    }

    public List<AssetTag> search(long groupId, String name, int start, int end) {
        return this.search(new long[]{groupId}, name, start, end);
    }

    public List<AssetTag> search(long[] groupIds, String name, int start, int end) {
        return this.assetTagPersistence.findByG_LikeN(groupIds, name, start, end, (OrderByComparator)new AssetTagNameComparator());
    }

    public BaseModelSearchResult<AssetTag> searchTags(long[] groupIds, String name, int start, int end, Sort sort) throws PortalException {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        SearchContext searchContext = this.buildSearchContext(serviceContext.getCompanyId(), groupIds, name, start, end, sort);
        return this.searchTags(searchContext);
    }

    public void subscribeTag(long userId, long groupId, long tagId) throws PortalException {
        throw new UnsupportedOperationException("This method is implemented in com.liferay.asset.tags.internal.service.AssetTagLocalServiceWrapper");
    }

    public void unsubscribeTag(long userId, long tagId) throws PortalException {
        throw new UnsupportedOperationException("This method is implemented in com.liferay.asset.tags.internal.service.AssetTagLocalServiceWrapper");
    }

    @Indexable(type=IndexableType.REINDEX)
    public AssetTag updateTag(long userId, long tagId, String name, ServiceContext serviceContext) throws PortalException {
        AssetTag existingAssetTag;
        AssetTag tag = this.assetTagPersistence.findByPrimaryKey(tagId);
        String oldName = tag.getName();
        if (!(name = StringUtil.toLowerCase((String)StringUtil.trim((String)name))).equals(oldName) && this.hasTag(tag.getGroupId(), name)) {
            throw new DuplicateTagException("A tag with the name " + name + " already exists");
        }
        String tagName = tag.getName();
        if (!tagName.equals(name) && (existingAssetTag = this.fetchTag(tag.getGroupId(), name)) != null && existingAssetTag.getTagId() != tagId) {
            throw new DuplicateTagException("A tag with the name " + name + " already exists");
        }
        this.validate(name);
        tag.setName(name);
        tag = (AssetTag)this.assetTagPersistence.update((BaseModel)tag);
        if (!oldName.equals(name)) {
            List entries = this.assetTagPersistence.getAssetEntries(tag.getTagId());
            this.assetEntryLocalService.reindex(entries);
        }
        return tag;
    }

    protected SearchContext buildSearchContext(long companyId, long[] groupIds, String name, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttributes((Map)HashMapBuilder.put((Object)"name", (Object)name).build());
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setGroupIds(groupIds);
        searchContext.setKeywords(name);
        searchContext.setStart(start);
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    protected String[] getTagNames(List<AssetTag> tags) {
        return (String[])ListUtil.toArray(tags, (Accessor)AssetTag.NAME_ACCESSOR);
    }

    protected List<AssetTag> getTags(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<AssetTag> tags = new ArrayList<AssetTag>(documents.size());
        for (Document document : documents) {
            long tagId = GetterUtil.getLong((String)document.get("entryClassPK"));
            AssetTag tag = this.fetchAssetTag(tagId);
            if (tag == null) {
                tags = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(AssetTag.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (tags == null) continue;
            tags.add(tag);
        }
        return tags;
    }

    protected BaseModelSearchResult<AssetTag> searchTags(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(AssetTag.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext);
            List<AssetTag> tags = this.getTags(hits);
            if (tags == null) continue;
            return new BaseModelSearchResult(tags, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    protected void validate(String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new AssetTagNameException("Tag name cannot be an empty string");
        }
        if (!this._isValidWord(name)) {
            throw new AssetTagException("Tag name has one or more invalid characters: " + StringUtil.merge((char[])_INVALID_CHARACTERS, (String)" "), 2);
        }
        int maxLength = ModelHintsUtil.getMaxLength((String)AssetTag.class.getName(), (String)"name");
        if (name.length() > maxLength) {
            throw new AssetTagException("Tag name has more than " + maxLength + " characters", 3);
        }
    }

    private boolean _isValidWord(String word) {
        char[] wordCharArray;
        if (Validator.isBlank((String)word)) {
            return false;
        }
        for (char c : wordCharArray = word.toCharArray()) {
            for (char invalidChar : _INVALID_CHARACTERS) {
                if (c != invalidChar) continue;
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Word ", word, " is not valid because ", Character.valueOf(c), " is not allowed"}));
                }
                return false;
            }
        }
        return true;
    }
}

