/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.expando.service.permission;

import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.service.ExpandoColumnLocalServiceUtil;
import com.liferay.expando.kernel.service.permission.ExpandoColumnPermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;

public class ExpandoColumnPermissionImpl
implements ExpandoColumnPermission {
    public void check(PermissionChecker permissionChecker, ExpandoColumn column, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, column, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, ExpandoColumn.class.getName(), column.getColumnId(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long columnId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, columnId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, ExpandoColumn.class.getName(), columnId, new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long companyId, String className, String tableName, String columnName, String actionId) throws PortalException {
        ExpandoColumn column = ExpandoColumnLocalServiceUtil.getColumn((long)companyId, (String)className, (String)tableName, (String)columnName);
        this.check(permissionChecker, column, actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, ExpandoColumn column, String actionId) {
        return permissionChecker.hasPermission(null, ExpandoColumn.class.getName(), column.getColumnId(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long columnId, String actionId) throws PortalException {
        return this.contains(permissionChecker, ExpandoColumnLocalServiceUtil.getColumn((long)columnId), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long companyId, String className, String tableName, String columnName, String actionId) {
        ExpandoColumn column = ExpandoColumnLocalServiceUtil.getColumn((long)companyId, (String)className, (String)tableName, (String)columnName);
        return this.contains(permissionChecker, column, actionId);
    }
}

