/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.exportimport.service.impl;

import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.MissingReferences;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lifecycle.ExportImportLifecycleManagerUtil;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portlet.exportimport.service.base.StagingServiceBaseImpl;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class StagingServiceImpl
extends StagingServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(StagingServiceImpl.class);

    public void cleanUpStagingRequest(long stagingRequestId) throws PortalException {
        boolean stagingInProcessOnLive = ExportImportThreadLocal.isStagingInProcessOnRemoteLive();
        ExportImportThreadLocal.setStagingInProcessOnRemoteLive((boolean)true);
        try {
            this.checkPermission(stagingRequestId);
            this.stagingLocalService.cleanUpStagingRequest(stagingRequestId);
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("StagingServiceImpl#cleanUpStagingRequest(" + stagingRequestId + ")"), (Throwable)portalException);
            }
            throw portalException;
        }
        finally {
            ExportImportThreadLocal.setStagingInProcessOnRemoteLive((boolean)stagingInProcessOnLive);
        }
    }

    public long createStagingRequest(long groupId, String checksum) throws PortalException {
        boolean stagingInProcessOnLive = ExportImportThreadLocal.isStagingInProcessOnRemoteLive();
        ExportImportThreadLocal.setStagingInProcessOnRemoteLive((boolean)true);
        try {
            GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
            long l = this.stagingLocalService.createStagingRequest(this.getUserId(), groupId, checksum);
            return l;
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"StagingServiceImpl#createStagingRequest(", groupId, ", ", checksum, ")"}), (Throwable)portalException);
            }
            throw portalException;
        }
        finally {
            ExportImportThreadLocal.setStagingInProcessOnRemoteLive((boolean)stagingInProcessOnLive);
        }
    }

    public void enableLocalStaging(long groupId, boolean branchingPublic, boolean branchingPrivate, ServiceContext serviceContext) throws PortalException {
        Group liveGroup = this.groupLocalService.getGroup(groupId);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"MANAGE_STAGING");
        this.stagingLocalService.enableLocalStaging(this.getUserId(), liveGroup, branchingPublic, branchingPrivate, serviceContext);
    }

    public void enableRemoteStaging(long groupId, boolean branchingPublic, boolean branchingPrivate, String remoteAddress, int remotePort, String remotePathContext, boolean secureConnection, long remoteGroupId, ServiceContext serviceContext) throws PortalException {
        Group stagingGroup = this.groupLocalService.getGroup(groupId);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"MANAGE_STAGING");
        this.stagingLocalService.enableRemoteStaging(this.getUserId(), stagingGroup, branchingPublic, branchingPrivate, remoteAddress, remotePort, remotePathContext, secureConnection, remoteGroupId, serviceContext);
    }

    public boolean hasRemoteLayout(String uuid, long groupId, boolean privateLayout) throws PortalException {
        try {
            GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
            return this.layoutLocalService.hasLayout(uuid, groupId, privateLayout);
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"StagingServiceImpl#hasRemoteLayout(", uuid, ", ", groupId, ", ", privateLayout, ")"}), (Throwable)portalException);
            }
            throw portalException;
        }
    }

    public void propagateExportImportLifecycleEvent(int code, int processFlag, String processId, List<Serializable> arguments) throws PortalException {
        try {
            Serializable serializable = arguments.get(0);
            long groupId = 0L;
            if (serializable instanceof PortletDataContext) {
                PortletDataContext portletDataContext = (PortletDataContext)serializable;
                groupId = portletDataContext.getGroupId();
            } else if (serializable instanceof ExportImportConfiguration) {
                ExportImportConfiguration exportImportConfiguration = (ExportImportConfiguration)serializable;
                groupId = MapUtil.getLong((Map)exportImportConfiguration.getSettingsMap(), (String)"targetGroupId");
            }
            GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
            ExportImportLifecycleManagerUtil.fireExportImportLifecycleEvent((int)code, (int)processFlag, (String)processId, (Serializable[])arguments.toArray(new Serializable[0]));
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                StringBundler sb = new StringBundler(9);
                sb.append("StagingServiceImpl#propagateExportImportLifecycleEvent(");
                sb.append(code);
                sb.append(", ");
                sb.append(processFlag);
                sb.append(", ");
                sb.append(processId);
                sb.append(", ");
                sb.append(arguments);
                sb.append(")");
                _log.debug((Object)sb.toString(), (Throwable)portalException);
            }
            throw portalException;
        }
    }

    public MissingReferences publishStagingRequest(long stagingRequestId, ExportImportConfiguration exportImportConfiguration) throws PortalException {
        boolean stagingInProcessOnLive = ExportImportThreadLocal.isStagingInProcessOnRemoteLive();
        ExportImportThreadLocal.setStagingInProcessOnRemoteLive((boolean)true);
        try {
            this.checkPermission(stagingRequestId);
            MissingReferences missingReferences = this.stagingLocalService.publishStagingRequest(this.getUserId(), stagingRequestId, exportImportConfiguration);
            return missingReferences;
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"StagingServiceImpl#publishStagingRequest(", stagingRequestId, ", ", exportImportConfiguration, ")"}), (Throwable)portalException);
            }
            throw portalException;
        }
        finally {
            ExportImportThreadLocal.setStagingInProcessOnRemoteLive((boolean)stagingInProcessOnLive);
        }
    }

    public void updateStagingRequest(long stagingRequestId, String fileName, byte[] bytes) throws PortalException {
        boolean stagingInProcessOnLive = ExportImportThreadLocal.isStagingInProcessOnRemoteLive();
        ExportImportThreadLocal.setStagingInProcessOnRemoteLive((boolean)true);
        try {
            this.checkPermission(stagingRequestId);
            this.stagingLocalService.updateStagingRequest(this.getUserId(), stagingRequestId, fileName, bytes);
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"StagingServiceImpl#updateStagingRequest(", stagingRequestId, ", ", fileName, ", ", bytes.length, "bytes)"}), (Throwable)portalException);
            }
            throw portalException;
        }
        finally {
            ExportImportThreadLocal.setStagingInProcessOnRemoteLive((boolean)stagingInProcessOnLive);
        }
    }

    protected void checkPermission(long stagingRequestId) throws PortalException {
        Folder folder = PortletFileRepositoryUtil.getPortletFolder((long)stagingRequestId);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)folder.getGroupId(), (String)"EXPORT_IMPORT_LAYOUTS");
    }
}

