/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.db;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.db.BaseDB;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.Reader;

public class HypersonicDB
extends BaseDB {
    private static final String[] _HYPERSONIC = new String[]{"//", "true", "false", "'1970-01-01 00:00:00'", "now()", " blob", " blob", " bit", " timestamp", " double", " int", " bigint", " longvarchar", " longvarchar", " varchar", "", "commit"};
    private static final int[] _SQL_TYPES = new int[]{2004, 2004, -7, 93, 8, 4, -5, 12, 12, 12};
    private static final int[] _SQL_VARCHAR_SIZES = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE};

    public HypersonicDB(int majorVersion, int minorVersion) {
        super(DBType.HYPERSONIC, majorVersion, minorVersion);
    }

    @Override
    public String buildSQL(String template) throws IOException {
        template = this.replaceTemplate(template);
        template = this.reword(template);
        template = StringUtil.replace((String)template, (String)"\\'", (String)"''");
        return template;
    }

    public String getPopulateSQL(String databaseName, String sqlContent) {
        return "";
    }

    public String getRecreateSQL(String databaseName) {
        return "";
    }

    @Override
    protected int[] getSQLTypes() {
        return _SQL_TYPES;
    }

    @Override
    protected int[] getSQLVarcharSizes() {
        return _SQL_VARCHAR_SIZES;
    }

    @Override
    protected String[] getTemplate() {
        return _HYPERSONIC;
    }

    @Override
    protected String reword(String data) throws IOException {
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(data));){
            StringBundler sb = new StringBundler();
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                String[] template;
                if (line.startsWith("alter_column_name ")) {
                    template = this.buildColumnNameTokens(line);
                    line = StringUtil.replace((String)"alter table @table@ alter column @old-column@ rename to @new-column@;", (String[])REWORD_TEMPLATE, (String[])template);
                } else if (line.startsWith("alter_column_type ")) {
                    template = this.buildColumnTypeTokens(line);
                    line = StringUtil.replace((String)"alter table @table@ alter column @old-column@ @type@;", (String[])REWORD_TEMPLATE, (String[])template);
                    String nullable = template[template.length - 1];
                    if (!Validator.isBlank((String)nullable)) {
                        line = line.concat(StringUtil.replace((String)"alter table @table@ alter column @old-column@ set @nullable@;", (String[])REWORD_TEMPLATE, (String[])template));
                    }
                } else if (line.startsWith("alter_table_name ")) {
                    template = this.buildTableNameTokens(line);
                    line = StringUtil.replace((String)"alter table @old-table@ rename to @new-table@;", (String[])RENAME_TABLE_TEMPLATE, (String[])template);
                } else if (line.contains("drop index")) {
                    String[] tokens = StringUtil.split((String)line, (char)' ');
                    line = StringUtil.replace((String)"drop index @index@;", (String)"@index@", (String)tokens[2]);
                }
                sb.append(line);
                sb.append("\n");
            }
            String string = sb.toString();
            return string;
        }
    }
}

