/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.ORMException;
import com.liferay.portal.kernel.dao.orm.ObjectNotFoundException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONSerializer;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import org.hibernate.Session;
import org.hibernate.StaleObjectStateException;

public class ExceptionTranslator {
    public static ORMException translate(Exception exception) {
        if (exception instanceof org.hibernate.ObjectNotFoundException) {
            return new ObjectNotFoundException((Throwable)exception);
        }
        return new ORMException((Throwable)exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ORMException translate(Exception exception, Session session, Object object) {
        if (exception instanceof StaleObjectStateException) {
            BaseModel baseModel = (BaseModel)object;
            Object currentObject = session.get(object.getClass(), baseModel.getPrimaryKeyObj());
            BaseModel currentObjectBaseModel = (BaseModel)currentObject;
            currentObject = currentObjectBaseModel.clone();
            object = baseModel.clone();
            JSONSerializer jsonSerializer = JSONFactoryUtil.createJSONSerializer();
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            try {
                PermissionThreadLocal.setPermissionChecker(null);
                ORMException oRMException = new ORMException(StringBundler.concat((String[])new String[]{jsonSerializer.serialize(object), " is stale in comparison to ", jsonSerializer.serialize(currentObject)}), (Throwable)exception);
                return oRMException;
            }
            finally {
                PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
            }
        }
        return new ORMException((Throwable)exception);
    }
}

