/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate.event;

import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import java.io.Serializable;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.persister.entity.EntityPersister;

public class MVCCSynchronizerPostUpdateEventListener
implements PostUpdateEventListener {
    public static final MVCCSynchronizerPostUpdateEventListener INSTANCE = new MVCCSynchronizerPostUpdateEventListener();

    public void onPostUpdate(PostUpdateEvent postUpdateEvent) {
        Object entity = postUpdateEvent.getEntity();
        if (entity instanceof MVCCModel) {
            PortalCache portalCache;
            Serializable entityCacheResult;
            BaseModel baseModel;
            Serializable primaryKeyObj;
            CTModel ctModel;
            if (entity instanceof CTModel && (ctModel = (CTModel)entity).getCtCollectionId() != 0L) {
                return;
            }
            MVCCModel mvccModel = (MVCCModel)entity;
            long mvccVersion = mvccModel.getMvccVersion();
            Class<?> modelClass = entity.getClass();
            Serializable localCacheResult = EntityCacheUtil.getLocalCacheResult(modelClass, (Serializable)(primaryKeyObj = (baseModel = (BaseModel)entity).getPrimaryKeyObj()));
            if (localCacheResult instanceof MVCCModel) {
                MVCCModel localCacheMVCCModel = (MVCCModel)localCacheResult;
                localCacheMVCCModel.setMvccVersion(mvccVersion);
            }
            if ((entityCacheResult = (Serializable)(portalCache = EntityCacheUtil.getPortalCache(modelClass)).get(primaryKeyObj)) instanceof MVCCModel) {
                MVCCModel entityCacheMVCCModel = (MVCCModel)entityCacheResult;
                entityCacheMVCCModel.setMvccVersion(mvccVersion);
            }
        }
    }

    @Deprecated
    public boolean requiresPostCommitHanding(EntityPersister entityPersister) {
        throw new UnsupportedOperationException();
    }
}

