/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.events.LifecycleAction;
import com.liferay.portal.kernel.events.LifecycleEvent;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.framework.BundleContext;

public class EventsProcessorUtil {
    private static final Log _log = LogFactoryUtil.getLog(EventsProcessorUtil.class);
    private static final ServiceTrackerMap<String, List<LifecycleAction>> _lifecycleActions = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)SystemBundleUtil.getBundleContext(), LifecycleAction.class, (String)"key");

    public static void process(String key, String[] classes) throws ActionException {
        EventsProcessorUtil.process(key, classes, new LifecycleEvent());
    }

    public static void process(String key, String[] classes, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ActionException {
        EventsProcessorUtil.process(key, classes, new LifecycleEvent(httpServletRequest, httpServletResponse));
    }

    public static void process(String key, String[] classes, HttpSession httpSession) throws ActionException {
        EventsProcessorUtil.process(key, classes, new LifecycleEvent(httpSession));
    }

    public static void process(String key, String[] classes, LifecycleEvent lifecycleEvent) throws ActionException {
        for (String className : classes) {
            if (Validator.isNull((String)className)) {
                return;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Process event " + className));
            }
            LifecycleAction lifecycleAction = (LifecycleAction)InstancePool.get((String)className);
            lifecycleAction.processLifecycleEvent(lifecycleEvent);
        }
        if (Validator.isNull((String)key)) {
            return;
        }
        List lifecycleActions = (List)_lifecycleActions.getService((Object)key);
        if (lifecycleActions != null) {
            for (LifecycleAction lifecycleAction : lifecycleActions) {
                lifecycleAction.processLifecycleEvent(lifecycleEvent);
            }
        }
    }

    public static void process(String key, String[] classes, String[] ids) throws ActionException {
        EventsProcessorUtil.process(key, classes, new LifecycleEvent(ids));
    }

    public static void processEvent(LifecycleAction lifecycleAction, LifecycleEvent lifecycleEvent) throws ActionException {
        lifecycleAction.processLifecycleEvent(lifecycleEvent);
    }

    protected EventsProcessorUtil() {
    }
}

