/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SecureRequestAction
extends Action {
    private static final boolean _REQUIRES_SECURE = true;
    private static final Log _log = LogFactoryUtil.getLog(SecureRequestAction.class);

    public void run(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ActionException {
        try {
            if (httpServletRequest.isSecure() || !this.isRequiresSecure(httpServletRequest) || httpServletResponse.isCommitted()) {
                return;
            }
            String redirect = this.getRedirect(httpServletRequest);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Redirect " + redirect));
            }
            if (redirect != null) {
                httpServletResponse.sendRedirect(redirect);
            }
        }
        catch (Exception exception) {
            throw new ActionException((Throwable)exception);
        }
    }

    protected String getRedirect(HttpServletRequest httpServletRequest) {
        String unsecureCompleteURL = PortalUtil.getCurrentCompleteURL((HttpServletRequest)httpServletRequest);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Unsecure URL " + unsecureCompleteURL));
        }
        String secureCompleteURL = StringUtil.replaceFirst((String)unsecureCompleteURL, (String)"http://", (String)"https://");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Secure URL " + secureCompleteURL));
        }
        if (unsecureCompleteURL.equals(secureCompleteURL)) {
            return null;
        }
        return secureCompleteURL;
    }

    protected boolean isRequiresSecure(HttpServletRequest httpServletRequest) {
        return true;
    }
}

