/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.document.library.kernel.service.DLAppServiceUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ColorScheme;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.model.VirtualHost;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetPrototypeLocalServiceUtil;
import com.liferay.portal.kernel.service.ThemeLocalServiceUtil;
import com.liferay.portal.kernel.service.VirtualHostLocalServiceUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.LayoutSetBaseImpl;
import com.liferay.portal.model.impl.ThemeSettingImpl;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public class LayoutSetImpl
extends LayoutSetBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(LayoutSetImpl.class);
    private String _companyFallbackVirtualHostname;
    private String _faviconURL;
    private UnicodeProperties _settingsUnicodeProperties;
    private TreeMap<String, String> _virtualHostnames;

    public ColorScheme getColorScheme() {
        return ThemeLocalServiceUtil.getColorScheme((long)this.getCompanyId(), (String)this.getThemeId(), (String)this.getColorSchemeId());
    }

    @Override
    public String getCompanyFallbackVirtualHostname() {
        Company company;
        Group group;
        if (this._companyFallbackVirtualHostname != null) {
            return this._companyFallbackVirtualHostname;
        }
        this._companyFallbackVirtualHostname = "";
        if (Validator.isNotNull((String)PropsValues.VIRTUAL_HOSTS_DEFAULT_SITE_NAME) && !this.isPrivateLayout() && (group = GroupLocalServiceUtil.fetchGroup((long)this.getCompanyId(), (String)PropsValues.VIRTUAL_HOSTS_DEFAULT_SITE_NAME)) != null && this.getGroupId() == group.getGroupId() && (company = CompanyLocalServiceUtil.fetchCompany((long)this.getCompanyId())) != null) {
            this._companyFallbackVirtualHostname = company.getVirtualHostname();
        }
        return this._companyFallbackVirtualHostname;
    }

    public String getFaviconURL() {
        FileEntry fileEntry;
        block5: {
            if (this._faviconURL != null) {
                return this._faviconURL;
            }
            if (this.getFaviconFileEntryId() == 0L) {
                return null;
            }
            fileEntry = null;
            try {
                fileEntry = DLAppServiceUtil.getFileEntry((long)this.getFaviconFileEntryId());
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) break block5;
                _log.debug((Throwable)portalException);
            }
        }
        if (fileEntry == null) {
            return null;
        }
        this._faviconURL = HtmlUtil.escape((String)StringBundler.concat((Object[])new Object[]{PortalUtil.getPathContext(), "/documents/", fileEntry.getRepositoryId(), "/", fileEntry.getFolderId(), "/", URLCodec.encodeURL((String)HtmlUtil.unescape((String)fileEntry.getTitle())), "/", URLCodec.encodeURL((String)fileEntry.getUuid())}));
        return this._faviconURL;
    }

    public Group getGroup() throws PortalException {
        return GroupLocalServiceUtil.getGroup((long)this.getGroupId());
    }

    public long getLayoutSetPrototypeId() throws PortalException {
        String layoutSetPrototypeUuid = this.getLayoutSetPrototypeUuid();
        if (Validator.isNull((String)layoutSetPrototypeUuid)) {
            return 0L;
        }
        LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototypeByUuidAndCompanyId((String)layoutSetPrototypeUuid, (long)this.getCompanyId());
        return layoutSetPrototype.getLayoutSetPrototypeId();
    }

    public long getLiveLogoId() {
        long logoId = 0L;
        Group group = null;
        try {
            group = this.getGroup();
            if (!group.isStagingGroup()) {
                return logoId;
            }
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return logoId;
        }
        Group liveGroup = group.getLiveGroup();
        LayoutSet liveLayoutSet = null;
        liveLayoutSet = this.isPrivateLayout() ? liveGroup.getPrivateLayoutSet() : liveGroup.getPublicLayoutSet();
        return liveLayoutSet.getLogoId();
    }

    public boolean getLogo() {
        return this.getLogoId() > 0L;
    }

    public int getPageCount() {
        return LayoutSetLocalServiceUtil.getPageCount((long)this.getGroupId(), (boolean)this.getPrivateLayout());
    }

    @Override
    public String getSettings() {
        if (this._settingsUnicodeProperties == null) {
            return super.getSettings();
        }
        return this._settingsUnicodeProperties.toString();
    }

    public UnicodeProperties getSettingsProperties() {
        if (this._settingsUnicodeProperties == null) {
            this._settingsUnicodeProperties = new UnicodeProperties(true);
            try {
                this._settingsUnicodeProperties.load(super.getSettings());
            }
            catch (IOException ioException) {
                _log.error((Throwable)ioException);
            }
        }
        return this._settingsUnicodeProperties;
    }

    public String getSettingsProperty(String key) {
        UnicodeProperties settingsUnicodeProperties = this.getSettingsProperties();
        return settingsUnicodeProperties.getProperty(key);
    }

    public Theme getTheme() {
        return ThemeLocalServiceUtil.getTheme((long)this.getCompanyId(), (String)this.getThemeId());
    }

    public String getThemeSetting(String key, String device) {
        UnicodeProperties settingsUnicodeProperties;
        String value;
        if (!Validator.isBlank((String)super.getSettings()) && (value = (settingsUnicodeProperties = this.getSettingsProperties()).getProperty(ThemeSettingImpl.namespaceProperty(device, key))) != null) {
            return value;
        }
        Theme theme = this.getTheme(device);
        return theme.getSetting(key);
    }

    @Override
    public TreeMap<String, String> getVirtualHostnames() {
        if (this._virtualHostnames != null) {
            return new TreeMap<String, String>((SortedMap<String, String>)this._virtualHostnames);
        }
        List virtualHosts = VirtualHostLocalServiceUtil.getVirtualHosts((long)this.getCompanyId(), (long)this.getLayoutSetId());
        if (ListUtil.isEmpty((List)virtualHosts)) {
            this._virtualHostnames = new TreeMap();
        } else {
            TreeMap<String, String> virtualHostnames = new TreeMap<String, String>();
            for (VirtualHost virtualHost : virtualHosts) {
                virtualHostnames.put(virtualHost.getHostname(), virtualHost.getLanguageId());
            }
            this._virtualHostnames = virtualHostnames;
        }
        return new TreeMap<String, String>((SortedMap<String, String>)this._virtualHostnames);
    }

    @Override
    public boolean hasSetModifiedDate() {
        return true;
    }

    public boolean isLayoutSetPrototypeLinkActive() {
        return this.isLayoutSetPrototypeLinkEnabled() && Validator.isNotNull((String)this.getLayoutSetPrototypeUuid());
    }

    public boolean isLogo() {
        return this.getLogo();
    }

    @Override
    public void setCompanyFallbackVirtualHostname(String companyFallbackVirtualHostname) {
        this._companyFallbackVirtualHostname = companyFallbackVirtualHostname;
    }

    @Override
    public void setSettings(String settings) {
        this._settingsUnicodeProperties = null;
        super.setSettings(settings);
    }

    public void setSettingsProperties(UnicodeProperties settingsUnicodeProperties) {
        this._settingsUnicodeProperties = settingsUnicodeProperties;
        super.setSettings(this._settingsUnicodeProperties.toString());
    }

    @Override
    public void setVirtualHostnames(TreeMap<String, String> virtualHostnames) {
        this._virtualHostnames = virtualHostnames;
    }

    protected Theme getTheme(String device) {
        boolean controlPanel;
        block3: {
            controlPanel = false;
            try {
                Group group = this.getGroup();
                controlPanel = group.isControlPanel();
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Throwable)exception);
            }
        }
        if (controlPanel) {
            String themeId = PrefsPropsUtil.getString((long)this.getCompanyId(), (String)"control.panel.layout.regular.theme.id");
            return ThemeLocalServiceUtil.getTheme((long)this.getCompanyId(), (String)themeId);
        }
        return this.getTheme();
    }
}

