/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.liferayrepository.model;

import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.model.DLFolderConstants;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.RepositoryProviderUtil;
import com.liferay.portal.kernel.repository.capabilities.Capability;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.model.RepositoryModelOperation;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import com.liferay.portal.repository.liferayrepository.model.LiferayModel;
import com.liferay.portlet.documentlibrary.util.RepositoryModelUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LiferayFolder
extends LiferayModel
implements Folder {
    private static volatile ModelResourcePermission<DLFolder> _dlFolderModelResourcePermission = (ModelResourcePermission)ServiceProxyFactory.newServiceTrackedInstance(ModelResourcePermission.class, LiferayFolder.class, (String)"_dlFolderModelResourcePermission", (String)("(model.class.name=" + DLFolder.class.getName() + ")"), (boolean)true);
    private final DLFolder _dlFolder;
    private final boolean _escapedModel;

    public LiferayFolder(DLFolder dlFolder) {
        this._dlFolder = dlFolder;
        this._escapedModel = dlFolder == null ? false : dlFolder.isEscapedModel();
    }

    public LiferayFolder(DLFolder dlFolder, boolean escapedModel) {
        this._dlFolder = dlFolder;
        this._escapedModel = escapedModel;
    }

    public Object clone() {
        return new LiferayFolder(this._dlFolder);
    }

    public boolean containsPermission(PermissionChecker permissionChecker, String actionId) throws PortalException {
        return _dlFolderModelResourcePermission.contains(permissionChecker, (ClassedModel)this._dlFolder, actionId);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LiferayFolder)) {
            return false;
        }
        LiferayFolder liferayFolder = (LiferayFolder)object;
        return Objects.equals(this._dlFolder, liferayFolder._dlFolder);
    }

    public void execute(RepositoryModelOperation repositoryModelOperation) throws PortalException {
        repositoryModelOperation.execute((Folder)this);
    }

    public List<Long> getAncestorFolderIds() throws PortalException {
        return this._dlFolder.getAncestorFolderIds();
    }

    public List<Folder> getAncestors() throws PortalException {
        return RepositoryModelUtil.toFolders(this._dlFolder.getAncestors());
    }

    public Map<String, Serializable> getAttributes() {
        ExpandoBridge expandoBridge = this.getExpandoBridge();
        return expandoBridge.getAttributes();
    }

    @Override
    public long getCompanyId() {
        return this._dlFolder.getCompanyId();
    }

    public Date getCreateDate() {
        return this._dlFolder.getCreateDate();
    }

    public String getDescription() {
        return this._dlFolder.getDescription();
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return this._dlFolder.getExpandoBridge();
    }

    public String getExternalReferenceCode() {
        return this._dlFolder.getExternalReferenceCode();
    }

    public long getFolderId() {
        return this._dlFolder.getFolderId();
    }

    public long getGroupId() {
        return this._dlFolder.getGroupId();
    }

    public Date getLastPostDate() {
        return this._dlFolder.getLastPostDate();
    }

    public Date getLastPublishDate() {
        return this._dlFolder.getLastPublishDate();
    }

    public Object getModel() {
        return this._dlFolder;
    }

    public Class<?> getModelClass() {
        return LiferayFolder.class;
    }

    @Override
    public String getModelClassName() {
        return LiferayFolder.class.getName();
    }

    public Date getModifiedDate() {
        return this._dlFolder.getModifiedDate();
    }

    public String getName() {
        return this._dlFolder.getName();
    }

    public Folder getParentFolder() throws PortalException {
        DLFolder dlParentFolder = this._dlFolder.getParentFolder();
        if (dlParentFolder == null) {
            return null;
        }
        return new LiferayFolder(dlParentFolder);
    }

    public long getParentFolderId() {
        return this._dlFolder.getParentFolderId();
    }

    @Override
    public long getPrimaryKey() {
        return this._dlFolder.getPrimaryKey();
    }

    public Serializable getPrimaryKeyObj() {
        return Long.valueOf(this.getPrimaryKey());
    }

    public <T extends Capability> T getRepositoryCapability(Class<T> capabilityClass) {
        Repository repository = this._getRepository();
        return (T)repository.getCapability(capabilityClass);
    }

    public long getRepositoryId() {
        return this._dlFolder.getRepositoryId();
    }

    public StagedModelType getStagedModelType() {
        return new StagedModelType(DLFolderConstants.getClassName());
    }

    public long getUserId() {
        return this._dlFolder.getUserId();
    }

    public String getUserName() {
        return this._dlFolder.getUserName();
    }

    public String getUserUuid() {
        return this._dlFolder.getUserUuid();
    }

    public String getUuid() {
        return this._dlFolder.getUuid();
    }

    public int hashCode() {
        return this._dlFolder.hashCode();
    }

    public boolean hasInheritableLock() {
        return this._dlFolder.hasInheritableLock();
    }

    public boolean hasLock() {
        return this._dlFolder.hasLock();
    }

    public boolean isDefaultRepository() {
        return this._dlFolder.getGroupId() == this._dlFolder.getRepositoryId();
    }

    public boolean isEscapedModel() {
        return this._escapedModel;
    }

    public boolean isLocked() {
        return this._dlFolder.isLocked();
    }

    public boolean isMountPoint() {
        return this._dlFolder.isMountPoint();
    }

    public <T extends Capability> boolean isRepositoryCapabilityProvided(Class<T> capabilityClass) {
        Repository repository = this._getRepository();
        return repository.isCapabilityProvided(capabilityClass);
    }

    public boolean isRoot() {
        return this._dlFolder.isRoot();
    }

    public boolean isSupportsLocking() {
        return !this.isMountPoint();
    }

    public boolean isSupportsMetadata() {
        return !this.isMountPoint();
    }

    public boolean isSupportsMultipleUpload() {
        return !this.isMountPoint();
    }

    public boolean isSupportsShortcuts() {
        return !this.isMountPoint();
    }

    public boolean isSupportsSocial() {
        return !this.isMountPoint();
    }

    public boolean isSupportsSubscribing() {
        return !this.isMountPoint();
    }

    public void setCompanyId(long companyId) {
        this._dlFolder.setCompanyId(companyId);
    }

    public void setCreateDate(Date createDate) {
        this._dlFolder.setCreateDate(createDate);
    }

    public void setGroupId(long groupId) {
        this._dlFolder.setGroupId(groupId);
    }

    public void setLastPublishDate(Date lastPublishDate) {
        this._dlFolder.setLastPublishDate(lastPublishDate);
    }

    public void setModifiedDate(Date modifiedDate) {
        this._dlFolder.setModifiedDate(modifiedDate);
    }

    public void setPrimaryKey(long primaryKey) {
        this._dlFolder.setPrimaryKey(primaryKey);
    }

    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        this.setPrimaryKey((Long)primaryKeyObj);
    }

    public void setUserId(long userId) {
        this._dlFolder.setUserId(userId);
    }

    public void setUserName(String userName) {
        this._dlFolder.setUserName(userName);
    }

    public void setUserUuid(String userUuid) {
        this._dlFolder.setUserUuid(userUuid);
    }

    public void setUuid(String uuid) {
        this._dlFolder.setUuid(uuid);
    }

    public Folder toEscapedModel() {
        if (this.isEscapedModel()) {
            return this;
        }
        return new LiferayFolder((DLFolder)this._dlFolder.toEscapedModel(), true);
    }

    public String toString() {
        return this._dlFolder.toString();
    }

    public Folder toUnescapedModel() {
        if (this.isEscapedModel()) {
            return new LiferayFolder((DLFolder)this._dlFolder.toUnescapedModel(), true);
        }
        return this;
    }

    private Repository _getRepository() {
        try {
            return RepositoryProviderUtil.getRepository((long)this.getRepositoryId());
        }
        catch (PortalException portalException) {
            throw new SystemException("Unable to get repository for folder " + this.getFolderId(), (Throwable)portalException);
        }
    }
}

