/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.access.control;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.access.control.AccessControl;
import com.liferay.portal.kernel.security.access.control.AccessControlThreadLocal;
import com.liferay.portal.kernel.security.access.control.AccessControlUtil;
import com.liferay.portal.kernel.security.auth.AccessControlContext;
import com.liferay.portal.kernel.security.auth.AuthException;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.auth.verifier.AuthVerifierResult;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.security.auth.AuthVerifierPipeline;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AccessControlImpl
implements AccessControl {
    public void initAccessControlContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map<String, Object> settings) {
        AccessControlContext accessControlContext = AccessControlUtil.getAccessControlContext();
        if (accessControlContext != null) {
            throw new IllegalStateException("Authentication context is already initialized");
        }
        accessControlContext = new AccessControlContext();
        accessControlContext.setRequest(httpServletRequest);
        accessControlContext.setResponse(httpServletResponse);
        Map accessControlContextSettings = accessControlContext.getSettings();
        accessControlContextSettings.putAll(settings);
        AccessControlUtil.setAccessControlContext((AccessControlContext)accessControlContext);
    }

    public void initContextUser(long userId) throws AuthException {
        try {
            User user = UserLocalServiceUtil.getUser((long)userId);
            CompanyThreadLocal.setCompanyId((Long)user.getCompanyId());
            PrincipalThreadLocal.setName((long)userId);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)PermissionCheckerFactoryUtil.create((User)user));
            AccessControlThreadLocal.setRemoteAccess((boolean)false);
        }
        catch (Exception exception) {
            throw new AuthException(exception.getMessage(), (Throwable)exception);
        }
    }

    public AuthVerifierResult.State verifyRequest() throws PortalException {
        AuthVerifierResult authVerifierResult = null;
        AccessControlContext accessControlContext = AccessControlUtil.getAccessControlContext();
        Map settings = accessControlContext.getSettings();
        if (!settings.containsKey(AuthVerifierPipeline.class.getName())) {
            AuthVerifierPipeline portalAuthVerifierPipeline = AuthVerifierPipeline.getPortalAuthVerifierPipeline();
            authVerifierResult = portalAuthVerifierPipeline.verifyRequest(accessControlContext);
        } else {
            AuthVerifierPipeline authVerifierPipeline = (AuthVerifierPipeline)settings.get(AuthVerifierPipeline.class.getName());
            authVerifierResult = authVerifierPipeline.verifyRequest(accessControlContext);
            if (authVerifierResult.getState() == AuthVerifierResult.State.NOT_APPLICABLE || authVerifierResult.getState() == AuthVerifierResult.State.UNSUCCESSFUL) {
                AuthVerifierPipeline portalAuthVerifierPipeline = AuthVerifierPipeline.getPortalAuthVerifierPipeline();
                authVerifierResult = portalAuthVerifierPipeline.verifyRequest(accessControlContext);
            }
        }
        Map authVerifierResultSettings = authVerifierResult.getSettings();
        if (authVerifierResultSettings != null) {
            settings.putAll(authVerifierResultSettings);
        }
        accessControlContext.setAuthVerifierResult(authVerifierResult);
        return authVerifierResult.getState();
    }
}

