/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission;

import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.UserBag;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import java.util.Map;
import java.util.Objects;

public class StagingPermissionChecker
implements PermissionChecker {
    private final PermissionChecker _permissionChecker;

    public StagingPermissionChecker(PermissionChecker permissionChecker) {
        this._permissionChecker = permissionChecker;
    }

    public PermissionChecker clone() {
        return new StagingPermissionChecker(this._permissionChecker.clone());
    }

    public long getCompanyId() {
        return this._permissionChecker.getCompanyId();
    }

    public long[] getGuestUserRoleIds() {
        return this._permissionChecker.getGuestUserRoleIds();
    }

    public long getOwnerRoleId() {
        return this._permissionChecker.getOwnerRoleId();
    }

    public Map<Object, Object> getPermissionChecksMap() {
        return this._permissionChecker.getPermissionChecksMap();
    }

    public long[] getRoleIds(long userId, long groupId) {
        return this._permissionChecker.getRoleIds(userId, StagingUtil.getLiveGroupId((long)groupId));
    }

    public User getUser() {
        return this._permissionChecker.getUser();
    }

    public UserBag getUserBag() throws Exception {
        return this._permissionChecker.getUserBag();
    }

    public long getUserId() {
        return this._permissionChecker.getUserId();
    }

    public boolean hasOwnerPermission(long companyId, String name, long primKey, long ownerId, String actionId) {
        return this._permissionChecker.hasOwnerPermission(companyId, name, primKey, ownerId, actionId);
    }

    public boolean hasOwnerPermission(long companyId, String name, String primKey, long ownerId, String actionId) {
        return this._permissionChecker.hasOwnerPermission(companyId, name, primKey, ownerId, actionId);
    }

    public boolean hasPermission(Group group, String name, long primKey, String actionId) {
        if (this._isStagingFolder(name, actionId)) {
            return true;
        }
        Group liveGroup = StagingUtil.getLiveGroup((Group)group);
        if (liveGroup != null && liveGroup.getGroupId() != group.getGroupId() && primKey == group.getGroupId()) {
            primKey = liveGroup.getGroupId();
        }
        return this._permissionChecker.hasPermission(liveGroup, name, primKey, actionId);
    }

    public boolean hasPermission(Group group, String name, String primKey, String actionId) {
        if (this._isStagingFolder(name, actionId)) {
            return true;
        }
        Group liveGroup = StagingUtil.getLiveGroup((Group)group);
        if (liveGroup != group && primKey.equals(String.valueOf(group.getGroupId()))) {
            primKey = String.valueOf(liveGroup.getGroupId());
        }
        return this._permissionChecker.hasPermission(liveGroup, name, primKey, actionId);
    }

    public boolean hasPermission(long groupId, String name, long primKey, String actionId) {
        return this.hasPermission(GroupLocalServiceUtil.fetchGroup((long)groupId), name, primKey, actionId);
    }

    public boolean hasPermission(long groupId, String name, String primKey, String actionId) {
        return this.hasPermission(GroupLocalServiceUtil.fetchGroup((long)groupId), name, primKey, actionId);
    }

    public void init(User user) {
        this._permissionChecker.init(user);
    }

    public boolean isCheckGuest() {
        return this._permissionChecker.isCheckGuest();
    }

    public boolean isCompanyAdmin() {
        return this._permissionChecker.isCompanyAdmin();
    }

    public boolean isCompanyAdmin(long companyId) {
        return this._permissionChecker.isCompanyAdmin(companyId);
    }

    public boolean isContentReviewer(long companyId, long groupId) {
        return this._permissionChecker.isContentReviewer(companyId, StagingUtil.getLiveGroupId((long)groupId));
    }

    public boolean isGroupAdmin(long groupId) {
        return this._permissionChecker.isGroupAdmin(StagingUtil.getLiveGroupId((long)groupId));
    }

    public boolean isGroupMember(long groupId) {
        return this._permissionChecker.isGroupMember(StagingUtil.getLiveGroupId((long)groupId));
    }

    public boolean isGroupOwner(long groupId) {
        return this._permissionChecker.isGroupOwner(StagingUtil.getLiveGroupId((long)groupId));
    }

    public boolean isOmniadmin() {
        return this._permissionChecker.isOmniadmin();
    }

    public boolean isOrganizationAdmin(long organizationId) {
        return this._permissionChecker.isOrganizationAdmin(organizationId);
    }

    public boolean isOrganizationOwner(long organizationId) {
        return this._permissionChecker.isOrganizationOwner(organizationId);
    }

    public boolean isSignedIn() {
        return this._permissionChecker.isSignedIn();
    }

    private boolean _isStagingFolder(String name, String actionId) {
        return ExportImportThreadLocal.isStagingInProcessOnRemoteLive() && actionId.equals("VIEW") && (name.equals(Folder.class.getName()) || name.equals(DLFolder.class.getName()) || Objects.equals("com.liferay.document.library", name));
    }
}

