/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.cache.CacheRegistryItem;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.ClassNameImpl;
import com.liferay.portal.service.base.ClassNameLocalServiceBaseImpl;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@CTAware
public class ClassNameLocalServiceImpl
extends ClassNameLocalServiceBaseImpl
implements CacheRegistryItem {
    private static final Log _log = LogFactoryUtil.getLog(ClassNameLocalServiceImpl.class);
    private static final Map<String, ClassName> _classNames = new ConcurrentHashMap<String, ClassName>();
    private static final ClassName _nullClassName = new ClassNameImpl();

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public ClassName addClassName(String value) {
        ClassName className = this.classNamePersistence.fetchByValue(value);
        if (className == null) {
            long classNameId = this.counterLocalService.increment();
            className = this.classNamePersistence.create(classNameId);
            className.setValue(value);
            className = (ClassName)this.classNamePersistence.update((BaseModel)className);
        }
        return className;
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public void checkClassNames() {
        List classNames = this.classNamePersistence.findAll();
        for (ClassName className : classNames) {
            _classNames.put(className.getValue(), className);
        }
        List models = ModelHintsUtil.getModels();
        for (String model : models) {
            this.getClassName(model);
        }
    }

    @Override
    public ClassName deleteClassName(ClassName className) {
        _classNames.remove(className.getValue());
        return (ClassName)this.classNamePersistence.remove((BaseModel)className);
    }

    public ClassName fetchByClassNameId(long classNameId) {
        return this.classNamePersistence.fetchByPrimaryKey(classNameId);
    }

    public ClassName fetchClassName(String value) {
        if (Validator.isNull((String)value)) {
            return _nullClassName;
        }
        ClassName className = _classNames.computeIfAbsent(value, key -> this.classNamePersistence.fetchByValue(value));
        if (className == null) {
            return _nullClassName;
        }
        return className;
    }

    @Transactional(enabled=false)
    public ClassName getClassName(String value) {
        if (Validator.isNull((String)value)) {
            return _nullClassName;
        }
        ClassName className = _classNames.computeIfAbsent(value, key -> {
            try {
                return this.classNameLocalService.addClassName(value);
            }
            catch (Throwable throwable) {
                if (_log.isDebugEnabled()) {
                    _log.debug(throwable);
                }
                return null;
            }
        });
        if (className == null) {
            return this.classNameLocalService.fetchClassName(value);
        }
        return className;
    }

    @Transactional(enabled=false)
    public long getClassNameId(Class<?> clazz) {
        return this.getClassNameId(clazz.getName());
    }

    @Transactional(enabled=false)
    public long getClassNameId(String value) {
        ClassName className = this.getClassName(value);
        return className.getClassNameId();
    }

    public String getRegistryName() {
        return ClassNameLocalServiceImpl.class.getName();
    }

    public void invalidate() {
        _classNames.clear();
    }
}

