/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.NoSuchLayoutPrototypeException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.RequiredLayoutPrototypeException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.persistence.LayoutPersistence;
import com.liferay.portal.kernel.service.persistence.UserPersistence;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.service.base.LayoutPrototypeLocalServiceBaseImpl;
import com.liferay.portal.util.PortalInstances;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LayoutPrototypeLocalServiceImpl
extends LayoutPrototypeLocalServiceBaseImpl {
    @BeanReference(type=GroupLocalService.class)
    private GroupLocalService _groupLocalService;
    @BeanReference(type=LayoutLocalService.class)
    private LayoutLocalService _layoutLocalService;
    @BeanReference(type=LayoutPersistence.class)
    private LayoutPersistence _layoutPersistence;
    @BeanReference(type=ResourceLocalService.class)
    private ResourceLocalService _resourceLocalService;
    @BeanReference(type=UserLocalService.class)
    private UserLocalService _userLocalService;
    @BeanReference(type=UserPersistence.class)
    private UserPersistence _userPersistence;

    public LayoutPrototype addLayoutPrototype(long userId, long companyId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, ServiceContext serviceContext) throws PortalException {
        User user = this._userPersistence.findByPrimaryKey(userId);
        Date date = new Date();
        long layoutPrototypeId = this.counterLocalService.increment();
        LayoutPrototype layoutPrototype = this.layoutPrototypePersistence.create(layoutPrototypeId);
        layoutPrototype.setUuid(serviceContext.getUuid());
        layoutPrototype.setCompanyId(companyId);
        layoutPrototype.setUserId(userId);
        layoutPrototype.setUserName(user.getFullName());
        layoutPrototype.setCreateDate(serviceContext.getCreateDate(date));
        layoutPrototype.setModifiedDate(serviceContext.getModifiedDate(date));
        layoutPrototype.setNameMap(nameMap);
        layoutPrototype.setDescriptionMap(descriptionMap);
        layoutPrototype.setActive(active);
        layoutPrototype = (LayoutPrototype)this.layoutPrototypePersistence.update((BaseModel)layoutPrototype);
        this._resourceLocalService.addResources(companyId, 0L, userId, LayoutPrototype.class.getName(), layoutPrototype.getLayoutPrototypeId(), false, true, false);
        String friendlyURL = "/template-" + layoutPrototype.getLayoutPrototypeId();
        Group group = this._groupLocalService.addGroup(userId, 0L, LayoutPrototype.class.getName(), layoutPrototype.getLayoutPrototypeId(), 0L, layoutPrototype.getNameMap(), null, 0, true, 0, friendlyURL, false, true, null);
        if (GetterUtil.getBoolean((Object)serviceContext.getAttribute("addDefaultLayout"), (boolean)true)) {
            this._layoutLocalService.addLayout(userId, group.getGroupId(), true, 0L, layoutPrototype.getNameMap(), null, null, null, null, "portlet", "", false, (Map)HashMapBuilder.put((Object)LocaleUtil.getSiteDefault(), (Object)"/layout").build(), serviceContext);
        }
        return layoutPrototype;
    }

    @Override
    @SystemEvent(action=1, type=1)
    public LayoutPrototype deleteLayoutPrototype(LayoutPrototype layoutPrototype) throws PortalException {
        int count;
        if (!PortalInstances.isCurrentCompanyInDeletionProcess() && (count = this._layoutPersistence.countByC_L(layoutPrototype.getCompanyId(), layoutPrototype.getUuid())) > 0) {
            throw new RequiredLayoutPrototypeException(StringBundler.concat((Object[])new Object[]{"Layout prototype cannot be deleted because it is ", "used by layout with company ID ", layoutPrototype.getCompanyId(), " and layout prototype UUID ", layoutPrototype.getUuid()}));
        }
        this._groupLocalService.deleteGroup(layoutPrototype.getGroup());
        this._resourceLocalService.deleteResource(layoutPrototype.getCompanyId(), LayoutPrototype.class.getName(), 4, layoutPrototype.getLayoutPrototypeId());
        this.layoutPrototypePersistence.remove((BaseModel)layoutPrototype);
        return layoutPrototype;
    }

    @Override
    public LayoutPrototype deleteLayoutPrototype(long layoutPrototypeId) throws PortalException {
        LayoutPrototype layoutPrototype = this.layoutPrototypePersistence.findByPrimaryKey(layoutPrototypeId);
        return this.layoutPrototypeLocalService.deleteLayoutPrototype(layoutPrototype);
    }

    public void deleteNondefaultLayoutPrototypes(long companyId) throws PortalException {
        long defaultUserId = this._userLocalService.getDefaultUserId(companyId);
        List layoutPrototypes = this.layoutPrototypePersistence.findByCompanyId(companyId);
        for (LayoutPrototype layoutPrototype : layoutPrototypes) {
            if (layoutPrototype.getUserId() == defaultUserId) continue;
            this.layoutPrototypeLocalService.deleteLayoutPrototype(layoutPrototype);
        }
    }

    public LayoutPrototype fetchLayoutPrototype(long companyId, String name, Locale locale) {
        List layoutPrototypes = this.layoutPrototypePersistence.findByCompanyId(companyId);
        for (LayoutPrototype layoutPrototype : layoutPrototypes) {
            String layoutPrototypeName = layoutPrototype.getName(locale);
            if (!layoutPrototypeName.equals(name)) continue;
            return layoutPrototype;
        }
        return null;
    }

    public LayoutPrototype fetchLayoutProtoype(long companyId, String name) {
        return this.layoutPrototypeLocalService.fetchLayoutPrototype(companyId, name, LocaleUtil.getDefault());
    }

    public LayoutPrototype getLayoutPrototype(long companyId, String name) throws PortalException {
        return this.layoutPrototypeLocalService.getLayoutPrototype(companyId, name, LocaleUtil.getDefault());
    }

    public LayoutPrototype getLayoutPrototype(long companyId, String name, Locale locale) throws PortalException {
        LayoutPrototype layoutPrototype = this.layoutPrototypeLocalService.fetchLayoutPrototype(companyId, name, locale);
        if (layoutPrototype == null) {
            throw new NoSuchLayoutPrototypeException();
        }
        return layoutPrototype;
    }

    public List<LayoutPrototype> search(long companyId, Boolean active, int start, int end, OrderByComparator<LayoutPrototype> orderByComparator) {
        if (active != null) {
            return this.layoutPrototypePersistence.findByC_A(companyId, active.booleanValue(), start, end, orderByComparator);
        }
        return this.layoutPrototypePersistence.findByCompanyId(companyId, start, end, orderByComparator);
    }

    public int searchCount(long companyId, Boolean active) {
        if (active != null) {
            return this.layoutPrototypePersistence.countByC_A(companyId, active.booleanValue());
        }
        return this.layoutPrototypePersistence.countByCompanyId(companyId);
    }

    public LayoutPrototype updateLayoutPrototype(long layoutPrototypeId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, ServiceContext serviceContext) throws PortalException {
        LayoutPrototype layoutPrototype = this.layoutPrototypePersistence.findByPrimaryKey(layoutPrototypeId);
        layoutPrototype.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        layoutPrototype.setNameMap(nameMap);
        layoutPrototype.setDescriptionMap(descriptionMap);
        layoutPrototype.setActive(active);
        layoutPrototype = (LayoutPrototype)this.layoutPrototypePersistence.update((BaseModel)layoutPrototype);
        Layout layout = layoutPrototype.getLayout();
        layout.setModifiedDate(layoutPrototype.getModifiedDate());
        layout.setNameMap(nameMap);
        this._layoutPersistence.update((BaseModel)layout);
        return layoutPrototype;
    }
}

