/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.service.LayoutSetPrototypeLocalServiceUtil;
import com.liferay.portal.kernel.service.persistence.LayoutSetPrototypeUtil;
import com.liferay.portal.kernel.service.persistence.LayoutSetUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;

public class LayoutSetPrototypeLayoutSetModelListener
extends BaseModelListener<LayoutSet> {
    private static final Log _log = LogFactoryUtil.getLog(LayoutSetPrototypeLayoutSetModelListener.class);

    public void onAfterUpdate(LayoutSet originalLayoutSet, LayoutSet layoutSet) {
        if (layoutSet == null) {
            return;
        }
        Group group = null;
        try {
            group = layoutSet.getGroup();
            if (!group.isLayoutSetPrototype()) {
                return;
            }
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return;
        }
        try {
            UnicodeProperties originalSettingsUnicodeProperties;
            int originalMergeFailCount;
            LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototype((long)group.getClassPK());
            layoutSetPrototype.setModifiedDate(layoutSet.getModifiedDate());
            LayoutSetPrototypeUtil.update((LayoutSetPrototype)layoutSetPrototype);
            UnicodeProperties settingsUnicodeProperties = layoutSet.getSettingsProperties();
            if (settingsUnicodeProperties == null || !settingsUnicodeProperties.containsKey((Object)"merge-fail-count")) {
                return;
            }
            int mergeFailCount = GetterUtil.getInteger((String)settingsUnicodeProperties.getProperty("merge-fail-count"));
            if (mergeFailCount == (originalMergeFailCount = GetterUtil.getInteger((String)(originalSettingsUnicodeProperties = originalLayoutSet.getSettingsProperties()).getProperty("merge-fail-count"))) || mergeFailCount == 0) {
                settingsUnicodeProperties.remove((Object)"merge-fail-count");
                LayoutSetUtil.updateImpl((LayoutSet)layoutSet);
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
    }
}

