/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ListTypeConstants;
import com.liferay.portal.kernel.model.OrgLabor;
import com.liferay.portal.kernel.service.ListTypeLocalService;
import com.liferay.portal.service.base.OrgLaborLocalServiceBaseImpl;
import java.util.List;

public class OrgLaborLocalServiceImpl
extends OrgLaborLocalServiceBaseImpl {
    @BeanReference(type=ListTypeLocalService.class)
    private ListTypeLocalService _listTypeLocalService;

    public OrgLabor addOrgLabor(long organizationId, long listTypeId, int sunOpen, int sunClose, int monOpen, int monClose, int tueOpen, int tueClose, int wedOpen, int wedClose, int thuOpen, int thuClose, int friOpen, int friClose, int satOpen, int satClose) throws PortalException {
        this.validate(listTypeId);
        long orgLaborId = this.counterLocalService.increment();
        OrgLabor orgLabor = this.orgLaborPersistence.create(orgLaborId);
        orgLabor.setOrganizationId(organizationId);
        orgLabor.setListTypeId(listTypeId);
        orgLabor.setSunOpen(sunOpen);
        orgLabor.setSunClose(sunClose);
        orgLabor.setMonOpen(monOpen);
        orgLabor.setMonClose(monClose);
        orgLabor.setTueOpen(tueOpen);
        orgLabor.setTueClose(tueClose);
        orgLabor.setWedOpen(wedOpen);
        orgLabor.setWedClose(wedClose);
        orgLabor.setThuOpen(thuOpen);
        orgLabor.setThuClose(thuClose);
        orgLabor.setFriOpen(friOpen);
        orgLabor.setFriClose(friClose);
        orgLabor.setSatOpen(satOpen);
        orgLabor.setSatClose(satClose);
        return (OrgLabor)this.orgLaborPersistence.update((BaseModel)orgLabor);
    }

    public List<OrgLabor> getOrgLabors(long organizationId) {
        return this.orgLaborPersistence.findByOrganizationId(organizationId);
    }

    public OrgLabor updateOrgLabor(long orgLaborId, long listTypeId, int sunOpen, int sunClose, int monOpen, int monClose, int tueOpen, int tueClose, int wedOpen, int wedClose, int thuOpen, int thuClose, int friOpen, int friClose, int satOpen, int satClose) throws PortalException {
        this.validate(listTypeId);
        OrgLabor orgLabor = this.orgLaborPersistence.findByPrimaryKey(orgLaborId);
        orgLabor.setListTypeId(listTypeId);
        orgLabor.setSunOpen(sunOpen);
        orgLabor.setSunClose(sunClose);
        orgLabor.setMonOpen(monOpen);
        orgLabor.setMonClose(monClose);
        orgLabor.setTueOpen(tueOpen);
        orgLabor.setTueClose(tueClose);
        orgLabor.setWedOpen(wedOpen);
        orgLabor.setWedClose(wedClose);
        orgLabor.setThuOpen(thuOpen);
        orgLabor.setThuClose(thuClose);
        orgLabor.setFriOpen(friOpen);
        orgLabor.setFriClose(friClose);
        orgLabor.setSatOpen(satOpen);
        orgLabor.setSatClose(satClose);
        return (OrgLabor)this.orgLaborPersistence.update((BaseModel)orgLabor);
    }

    protected void validate(long listTypeId) throws PortalException {
        this._listTypeLocalService.validate(listTypeId, ListTypeConstants.ORGANIZATION_SERVICE);
    }
}

