/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.osgi.service.tracker.collections.EagerServiceTrackerCustomizer;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.jsonwebservice.JSONWebService;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceMode;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.BaseModelPermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionRegistryUtil;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionUtil;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.TeamLocalService;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.service.permission.TeamPermissionUtil;
import com.liferay.portal.kernel.service.persistence.RolePersistence;
import com.liferay.portal.kernel.service.persistence.TeamPersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.service.base.PermissionServiceBaseImpl;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class PermissionServiceImpl
extends PermissionServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(PermissionServiceImpl.class);
    private static final ServiceTrackerMap<String, BaseModelPermissionChecker> _baseModelPermissionCheckers = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)SystemBundleUtil.getBundleContext(), BaseModelPermissionChecker.class, (String)"model.class.name", (ServiceTrackerCustomizer)new EagerServiceTrackerCustomizer<BaseModelPermissionChecker, BaseModelPermissionChecker>(){

        public BaseModelPermissionChecker addingService(ServiceReference<BaseModelPermissionChecker> serviceReference) {
            BundleContext bundleContext = SystemBundleUtil.getBundleContext();
            return (BaseModelPermissionChecker)bundleContext.getService(serviceReference);
        }

        public void modifiedService(ServiceReference<BaseModelPermissionChecker> serviceReference, BaseModelPermissionChecker baseModelPermissionChecker) {
        }

        public void removedService(ServiceReference<BaseModelPermissionChecker> serviceReference, BaseModelPermissionChecker baseModelPermissionChecker) {
            BundleContext bundleContext = SystemBundleUtil.getBundleContext();
            bundleContext.ungetService(serviceReference);
        }
    });
    @BeanReference(type=ResourcePermissionLocalService.class)
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @BeanReference(type=RolePersistence.class)
    private RolePersistence _rolePersistence;
    @BeanReference(type=TeamLocalService.class)
    private TeamLocalService _teamLocalService;
    @BeanReference(type=TeamPersistence.class)
    private TeamPersistence _teamPersistence;

    @JSONWebService(mode=JSONWebServiceMode.IGNORE)
    @Transactional(readOnly=true)
    public void checkPermission(long groupId, String name, long primKey) throws PortalException {
        this.checkPermission(this.getPermissionChecker(), groupId, name, String.valueOf(primKey));
    }

    @Transactional(readOnly=true)
    public void checkPermission(long groupId, String name, String primKey) throws PortalException {
        this.checkPermission(this.getPermissionChecker(), groupId, name, primKey);
    }

    protected boolean checkBaseModelPermission(PermissionChecker permissionChecker, long groupId, String className, long classPK) throws PortalException {
        ModelResourcePermission modelResourcePermission;
        String actionId = "PERMISSIONS";
        if (className.equals(Team.class.getName())) {
            className = Group.class.getName();
            Team team = this._teamLocalService.fetchTeam(classPK);
            classPK = team.getGroupId();
            actionId = "MANAGE_TEAMS";
        }
        if ((modelResourcePermission = ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)className)) != null) {
            PortletResourcePermission portletResourcePermission = modelResourcePermission.getPortletResourcePermission();
            if (portletResourcePermission == null) {
                modelResourcePermission.check(permissionChecker, classPK, actionId);
                return true;
            }
            ModelResourcePermissionUtil.check((ModelResourcePermission)modelResourcePermission, (PermissionChecker)permissionChecker, (long)groupId, (long)classPK, (String)actionId);
            return true;
        }
        BaseModelPermissionChecker baseModelPermissionChecker = (BaseModelPermissionChecker)_baseModelPermissionCheckers.getService((Object)className);
        if (baseModelPermissionChecker != null) {
            baseModelPermissionChecker.checkBaseModel(permissionChecker, groupId, classPK, actionId);
            return true;
        }
        return false;
    }

    protected void checkPermission(PermissionChecker permissionChecker, long groupId, String name, String primKey) throws PortalException {
        if (this.checkBaseModelPermission(permissionChecker, groupId, name, GetterUtil.getLong((String)primKey))) {
            return;
        }
        if (primKey != null && primKey.contains("_LAYOUT_")) {
            int pos = primKey.indexOf("_LAYOUT_");
            long plid = GetterUtil.getLong((String)primKey.substring(0, pos));
            String portletId = primKey.substring(pos + "_LAYOUT_".length());
            PortletPermissionUtil.check((PermissionChecker)permissionChecker, (long)groupId, (long)plid, (String)portletId, (String)"CONFIGURATION");
        } else if (!permissionChecker.hasPermission(groupId, name, primKey, "PERMISSIONS")) {
            block13: {
                AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)name);
                if (assetRendererFactory != null) {
                    try {
                        if (assetRendererFactory.hasPermission(permissionChecker, GetterUtil.getLong((String)primKey), "PERMISSIONS")) {
                            return;
                        }
                    }
                    catch (Exception exception) {
                        if (!_log.isDebugEnabled()) break block13;
                        _log.debug((Throwable)exception);
                    }
                }
            }
            ResourcePermission resourcePermission = this._resourcePermissionLocalService.getResourcePermission(permissionChecker.getCompanyId(), name, 4, primKey, permissionChecker.getOwnerRoleId());
            if (permissionChecker.hasOwnerPermission(permissionChecker.getCompanyId(), name, primKey, resourcePermission.getOwnerId(), "PERMISSIONS")) {
                return;
            }
            Role role = null;
            if (name.equals(Role.class.getName())) {
                long roleId = GetterUtil.getLong((String)primKey);
                role = this._rolePersistence.findByPrimaryKey(roleId);
            }
            if (role != null && role.isTeam()) {
                Team team = this._teamPersistence.findByPrimaryKey(role.getClassPK());
                TeamPermissionUtil.check((PermissionChecker)permissionChecker, (Team)team, (String)"PERMISSIONS");
            } else {
                List resourceActions = ResourceActionsUtil.getResourceActions((String)name);
                if (!resourceActions.contains("DEFINE_PERMISSIONS") || !permissionChecker.hasPermission(groupId, name, primKey, "DEFINE_PERMISSIONS")) {
                    throw new PrincipalException.MustHavePermission(permissionChecker, name, Long.valueOf(primKey).longValue(), new String[]{"DEFINE_PERMISSIONS"});
                }
            }
        }
    }
}

