/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.FromStep;
import com.liferay.petra.sql.dsl.query.JoinStep;
import com.liferay.petra.sql.dsl.query.OrderByStep;
import com.liferay.petra.sql.dsl.query.sort.OrderByInfo;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.DuplicateRegionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.RegionCodeException;
import com.liferay.portal.kernel.exception.RegionNameException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.OrganizationTable;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.model.RegionLocalizationTable;
import com.liferay.portal.kernel.model.RegionTable;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.AddressLocalService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.persistence.CountryPersistence;
import com.liferay.portal.kernel.service.persistence.OrganizationPersistence;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.base.RegionLocalServiceBaseImpl;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RegionLocalServiceImpl
extends RegionLocalServiceBaseImpl {
    @BeanReference(type=AddressLocalService.class)
    private AddressLocalService _addressLocalService;
    @BeanReference(type=CountryPersistence.class)
    private CountryPersistence _countryPersistence;
    @BeanReference(type=OrganizationLocalService.class)
    private OrganizationLocalService _organizationLocalService;
    @BeanReference(type=OrganizationPersistence.class)
    private OrganizationPersistence _organizationPersistence;
    @BeanReference(type=UserLocalService.class)
    private UserLocalService _userLocalService;

    public Region addRegion(long countryId, boolean active, String name, double position, String regionCode, ServiceContext serviceContext) throws PortalException {
        this._countryPersistence.findByPrimaryKey(countryId);
        this._validate(-1L, countryId, name, regionCode);
        long regionId = this.counterLocalService.increment();
        Region region = this.regionPersistence.create(regionId);
        region.setCompanyId(serviceContext.getCompanyId());
        User user = this._userLocalService.getUser(serviceContext.getUserId());
        region.setUserId(user.getUserId());
        region.setUserName(user.getFullName());
        region.setCountryId(countryId);
        region.setActive(active);
        region.setName(name);
        region.setPosition(position);
        region.setRegionCode(regionCode);
        return (Region)this.regionPersistence.update((BaseModel)region);
    }

    public void deleteCountryRegions(long countryId) {
        for (Region region : this.getRegions(countryId, -1, -1, null)) {
            this.deleteRegion(region);
        }
    }

    @Override
    public Region deleteRegion(long regionId) throws PortalException {
        Region region = this.regionPersistence.findByPrimaryKey(regionId);
        return this.deleteRegion(region);
    }

    @Override
    @SystemEvent(type=1)
    public Region deleteRegion(Region region) {
        this.regionPersistence.remove((BaseModel)region);
        this._addressLocalService.deleteRegionAddresses(region.getRegionId());
        for (Organization organization : (List)this._organizationPersistence.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Table)OrganizationTable.INSTANCE).from((Table)OrganizationTable.INSTANCE).where(OrganizationTable.INSTANCE.regionId.eq((Object)region.getRegionId())))) {
            organization.setRegionId(0L);
            this._organizationLocalService.updateOrganization(organization);
        }
        return region;
    }

    public Region fetchRegion(long countryId, String regionCode) {
        return this.regionPersistence.fetchByC_R(countryId, regionCode);
    }

    public Region getRegion(long countryId, String regionCode) throws PortalException {
        return this.regionPersistence.findByC_R(countryId, regionCode);
    }

    public List<Region> getRegions(long countryId, boolean active) throws PortalException {
        return this.regionPersistence.findByC_A(countryId, active);
    }

    public List<Region> getRegions(long countryId, boolean active, int start, int end, OrderByComparator<Region> orderByComparator) {
        return this.regionPersistence.findByC_A(countryId, active, start, end, orderByComparator);
    }

    public List<Region> getRegions(long countryId, int start, int end, OrderByComparator<Region> orderByComparator) {
        return this.regionPersistence.findByCountryId(countryId, start, end, orderByComparator);
    }

    public List<Region> getRegions(long companyId, String a2, boolean active) throws PortalException {
        Country country = this._countryPersistence.findByC_A2(companyId, a2);
        return this.regionPersistence.findByC_A(country.getCountryId(), active);
    }

    public int getRegionsCount(long countryId) {
        return this.regionPersistence.countByCountryId(countryId);
    }

    public int getRegionsCount(long countryId, boolean active) {
        return this.regionPersistence.countByC_A(countryId, active);
    }

    public BaseModelSearchResult<Region> searchRegions(long companyId, Boolean active, String keywords, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<Region> orderByComparator) throws PortalException {
        return BaseModelSearchResult.unsafeCreateWithStartAndEnd(startAndEnd -> (List)this.regionPersistence.dslQuery(this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)RegionTable.INSTANCE), companyId, active, keywords, params).orderBy((Table)RegionTable.INSTANCE, (OrderByInfo)orderByComparator).limit(startAndEnd.getStart(), startAndEnd.getEnd())), (int)this.regionPersistence.dslQueryCount((DSLQuery)this._getGroupByStep(DSLQueryFactoryUtil.countDistinct((Expression)RegionTable.INSTANCE.regionId), companyId, active, keywords, params)), (int)start, (int)end);
    }

    public Region updateActive(long regionId, boolean active) throws PortalException {
        Region region = this.regionPersistence.findByPrimaryKey(regionId);
        region.setActive(active);
        return (Region)this.regionPersistence.update((BaseModel)region);
    }

    public Region updateRegion(long regionId, boolean active, String name, double position, String regionCode) throws PortalException {
        Region region = this.regionPersistence.findByPrimaryKey(regionId);
        this._validate(regionId, region.getCountryId(), name, regionCode);
        region.setActive(active);
        region.setName(name);
        region.setPosition(position);
        region.setRegionCode(regionCode);
        return (Region)this.regionPersistence.update((BaseModel)region);
    }

    private OrderByStep _getGroupByStep(FromStep fromStep, long companyId, Boolean active, String keywords, LinkedHashMap<String, Object> params) {
        JoinStep joinStep = fromStep.from((Table)RegionTable.INSTANCE).leftJoinOn((Table)RegionLocalizationTable.INSTANCE, RegionTable.INSTANCE.regionId.eq((Expression)RegionLocalizationTable.INSTANCE.regionId));
        return joinStep.where(RegionTable.INSTANCE.companyId.eq((Object)companyId).and(() -> {
            if (active == null) {
                return null;
            }
            return RegionTable.INSTANCE.active.eq((Object)active);
        }).and(() -> {
            if (Validator.isNull((String)keywords)) {
                return null;
            }
            Predicate keywordsPredicate = null;
            for (String keyword : CustomSQLUtil.keywords((String)keywords, (boolean)true)) {
                for (Column column : new Column[]{RegionTable.INSTANCE.name, RegionTable.INSTANCE.regionCode, RegionLocalizationTable.INSTANCE.title}) {
                    keywordsPredicate = Predicate.or(keywordsPredicate, (Predicate)DSLFunctionFactoryUtil.lower((Expression)column).like(keyword));
                }
            }
            return Predicate.withParentheses(keywordsPredicate);
        }).and(() -> {
            if (MapUtil.isEmpty((Map)params)) {
                return null;
            }
            long countryId = (Long)params.get("countryId");
            if (countryId > 0L) {
                return RegionTable.INSTANCE.countryId.eq((Object)countryId);
            }
            return null;
        }));
    }

    private void _validate(long regionId, long countryId, String name, String regionCode) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new RegionNameException("Name is null");
        }
        if (Validator.isNull((String)regionCode)) {
            throw new RegionCodeException("Region code is null");
        }
        if (CompanyThreadLocal.isInitializingPortalInstance()) {
            return;
        }
        Region region = this.fetchRegion(countryId, regionCode);
        if (region != null && region.getRegionId() != regionId) {
            throw new DuplicateRegionException("Region code belongs to another region");
        }
    }
}

