/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.petra.concurrent.DCLSingleton;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBContext;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBProcessContext;
import com.liferay.portal.kernel.exception.OldServiceComponentException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.model.ServiceComponent;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.service.ReleaseLocalService;
import com.liferay.portal.kernel.service.configuration.ServiceComponentConfiguration;
import com.liferay.portal.kernel.service.configuration.servlet.ServletServiceContextComponentConfiguration;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.upgrade.util.UpgradeColumn;
import com.liferay.portal.kernel.upgrade.util.UpgradeTable;
import com.liferay.portal.kernel.upgrade.util.UpgradeTableFactoryUtil;
import com.liferay.portal.kernel.upgrade.util.UpgradeTableListener;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.portal.service.base.ServiceComponentLocalServiceBaseImpl;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServiceComponentLocalServiceImpl
extends ServiceComponentLocalServiceBaseImpl {
    private static final String _DATA_SOURCE_DEFAULT = "liferayDataSource";
    private static final int _SERVICE_COMPONENTS_MAX = 10;
    private static final Log _log = LogFactoryUtil.getLog(ServiceComponentLocalServiceImpl.class);
    private final BundleContext _bundleContext = SystemBundleUtil.getBundleContext();
    @BeanReference(type=ReleaseLocalService.class)
    private ReleaseLocalService _releaseLocalService;
    private final DCLSingleton<Map<String, ServiceComponent>> _serviceComponentsDCLSingleton = new DCLSingleton();
    private final ServiceTracker<UpgradeStep, UpgradeStepHolder> _upgradeStepServiceTracker;

    public ServiceComponentLocalServiceImpl() {
        Filter filter = SystemBundleUtil.createFilter((String)StringBundler.concat((String[])new String[]{"(&(objectClass=", UpgradeStep.class.getName(), ")(upgrade.from.schema.version=0.0.0)(upgrade.initial.", "database.creation=true))"}));
        this._upgradeStepServiceTracker = new ServiceTracker(this._bundleContext, filter, (ServiceTrackerCustomizer)new UpgradeStepServiceTrackerCustomizer());
        this._upgradeStepServiceTracker.open();
    }

    @Override
    public void destroy() {
        super.destroy();
        this._upgradeStepServiceTracker.close();
    }

    public List<ServiceComponent> getLatestServiceComponents() {
        return this.serviceComponentFinder.findByMaxBuildNumber();
    }

    public ServiceComponent initServiceComponent(ServiceComponentConfiguration serviceComponentConfiguration, ClassLoader classLoader, String buildNamespace, long buildNumber, long buildDate) throws PortalException {
        long serviceComponentId;
        try {
            ModelHintsUtil.read((ClassLoader)classLoader, (InputStream)serviceComponentConfiguration.getModelHintsInputStream());
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        try {
            ModelHintsUtil.read((ClassLoader)classLoader, (InputStream)serviceComponentConfiguration.getModelHintsExtInputStream());
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        long previousBuildNumber = 0L;
        ServiceComponent previousServiceComponent = null;
        Map serviceComponents = (Map)this._serviceComponentsDCLSingleton.getSingleton(this::_createServiceComponents);
        ServiceComponent serviceComponent = (ServiceComponent)serviceComponents.get(buildNamespace);
        if (serviceComponent == null) {
            serviceComponentId = this.counterLocalService.increment();
            serviceComponent = this.serviceComponentPersistence.create(serviceComponentId);
            serviceComponent.setBuildNamespace(buildNamespace);
            serviceComponent.setBuildNumber(buildNumber);
            serviceComponent.setBuildDate(buildDate);
        } else {
            List currentServiceComponents;
            ServiceComponent currentServiceComponent;
            long currentBuildNumber;
            previousBuildNumber = serviceComponent.getBuildNumber();
            if (previousBuildNumber < buildNumber && (currentBuildNumber = (currentServiceComponent = (ServiceComponent)(currentServiceComponents = this.serviceComponentPersistence.findByBuildNamespace(buildNamespace, 0, 1)).get(0)).getBuildNumber()) > previousBuildNumber) {
                serviceComponent = currentServiceComponent;
                previousBuildNumber = currentBuildNumber;
                serviceComponents.put(buildNamespace, serviceComponent);
            }
            if (previousBuildNumber < buildNumber) {
                previousServiceComponent = serviceComponent;
                serviceComponentId = this.counterLocalService.increment();
                serviceComponent = this.serviceComponentPersistence.create(serviceComponentId);
                serviceComponent.setBuildNamespace(buildNamespace);
                serviceComponent.setBuildNumber(buildNumber);
                serviceComponent.setBuildDate(buildDate);
            } else {
                if (previousBuildNumber > buildNumber) {
                    throw new OldServiceComponentException(StringBundler.concat((Object[])new Object[]{"Build namespace ", buildNamespace, " has build number ", previousBuildNumber, " which is newer than ", buildNumber}));
                }
                return serviceComponent;
            }
        }
        try {
            Document document = SAXReaderUtil.createDocument((String)"UTF-8");
            Element dataElement = document.addElement("data");
            Element tablesSQLElement = dataElement.addElement("tables-sql");
            String tablesSQL = StringUtil.read((InputStream)serviceComponentConfiguration.getSQLTablesInputStream());
            tablesSQLElement.addCDATA(tablesSQL);
            Element sequencesSQLElement = dataElement.addElement("sequences-sql");
            String sequencesSQL = StringUtil.read((InputStream)serviceComponentConfiguration.getSQLSequencesInputStream());
            sequencesSQLElement.addCDATA(sequencesSQL);
            Element indexesSQLElement = dataElement.addElement("indexes-sql");
            String indexesSQL = StringUtil.read((InputStream)serviceComponentConfiguration.getSQLIndexesInputStream());
            indexesSQLElement.addCDATA(indexesSQL);
            String dataXML = document.formattedString();
            serviceComponent.setData(dataXML);
            serviceComponent = (ServiceComponent)this.serviceComponentPersistence.update((BaseModel)serviceComponent);
            if (serviceComponentConfiguration instanceof ServletServiceContextComponentConfiguration && previousServiceComponent == null || previousBuildNumber < buildNumber && previousServiceComponent != null) {
                this.serviceComponentLocalService.upgradeDB(classLoader, buildNamespace, buildNumber, previousServiceComponent, tablesSQL, sequencesSQL, indexesSQL);
            }
            serviceComponents.put(buildNamespace, serviceComponent);
            this.removeOldServiceComponents(buildNamespace);
            return serviceComponent;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public void upgradeDB(ClassLoader classLoader, String buildNamespace, long buildNumber, ServiceComponent previousServiceComponent, String tablesSQL, String sequencesSQL, String indexesSQL) throws Exception {
        this._upgradeDB(classLoader, buildNamespace, buildNumber, previousServiceComponent, tablesSQL, sequencesSQL, indexesSQL);
    }

    public void verifyDB() {
        for (Object service : this._upgradeStepServiceTracker.getServices()) {
            UpgradeStepHolder upgradeStepHolder = (UpgradeStepHolder)service;
            String servletContextName = upgradeStepHolder._servletContextName;
            Release release = this._releaseLocalService.fetchRelease(upgradeStepHolder._servletContextName);
            if (release != null && !Objects.equals(release.getSchemaVersion(), "0.0.0")) continue;
            try {
                UpgradeStep upgradeStep = upgradeStepHolder._upgradeStep;
                upgradeStep.upgrade(new DBProcessContext(){

                    public DBContext getDBContext() {
                        return new DBContext();
                    }

                    public OutputStream getOutputStream() {
                        return null;
                    }
                });
                this._releaseLocalService.updateRelease(servletContextName, "0.0.1", "0.0.0");
                release = this._releaseLocalService.fetchRelease(servletContextName);
                int buildNumber = upgradeStepHolder._buildNumber;
                release.setBuildNumber(buildNumber);
                this._releaseLocalService.updateRelease(release);
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
        }
    }

    protected List<String> getModelNames(ClassLoader classLoader) throws DocumentException, IOException {
        ArrayList<String> modelNames;
        block2: {
            modelNames = new ArrayList<String>();
            String xml = StringUtil.read((ClassLoader)classLoader, (String)"META-INF/portlet-model-hints.xml");
            modelNames.addAll(this.getModelNames(xml));
            try {
                xml = StringUtil.read((ClassLoader)classLoader, (String)"META-INF/portlet-model-hints-ext.xml");
                modelNames.addAll(this.getModelNames(xml));
            }
            catch (Exception exception) {
                if (!_log.isInfoEnabled()) break block2;
                _log.info((Object)"No optional file META-INF/portlet-model-hints-ext.xml found", (Throwable)exception);
            }
        }
        return modelNames;
    }

    protected List<String> getModelNames(String xml) throws DocumentException {
        ArrayList<String> modelNames = new ArrayList<String>();
        Document document = UnsecureSAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        List modelElements = rootElement.elements("model");
        for (Element modelElement : modelElements) {
            String name = modelElement.attributeValue("name");
            modelNames.add(name);
        }
        return modelNames;
    }

    protected List<String> getModifiedTableNames(String previousTablesSQL, String tablesSQL) {
        ArrayList<String> modifiedTableNames = new ArrayList<String>();
        List previousTablesSQLParts = ListUtil.fromArray((Object[])StringUtil.split((String)previousTablesSQL, (String)";"));
        List tablesSQLParts = ListUtil.fromArray((Object[])StringUtil.split((String)tablesSQL, (String)";"));
        tablesSQLParts.removeAll(previousTablesSQLParts);
        for (String tablesSQLPart : tablesSQLParts) {
            int x = tablesSQLPart.indexOf("create table ");
            int y = tablesSQLPart.indexOf(" (");
            modifiedTableNames.add(tablesSQLPart.substring(x + 13, y));
        }
        return modifiedTableNames;
    }

    protected UpgradeTableListener getUpgradeTableListener(ClassLoader classLoader, Class<?> modelClass) {
        String modelClassName;
        String upgradeTableListenerClassName = modelClassName = modelClass.getName();
        upgradeTableListenerClassName = StringUtil.replaceLast((String)upgradeTableListenerClassName, (String)".model.impl.", (String)".model.upgrade.");
        upgradeTableListenerClassName = StringUtil.replaceLast((String)upgradeTableListenerClassName, (String)"ModelImpl", (String)"UpgradeTableListener");
        try {
            UpgradeTableListener upgradeTableListener = (UpgradeTableListener)InstanceFactory.newInstance((ClassLoader)classLoader, (String)upgradeTableListenerClassName);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Instantiated " + upgradeTableListenerClassName));
            }
            return upgradeTableListener;
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to instantiate " + upgradeTableListenerClassName), (Throwable)exception);
            }
            return null;
        }
    }

    protected void removeOldServiceComponents(String buildNamespace) {
        int serviceComponentsCount = this.serviceComponentPersistence.countByBuildNamespace(buildNamespace);
        if (serviceComponentsCount < 10) {
            return;
        }
        List serviceComponents = this.serviceComponentPersistence.findByBuildNamespace(buildNamespace, 10, serviceComponentsCount);
        for (ServiceComponent serviceComponent : serviceComponents) {
            this.serviceComponentPersistence.remove((BaseModel)serviceComponent);
        }
    }

    protected void upgradeModels(ClassLoader classLoader, ServiceComponent previousServiceComponent, String tablesSQL) throws Exception {
        List<String> modifiedTableNames = this.getModifiedTableNames(previousServiceComponent.getTablesSQL(), tablesSQL);
        List<String> modelNames = this.getModelNames(classLoader);
        for (String modelName : modelNames) {
            Field tableNameField;
            String tableName;
            int pos;
            Class<?> modelClass = Class.forName(StringBundler.concat((String[])new String[]{modelName.substring(0, pos = modelName.lastIndexOf(".model.")), ".model.impl.", modelName.substring(pos + 7), "ModelImpl"}), true, classLoader);
            Field dataSourceField = modelClass.getField("DATA_SOURCE");
            String dataSource = (String)dataSourceField.get(null);
            if (!dataSource.equals(_DATA_SOURCE_DEFAULT) || !modifiedTableNames.contains(tableName = (String)(tableNameField = modelClass.getField("TABLE_NAME")).get(null))) continue;
            Field tableColumnsField = modelClass.getField("TABLE_COLUMNS");
            Object[][] tableColumns = (Object[][])tableColumnsField.get(null);
            UpgradeTable upgradeTable = UpgradeTableFactoryUtil.getUpgradeTable((String)tableName, (Object[][])tableColumns, (UpgradeColumn[])new UpgradeColumn[0]);
            UpgradeTableListener upgradeTableListener = this.getUpgradeTableListener(classLoader, modelClass);
            Field tableSQLCreateField = modelClass.getField("TABLE_SQL_CREATE");
            String tableSQLCreate = (String)tableSQLCreateField.get(null);
            upgradeTable.setCreateSQL(tableSQLCreate);
            if (upgradeTableListener != null) {
                upgradeTableListener.onBeforeUpdateTable(previousServiceComponent, upgradeTable);
            }
            upgradeTable.updateTable();
            if (upgradeTableListener == null) continue;
            upgradeTableListener.onAfterUpdateTable(previousServiceComponent, upgradeTable);
        }
    }

    private Map<String, ServiceComponent> _createServiceComponents() {
        ConcurrentHashMap<String, ServiceComponent> serviceComponents = new ConcurrentHashMap<String, ServiceComponent>();
        for (ServiceComponent serviceComponent : this.serviceComponentPersistence.findAll()) {
            String buildNamespace = serviceComponent.getBuildNamespace();
            ServiceComponent previousServiceComponent = (ServiceComponent)serviceComponents.get(buildNamespace);
            if (previousServiceComponent != null && serviceComponent.getBuildNumber() <= previousServiceComponent.getBuildNumber()) continue;
            serviceComponents.put(buildNamespace, serviceComponent);
        }
        return serviceComponents;
    }

    private void _upgradeDB(ClassLoader classLoader, String buildNamespace, long buildNumber, ServiceComponent previousServiceComponent, String tablesSQL, String sequencesSQL, String indexesSQL) throws Exception {
        DB db = DBManagerUtil.getDB();
        if (previousServiceComponent == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Running " + buildNamespace + " SQL scripts"));
            }
            db.runSQLTemplateString(tablesSQL, false);
            db.runSQLTemplateString(sequencesSQL, false);
            db.runSQLTemplateString(indexesSQL, false);
        } else if (PropsValues.SCHEMA_MODULE_BUILD_AUTO_UPGRADE) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Auto upgrading ", buildNamespace, " database to build number ", buildNumber, " is not supported for a production environment. ", "Write an UpgradeStep to ensure data is upgraded ", "correctly."}));
            }
            if (!tablesSQL.equals(previousServiceComponent.getTablesSQL())) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"Upgrading database with tables.sql");
                }
                db.runSQLTemplateString(tablesSQL, false);
                this.upgradeModels(classLoader, previousServiceComponent, tablesSQL);
            }
            if (!sequencesSQL.equals(previousServiceComponent.getSequencesSQL())) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"Upgrading database with sequences.sql");
                }
                db.runSQLTemplateString(sequencesSQL, false);
            }
            if (!indexesSQL.equals(previousServiceComponent.getIndexesSQL()) || !tablesSQL.equals(previousServiceComponent.getTablesSQL())) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"Upgrading database with indexes.sql");
                }
                db.runSQLTemplateString(indexesSQL, false);
            }
        }
    }

    private class UpgradeStepServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<UpgradeStep, UpgradeStepHolder> {
        private UpgradeStepServiceTrackerCustomizer() {
        }

        public UpgradeStepHolder addingService(ServiceReference<UpgradeStep> serviceReference) {
            String servletContextName = (String)serviceReference.getProperty("upgrade.bundle.symbolic.name");
            int buildNumber = GetterUtil.getInteger((Object)serviceReference.getProperty("build.number"));
            UpgradeStep upgradeStep = (UpgradeStep)ServiceComponentLocalServiceImpl.this._bundleContext.getService(serviceReference);
            return new UpgradeStepHolder(servletContextName, buildNumber, upgradeStep);
        }

        public void modifiedService(ServiceReference<UpgradeStep> serviceReference, UpgradeStepHolder upgradeStepHolder) {
            this.addingService((ServiceReference)serviceReference);
        }

        public void removedService(ServiceReference<UpgradeStep> serviceReference, UpgradeStepHolder upgradeStepHolder) {
            ServiceComponentLocalServiceImpl.this._bundleContext.ungetService(serviceReference);
        }
    }

    private static class UpgradeStepHolder {
        private final int _buildNumber;
        private final String _servletContextName;
        private final UpgradeStep _upgradeStep;

        private UpgradeStepHolder(String servletContextName, int buildNumber, UpgradeStep upgradeStep) {
            this._servletContextName = servletContextName;
            this._buildNumber = buildNumber;
            this._upgradeStep = upgradeStep;
        }
    }
}

